/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij3d.Volume;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.List;

public class AreaListVolume
extends Volume {
    private final List<List<Area>> areas;

    public AreaListVolume(List<List<Area>> areas, double zSpacing, double xOrigin, double yOrigin, double zOrigin) {
        this.areas = areas;
        this.ph = 1.0;
        this.pw = 1.0;
        this.pd = zSpacing;
        this.minCoord.x = xOrigin;
        this.minCoord.y = yOrigin;
        this.minCoord.z = zOrigin;
        Rectangle bounds = new Rectangle();
        for (List<Area> list : areas) {
            if (list == null) continue;
            for (Area area : list) {
                if (area == null) continue;
                bounds.add(area.getBounds());
            }
        }
        this.xDim = bounds.width;
        this.yDim = bounds.height;
        this.zDim = areas.size();
        this.maxCoord.x = this.minCoord.x + (double)this.xDim * this.pw;
        this.maxCoord.y = this.minCoord.y + (double)this.yDim * this.ph;
        this.maxCoord.z = this.minCoord.z + (double)this.zDim * this.pd;
    }

    public List<List<Area>> getAreas() {
        return this.areas;
    }

    @Override
    protected void initLoader() {
    }

    @Override
    public boolean setAverage(boolean a) {
        return false;
    }

    @Override
    public void setNoCheck(int x, int y, int z, int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int x, int y, int z, int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int load(int x, int y, int z) {
        if (z < 0 || z >= this.areas.size()) {
            return 0;
        }
        List<Area> list = this.areas.get(z);
        if (list == null) {
            return 0;
        }
        for (Area area : list) {
            if (!area.contains(x, y)) continue;
            return 255;
        }
        return 0;
    }

    @Override
    public int getDataType() {
        return 1;
    }
}

