/*
 * Decompiled with CFR 0.152.
 */
package surfaceplot;

import ij.ImagePlus;
import ij.gui.StackWindow;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.Volume;
import java.awt.Component;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import surfaceplot.SurfacePlot;
import vib.NaiveResampler;

public class SurfacePlotGroup
extends ContentNode
implements AdjustmentListener {
    private SurfacePlot surfacep;
    private ContentInstant c;
    private final Point3d min = new Point3d();
    private final Point3d max = new Point3d();
    private final Point3d center = new Point3d();

    public SurfacePlotGroup(Content c) {
        this(c.getCurrent());
    }

    public SurfacePlotGroup(ContentInstant c) {
        this.c = c;
        int res = c.getResamplingFactor();
        ImagePlus imp = res == 1 ? c.getImage() : NaiveResampler.resample((ImagePlus)c.getImage(), (int)res, (int)res, (int)1);
        Volume volume = new Volume(imp);
        volume.setChannels(c.getChannels());
        this.surfacep = new SurfacePlot(volume, c.getColor(), c.getTransparency(), c.getImage().getSlice() - 1);
        this.surfacep.calculateMinMaxCenterPoint(this.min, this.max, this.center);
        this.addChild((Node)this.surfacep);
        if (c.getImage().getStackSize() == 1) {
            return;
        }
        StackWindow win = (StackWindow)c.getImage().getWindow();
        if (win == null) {
            return;
        }
        Component[] co = win.getComponents();
        for (int i = 0; i < co.length; ++i) {
            if (!(co[i] instanceof Scrollbar)) continue;
            ((Scrollbar)co[i]).addAdjustmentListener(this);
        }
    }

    public void setSlice(int slice) {
        this.surfacep.setSlice(slice);
    }

    public int getSlice() {
        return this.surfacep.getSlice();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.surfacep.setSlice(((Scrollbar)e.getSource()).getValue());
    }

    @Override
    public void getMax(Tuple3d max) {
        max.set((Tuple3d)this.max);
    }

    @Override
    public void getMin(Tuple3d min) {
        min.set((Tuple3d)this.min);
    }

    @Override
    public void getCenter(Tuple3d center) {
        center.set((Tuple3d)this.center);
    }

    @Override
    public void eyePtChanged(View view) {
    }

    @Override
    public void thresholdUpdated(int threshold) {
    }

    @Override
    public void lutUpdated(int[] r, int[] g, int[] b, int[] a) {
    }

    @Override
    public void channelsUpdated(boolean[] channels) {
        this.surfacep.setChannels(channels);
    }

    @Override
    public float getVolume() {
        if (this.surfacep == null) {
            return -1.0f;
        }
        return 0.0f;
    }

    @Override
    public void colorUpdated(Color3f color) {
        this.surfacep.setColor(color);
    }

    @Override
    public void transparencyUpdated(float transparency) {
        this.surfacep.setTransparency(transparency);
    }

    @Override
    public void shadeUpdated(boolean shaded) {
        this.surfacep.setShaded(shaded);
    }

    @Override
    public void restoreDisplayedData(String path, String name) {
    }

    @Override
    public void clearDisplayedData() {
    }

    @Override
    public void swapDisplayedData(String path, String name) {
    }
}

