/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.Polygon;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3i;
import org.jogamp.vecmath.Tuple4f;
import voltex.VoltexVolume;

public class Mask
extends VoltexVolume {
    private final VoltexVolume image;
    private final BranchGroup node;
    private TextureAttributes maskAttr;
    private BlendMethod colorMethod = BlendMethod.MODULATE;
    private BlendMethod alphaMethod = BlendMethod.REPLACE;
    private final BlendSource[] colorSource = new BlendSource[]{BlendSource.TEXTURE, BlendSource.MASK, BlendSource.COLOR};
    private final BlendSource[] alphaSource = new BlendSource[]{BlendSource.TEXTURE, BlendSource.MASK, BlendSource.COLOR};
    private final Color4f blendColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final int BG = 50;
    private final Point3d locInImagePlate = new Point3d();

    public Mask(VoltexVolume image, BranchGroup node) {
        super(Mask.createMaskImage(image));
        this.image = image;
        this.node = node;
        this.initTextureAttributes();
    }

    private static ImagePlus createMaskImage(VoltexVolume image) {
        ImagePlus maskI = IJ.createImage((String)"Mask", (String)"8-bit white", (int)image.xDim, (int)image.yDim, (int)image.zDim);
        maskI.setCalibration(image.getImagePlus().getCalibration().copy());
        return maskI;
    }

    public TextureAttributes getMaskAttributes() {
        return this.maskAttr;
    }

    public void subtractInverse(Canvas3D canvas, Roi roi) {
        Polygon p = roi.getPolygon();
        Transform3D volToIP = new Transform3D();
        this.volumeToImagePlate(canvas, volToIP);
        Point2d onCanvas = new Point2d();
        Point3i pos = new Point3i(0, 0, 0);
        for (int z = 0; z < this.zDim; ++z) {
            for (int y = 0; y < this.yDim; ++y) {
                for (int x = 0; x < this.xDim; ++x) {
                    this.volumePointInCanvas(canvas, volToIP, x, y, z, onCanvas);
                    if (p.contains(onCanvas.x, onCanvas.y)) continue;
                    this.setNoCheckNoUpdate(x, y, z, 50);
                }
            }
            IJ.showStatus((String)"Filling...");
            IJ.showProgress((int)z, (int)this.zDim);
        }
        this.updateData();
    }

    public void subtract(Canvas3D canvas, Roi roi) {
    }

    public ImagePlus getMask() {
        return this.imp;
    }

    public void cropToMask() {
    }

    public void upateMask() {
    }

    public void setBlendColor(Color4f col) {
        this.blendColor.set((Tuple4f)col);
        this.maskAttr.setTextureBlendColor(this.blendColor);
    }

    public void setColorSource(int index, BlendSource c) {
        this.colorSource[index] = c;
        this.maskAttr.setCombineRgbSource(index, this.colorSource[index].value);
    }

    public BlendSource getColorSource(int index) {
        return this.colorSource[index];
    }

    public void setColorMethod(BlendMethod m) {
        this.colorMethod = m;
        this.maskAttr.setCombineRgbMode(this.colorMethod.value);
    }

    public BlendMethod getColorMethod() {
        return this.colorMethod;
    }

    public void setAlphaSource(int index, BlendSource c) {
        this.alphaSource[index] = c;
        this.maskAttr.setCombineAlphaSource(index, this.alphaSource[index].value);
    }

    public BlendSource getAlphaSource(int index) {
        return this.alphaSource[index];
    }

    public void setAlphaMethod(BlendMethod m) {
        this.alphaMethod = m;
        this.maskAttr.setCombineAlphaMode(this.alphaMethod.value);
    }

    public BlendMethod getAlphaMethod() {
        return this.alphaMethod;
    }

    public void interactivelyChangeBlending() {
        String[] methods = new String[BlendMethod.values().length];
        int i = 0;
        for (BlendMethod bm : BlendMethod.values()) {
            methods[i++] = bm.fullString();
        }
        String[] sources = new String[BlendSource.values().length];
        i = 0;
        for (BlendSource bs : BlendSource.values()) {
            sources[i++] = bs.name();
        }
        GenericDialog gd = new GenericDialog("Blending");
        gd.setInsets(5, 0, 0);
        gd.addMessage("RGB blending parameters:");
        Label l = (Label)gd.getMessage();
        l.setFont(new Font("Helvetica", 1, 12));
        l.setForeground(Color.BLUE);
        gd.addChoice("Color blend method", methods, methods[this.colorMethod.ordinal()]);
        gd.addChoice("C1", sources, sources[this.colorSource[0].ordinal()]);
        gd.addChoice("C2", sources, sources[this.colorSource[1].ordinal()]);
        gd.addChoice("C3", sources, sources[this.colorSource[2].ordinal()]);
        gd.setInsets(5, 0, 0);
        gd.addMessage("Alpha blending parameters:");
        l = (Label)gd.getMessage();
        l.setFont(new Font("Helvetica", 1, 12));
        l.setForeground(Color.BLUE);
        gd.addChoice("Alpha blend method", methods, methods[this.alphaMethod.ordinal()]);
        gd.addChoice("A1", sources, sources[this.alphaSource[0].ordinal()]);
        gd.addChoice("A2", sources, sources[this.alphaSource[1].ordinal()]);
        gd.addChoice("A3", sources, sources[this.alphaSource[2].ordinal()]);
        gd.setInsets(5, 0, 0);
        gd.addMessage("COLOR values:");
        l = (Label)gd.getMessage();
        l.setFont(new Font("Helvetica", 1, 12));
        l.setForeground(Color.BLUE);
        gd.addSlider("Red", 0.0, 255.0, (double)(255.0f * this.blendColor.x));
        gd.addSlider("Green", 0.0, 255.0, (double)(255.0f * this.blendColor.y));
        gd.addSlider("Blue", 0.0, 255.0, (double)(255.0f * this.blendColor.z));
        gd.addSlider("Alpha", 0.0, 255.0, (double)(255.0f * this.blendColor.w));
        Vector choices = gd.getChoices();
        final Choice c1 = (Choice)choices.get(0);
        c1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setColorMethod(BlendMethod.values()[c1.getSelectedIndex()]);
            }
        });
        final Choice c2 = (Choice)choices.get(1);
        c2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setColorSource(0, BlendSource.values()[c2.getSelectedIndex()]);
            }
        });
        final Choice c3 = (Choice)choices.get(2);
        c3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setColorSource(1, BlendSource.values()[c3.getSelectedIndex()]);
            }
        });
        final Choice c4 = (Choice)choices.get(3);
        c4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setColorSource(2, BlendSource.values()[c4.getSelectedIndex()]);
            }
        });
        final Choice c5 = (Choice)choices.get(4);
        c5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setAlphaMethod(BlendMethod.values()[c5.getSelectedIndex()]);
            }
        });
        final Choice c6 = (Choice)choices.get(5);
        c6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setAlphaSource(0, BlendSource.values()[c6.getSelectedIndex()]);
            }
        });
        final Choice c7 = (Choice)choices.get(6);
        c7.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setAlphaSource(1, BlendSource.values()[c7.getSelectedIndex()]);
            }
        });
        final Choice c8 = (Choice)choices.get(7);
        c8.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Mask.this.setAlphaSource(2, BlendSource.values()[c8.getSelectedIndex()]);
            }
        });
        Vector sliders = gd.getSliders();
        final Scrollbar s1 = (Scrollbar)sliders.get(0);
        s1.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ((Mask)Mask.this).blendColor.x = (float)s1.getValue() / 255.0f;
                Mask.this.maskAttr.setTextureBlendColor(Mask.this.blendColor);
            }
        });
        final Scrollbar s2 = (Scrollbar)sliders.get(1);
        s2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ((Mask)Mask.this).blendColor.y = (float)s2.getValue() / 255.0f;
                Mask.this.maskAttr.setTextureBlendColor(Mask.this.blendColor);
            }
        });
        final Scrollbar s3 = (Scrollbar)sliders.get(2);
        s3.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ((Mask)Mask.this).blendColor.z = (float)s3.getValue() / 255.0f;
                Mask.this.maskAttr.setTextureBlendColor(Mask.this.blendColor);
            }
        });
        final Scrollbar s4 = (Scrollbar)sliders.get(3);
        s4.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ((Mask)Mask.this).blendColor.w = (float)s4.getValue() / 255.0f;
                Mask.this.maskAttr.setTextureBlendColor(Mask.this.blendColor);
            }
        });
        gd.setModal(false);
        gd.showDialog();
    }

    public void updateMaskAttributes() {
        this.maskAttr.setCombineRgbMode(this.colorMethod.value);
        this.maskAttr.setCombineRgbSource(0, this.colorSource[0].value);
        this.maskAttr.setCombineRgbSource(1, this.colorSource[1].value);
        this.maskAttr.setCombineRgbSource(2, this.colorSource[2].value);
        this.maskAttr.setCombineAlphaMode(this.alphaMethod.value);
        this.maskAttr.setCombineAlphaSource(0, this.alphaSource[0].value);
        this.maskAttr.setCombineAlphaSource(1, this.alphaSource[1].value);
        this.maskAttr.setCombineAlphaSource(2, this.alphaSource[2].value);
        this.maskAttr.setTextureBlendColor(this.blendColor);
    }

    private void volumePointInCanvas(Canvas3D canvas, Transform3D volToIP, int x, int y, int z, Point2d out) {
        this.locInImagePlate.set((double)x * this.pw, (double)y * this.ph, (double)z * this.pd);
        volToIP.transform(this.locInImagePlate);
        canvas.getPixelLocationFromImagePlate(this.locInImagePlate, out);
    }

    private void volumeToImagePlate(Canvas3D canvas, Transform3D volToIP) {
        canvas.getImagePlateToVworld(volToIP);
        volToIP.invert();
        Transform3D toVWorld = new Transform3D();
        this.node.getLocalToVworld(toVWorld);
        volToIP.mul(toVWorld);
    }

    private void initTextureAttributes() {
        this.maskAttr = new TextureAttributes();
        this.maskAttr.setCapability(3);
        this.maskAttr.setCapability(9);
        this.maskAttr.setTextureMode(6);
        this.maskAttr.setPerspectiveCorrectionMode(1);
        this.updateMaskAttributes();
    }

    public static enum BlendSource {
        TEXTURE(3),
        MASK(1),
        COLOR(2);

        private int value;

        private BlendSource(int v) {
            this.value = v;
        }
    }

    public static enum BlendMethod {
        REPLACE(0, "C = C0"),
        MODULATE(1, "C = C0 C1"),
        ADD(2, "C = C0 + C1"),
        ADD_SIGNED(3, "C = C0 + C1 - 0.5"),
        SUBTRACT(4, "C = C0 - C1"),
        INTERPOLATE(5, "C0 C2 + C1 (1 - C2)");

        private int value;
        private String desc;

        private BlendMethod(int v, String d) {
            this.value = v;
            this.desc = d;
        }

        public String fullString() {
            return this.name() + ": " + this.desc;
        }
    }
}

