/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import process3d.Convolve3d;
import process3d.Smooth_;
import vib.InterpolatedImage;

public class Harris_Corner_Detector
implements PlugInFilter {
    private ImagePlus image;
    private ImagePlus XX;
    private ImagePlus YY;
    private ImagePlus ZZ;
    private ImagePlus XY;
    private ImagePlus XZ;
    private ImagePlus YZ;
    public static final float HARRIS_THRESHOLD = 20.0f;
    public static final float K = 0.14f;

    public Harris_Corner_Detector() {
    }

    public Harris_Corner_Detector(ImagePlus img) {
        this.image = img;
    }

    public void run(ImageProcessor ip) {
        this.findCorners().show();
    }

    public ImagePlus findCorners() {
        this.makeDerivatives();
        ImagePlus imp = this.createCRF();
        imp.show();
        imp = Harris_Corner_Detector.suppressNonMaximum(imp);
        return imp;
    }

    public ImagePlus createCRF() {
        IJ.showStatus((String)"Create crf");
        InterpolatedImage iXX = new InterpolatedImage(this.XX);
        InterpolatedImage iXY = new InterpolatedImage(this.XY);
        InterpolatedImage iXZ = new InterpolatedImage(this.XZ);
        InterpolatedImage iYY = new InterpolatedImage(this.YY);
        InterpolatedImage iYZ = new InterpolatedImage(this.YZ);
        InterpolatedImage iZZ = new InterpolatedImage(this.ZZ);
        InterpolatedImage out = iXX.cloneDimensionsOnly();
        InterpolatedImage.Iterator it = iXX.iterator();
        while (it.next() != null) {
            float gxx = iXX.getNoCheckFloat(it.i, it.j, it.k);
            float gxy = iXY.getNoCheckFloat(it.i, it.j, it.k);
            float gxz = iXZ.getNoCheckFloat(it.i, it.j, it.k);
            float gyy = iYY.getNoCheckFloat(it.i, it.j, it.k);
            float gyz = iYZ.getNoCheckFloat(it.i, it.j, it.k);
            float gzz = iZZ.getNoCheckFloat(it.i, it.j, it.k);
            float tr = gxx + gyy + gzz;
            float det = gxx * (gyy * gyy - gyz * gyz) - gxy * (gxy * gzz - gyz * gxz) + gxz * (gxy * gyz - gyy * gxz);
            float v = det - 0.14f * tr * tr;
            out.setFloat(it.i, it.j, it.k, v);
        }
        this.ZZ = null;
        this.YZ = null;
        this.YY = null;
        this.XZ = null;
        this.XY = null;
        this.XX = null;
        System.gc();
        return out.getImage();
    }

    public void makeDerivatives() {
        IJ.showStatus((String)"Calculate derivatives");
        float sigma = 2.0f;
        float[] H = new float[]{-0.5f, 0.0f, 0.5f};
        ImagePlus smooth = Smooth_.smooth((ImagePlus)this.image, (boolean)true, (float)sigma, (boolean)false);
        ImagePlus dx = Convolve3d.convolveX((ImagePlus)smooth, (float[])H);
        ImagePlus dy = Convolve3d.convolveY((ImagePlus)smooth, (float[])H);
        ImagePlus dz = Convolve3d.convolveZ((ImagePlus)smooth, (float[])H);
        this.XX = Smooth_.smooth((ImagePlus)Harris_Corner_Detector.mul(dx, dx), (boolean)true, (float)sigma, (boolean)false);
        this.XY = Smooth_.smooth((ImagePlus)Harris_Corner_Detector.mul(dx, dy), (boolean)true, (float)sigma, (boolean)false);
        this.XZ = Smooth_.smooth((ImagePlus)Harris_Corner_Detector.mul(dx, dz), (boolean)true, (float)sigma, (boolean)false);
        this.YY = Smooth_.smooth((ImagePlus)Harris_Corner_Detector.mul(dy, dy), (boolean)true, (float)sigma, (boolean)false);
        this.YZ = Smooth_.smooth((ImagePlus)Harris_Corner_Detector.mul(dy, dz), (boolean)true, (float)sigma, (boolean)false);
        this.ZZ = Smooth_.smooth((ImagePlus)Harris_Corner_Detector.mul(dz, dz), (boolean)true, (float)sigma, (boolean)false);
    }

    public static final ImagePlus mul(ImagePlus imp1, ImagePlus imp2) {
        InterpolatedImage ii1 = new InterpolatedImage(imp1);
        InterpolatedImage ii2 = new InterpolatedImage(imp2);
        InterpolatedImage out = ii1.cloneDimensionsOnly();
        InterpolatedImage.Iterator it = ii1.iterator();
        while (it.next() != null) {
            out.setFloat(it.i, it.j, it.k, ii1.getNoCheckFloat(it.i, it.j, it.k) * ii2.getNoCheckFloat(it.i, it.j, it.k));
        }
        return out.getImage();
    }

    public static ImagePlus suppressNonMaximum(ImagePlus img) {
        IJ.showStatus((String)"Suppress non-maximum points");
        InterpolatedImage ii = new InterpolatedImage(img);
        InterpolatedImage out = ii.cloneDimensionsOnly();
        InterpolatedImage.Iterator it = ii.iterator();
        int mask_n = 27;
        block0: while (it.next() != null) {
            float v = ii.getNoInterpolFloat(it.i, it.j, it.k);
            if (v < 20.0f) continue;
            out.setFloat(it.i, it.j, it.k, 100.0f);
            for (int i = 0; i < mask_n; ++i) {
                int m_z;
                int zi;
                int m_y;
                int yi;
                int m_x;
                int xi;
                if (i == mask_n / 2 || !(ii.getNoInterpolFloat(xi = it.i + (m_x = i % 9 % 3 - 1), yi = it.j + (m_y = i % 9 / 3 - 1), zi = it.k + (m_z = i / 9 - 1)) >= v)) continue;
                out.setFloat(it.i, it.j, it.k, 0.0f);
                continue block0;
            }
        }
        return out.getImage();
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = new InterpolatedImage(imp).cloneImage().getImage();
        new StackConverter(this.image).convertToGray32();
        return 9;
    }
}

