/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;

@Compression.CompressionType(value="bzip2")
public class Bzip2Compression
implements DefaultBlockReader,
DefaultBlockWriter,
Compression {
    private static final long serialVersionUID = -4873117458390529118L;
    @Compression.CompressionParameter
    private final int blockSize;

    public Bzip2Compression(int blockSize) {
        this.blockSize = blockSize;
    }

    public Bzip2Compression() {
        this(9);
    }

    @Override
    public InputStream getInputStream(InputStream in) throws IOException {
        return new BZip2CompressorInputStream(in);
    }

    @Override
    public OutputStream getOutputStream(OutputStream out) throws IOException {
        return new BZip2CompressorOutputStream(out, this.blockSize);
    }

    @Override
    public Bzip2Compression getReader() {
        return this;
    }

    @Override
    public Bzip2Compression getWriter() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Bzip2Compression.class) {
            return false;
        }
        return this.blockSize == ((Bzip2Compression)other).blockSize;
    }
}

