/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierNodeEdit
extends AbstractUndoableEdit {
    private BezierFigure owner;
    private int index;
    private BezierPath.Node oldValue;
    private BezierPath.Node newValue;

    public BezierNodeEdit(BezierFigure owner, int index, BezierPath.Node oldValue, BezierPath.Node newValue) {
        this.owner = owner;
        this.index = index;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        if (this.oldValue.mask != this.newValue.mask) {
            return labels.getString("edit.bezierNode.changeType.text");
        }
        return labels.getString("edit.bezierNode.movePoint.text");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.setNode(this.index, this.newValue);
        this.owner.changed();
        if (this.oldValue.mask != this.newValue.mask) {
            // empty if block
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.setNode(this.index, this.oldValue);
        this.owner.changed();
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof BezierNodeEdit) {
            BezierNodeEdit that = (BezierNodeEdit)anEdit;
            if (that.owner == this.owner && that.index == this.index) {
                this.newValue = that.newValue;
                return true;
            }
        }
        return false;
    }
}

