/*
 * Decompiled with CFR 0.152.
 */
package fiji.features;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.ImagePlusAdapter;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class Curvatures_<T extends RealType<T>>
implements PlugIn {
    protected Image<T> image;

    public ArrayList<Image<FloatType>> hessianEigenvalueImages(Image<T> input, float[] spacing) {
        OutOfBoundsStrategyMirrorFactory osmf = new OutOfBoundsStrategyMirrorFactory();
        LocalizableByDimCursor cursor = input.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)osmf);
        ImageFactory floatFactory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
        ArrayList<Image<FloatType>> eigenvalueImages = new ArrayList<Image<FloatType>>();
        ArrayList<LocalizableByDimCursor> eCursors = new ArrayList<LocalizableByDimCursor>();
        int numberOfDimensions = input.getDimensions().length;
        for (int i = 0; i < numberOfDimensions; ++i) {
            Image eigenvalueImage = floatFactory.createImage(input.getDimensions());
            eigenvalueImages.add(eigenvalueImage);
            eCursors.add(eigenvalueImage.createLocalizableByDimCursor());
        }
        Matrix hessian = new Matrix(numberOfDimensions, numberOfDimensions);
        LocalizableByDimCursor ahead = input.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)osmf);
        LocalizableByDimCursor behind = input.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)osmf);
        ReverseAbsoluteFloatComparator c = new ReverseAbsoluteFloatComparator();
        while (cursor.hasNext()) {
            cursor.fwd();
            for (int m = 0; m < numberOfDimensions; ++m) {
                for (int n = 0; n < numberOfDimensions; ++n) {
                    ahead.moveTo((Localizable)cursor);
                    behind.moveTo((Localizable)cursor);
                    ahead.fwd(m);
                    behind.bck(m);
                    ahead.fwd(n);
                    behind.fwd(n);
                    float firstDerivativeA = (((RealType)ahead.getType()).getRealFloat() - ((RealType)behind.getType()).getRealFloat()) / (2.0f * spacing[m]);
                    ahead.bck(n);
                    ahead.bck(n);
                    behind.bck(n);
                    behind.bck(n);
                    float firstDerivativeB = (((RealType)ahead.getType()).getRealFloat() - ((RealType)behind.getType()).getRealFloat()) / (2.0f * spacing[m]);
                    double value = (firstDerivativeA - firstDerivativeB) / (2.0f * spacing[n]);
                    hessian.set(m, n, value);
                }
            }
            EigenvalueDecomposition e = hessian.eig();
            double[] eigenvaluesArray = e.getRealEigenvalues();
            ArrayList<Float> eigenvaluesArrayList = new ArrayList<Float>(eigenvaluesArray.length);
            for (double ev : eigenvaluesArray) {
                eigenvaluesArrayList.add(new Float(ev));
            }
            Collections.sort(eigenvaluesArrayList, c);
            for (int i = 0; i < numberOfDimensions; ++i) {
                LocalizableByDimCursor eCursor = (LocalizableByDimCursor)eCursors.get(i);
                eCursor.moveTo((Localizable)cursor);
                ((FloatType)eCursor.getType()).set(((Float)eigenvaluesArrayList.get(i)).floatValue());
            }
        }
        cursor.close();
        ahead.close();
        behind.close();
        for (LocalizableByDimCursor eCursor : eCursors) {
            eCursor.close();
        }
        return eigenvalueImages;
    }

    public void run(String ignored) {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"There's no image open to work on.");
            return;
        }
        float realSigma = 2.0f;
        this.image = ImagePlusAdapter.wrap((ImagePlus)imagePlus);
        float[] spacing = this.image.getCalibration();
        double[] sigmas = new double[spacing.length];
        for (int i = 0; i < spacing.length; ++i) {
            sigmas[i] = 1.0 / (double)spacing[i];
        }
        GaussianConvolutionReal gauss = new GaussianConvolutionReal(this.image, (OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory(), sigmas);
        gauss.setNumThreads(Runtime.getRuntime().availableProcessors());
        if (!gauss.checkInput() || !gauss.process()) {
            IJ.error((String)("Gaussian Convolution failed: " + gauss.getErrorMessage()));
            return;
        }
        Image result = gauss.getResult();
        ImageJFunctions.copyToImagePlus((Image)result).show();
        ArrayList<Image<FloatType>> eigenvalueImages = this.hessianEigenvalueImages(result, spacing);
        for (Image<FloatType> resultImage : eigenvalueImages) {
            ImageJFunctions.copyToImagePlus(resultImage).show();
        }
    }

    public class ReverseAbsoluteFloatComparator
    implements Comparator {
        public int compare(Object d1, Object d2) {
            return Double.compare(Math.abs(((Float)d2).floatValue()), Math.abs(((Float)d1).floatValue()));
        }
    }
}

