/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import weka.core.Utils;
import weka.gui.BrowserHelper;
import weka.gui.ComponentHelper;
import weka.gui.scripting.FileScriptingPanel;
import weka.gui.scripting.GroovyScript;
import weka.gui.scripting.Script;
import weka.gui.scripting.SyntaxDocument;
import weka.gui.visualize.VisualizeUtils;

public class GroovyPanel
extends FileScriptingPanel {
    private static final long serialVersionUID = -3475707604414854111L;
    public static final String PROPERTIES_FILE = "weka/gui/scripting/Groovy.props";

    @Override
    protected JTextPane newCodePane() {
        Properties props;
        try {
            props = Utils.readProperties(PROPERTIES_FILE);
        }
        catch (Exception e) {
            e.printStackTrace();
            props = new Properties();
        }
        JTextPane result = new JTextPane();
        if (props.getProperty("Syntax", "false").equals("true")) {
            SyntaxDocument doc = new SyntaxDocument(props);
            result.setDocument(doc);
            result.setBackground(doc.getBackgroundColor());
        } else {
            result.setForeground(VisualizeUtils.processColour(props.getProperty("ForegroundColor", "black"), Color.BLACK));
            result.setBackground(VisualizeUtils.processColour(props.getProperty("BackgroundColor", "white"), Color.WHITE));
            result.setFont(new Font(props.getProperty("FontName", "monospaced"), 0, Integer.parseInt(props.getProperty("FontSize", "12"))));
        }
        return result;
    }

    @Override
    public ImageIcon getIcon() {
        return ComponentHelper.getImageIcon("weka/gui/scripting/images/groovy_small.png");
    }

    @Override
    protected JPanel getAboutPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        result.add((Component)new JLabel(ComponentHelper.getImageIcon("weka/gui/scripting/images/groovy_medium.png")), "Center");
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        result.add((Component)panel, "South");
        panel.add(new JLabel("Groovy homepage"));
        panel.add(BrowserHelper.createLink("https://groovy.codehaus.org/", null));
        panel.add(new JLabel(" "));
        panel.add(new JLabel("Weka and Groovy"));
        panel.add(BrowserHelper.createLink("https://waikato.github.io/weka-wiki/using_weka_from_groovy", null));
        return result;
    }

    @Override
    public String getPlainTitle() {
        return "Groovy Console";
    }

    @Override
    protected Script newScript(Document doc) {
        return new GroovyScript(doc);
    }

    public static void main(String[] args) {
        GroovyPanel.showPanel(new GroovyPanel(), args);
    }
}

