/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.export.ProgressWriter;
import bdv.ij.ApplyBigwarpPlugin;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import net.imglib2.Interval;

public class BigwarpLandmarkSelectionPanel<T>
extends JPanel {
    private static final long serialVersionUID = -6996547400011766393L;
    JFrame frame;
    JTable table;
    private final PointSelectorTableModel selectionTable;
    private boolean doExport = false;
    final BigWarpData<T> data;
    final List<SourceAndConverter<T>> sources;
    final String fieldOfViewOption;
    final List<Interval> outputIntervalList;
    final List<String> matchedPtNames;
    final Interpolation interp;
    final double[] offsetIn;
    final double[] resolution;
    final boolean isVirtual;
    final int nThreads;
    final ProgressWriter progressWriter;

    public BigwarpLandmarkSelectionPanel(final BigWarpData<T> data, final List<SourceAndConverter<T>> sources, final String fieldOfViewOption, final List<Interval> outputIntervalList, final List<String> matchedPtNames, final Interpolation interp, final double[] offsetIn, final double[] resolution, final boolean isVirtual, final int nThreads, final ProgressWriter progressWriter) {
        this.data = data;
        this.sources = sources;
        this.fieldOfViewOption = fieldOfViewOption;
        this.outputIntervalList = outputIntervalList;
        this.matchedPtNames = matchedPtNames;
        this.interp = interp;
        this.offsetIn = offsetIn;
        this.resolution = resolution;
        this.isVirtual = isVirtual;
        this.nThreads = nThreads;
        this.progressWriter = progressWriter;
        this.selectionTable = new PointSelectorTableModel(matchedPtNames);
        this.genJTable();
        this.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        JTextArea textField = new JTextArea(2, 20);
        textField.append(String.format("Matched %d points\n", this.selectionTable.getRowCount()));
        textField.append("Select points to use below and press OK to continue export.");
        textField.setEditable(false);
        infoPanel.add(textField);
        this.add((Component)infoPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        JButton okButton = new JButton("OK");
        bottomPanel.add((Component)okButton, "South");
        JButton cancelButton = new JButton("Cancel");
        bottomPanel.add((Component)cancelButton, "South");
        this.add((Component)bottomPanel, "South");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BigwarpLandmarkSelectionPanel.filterPoints(matchedPtNames, outputIntervalList, BigwarpLandmarkSelectionPanel.this.selectionTable);
                ApplyBigwarpPlugin.runExport(data, sources, fieldOfViewOption, outputIntervalList, matchedPtNames, interp, offsetIn, resolution, isVirtual, nThreads, progressWriter, true, false, null);
                BigwarpLandmarkSelectionPanel.this.frame.dispatchEvent(new WindowEvent(BigwarpLandmarkSelectionPanel.this.frame, 201));
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BigwarpLandmarkSelectionPanel.this.frame.dispatchEvent(new WindowEvent(BigwarpLandmarkSelectionPanel.this.frame, 201));
            }
        });
        this.setOpaque(true);
        this.frame = this.buildAndShowFrame();
    }

    public static void filterPoints(List<String> matchedPtNames, List<Interval> intervals, PointSelectorTableModel model) {
        int N;
        for (int i = N = model.getRowCount() - 1; i >= 0; --i) {
            if (model.selected.get(i).booleanValue()) continue;
            matchedPtNames.remove(i);
            intervals.remove(i);
        }
    }

    public JFrame buildAndShowFrame() {
        JFrame selectionFrame = new JFrame("Point selection");
        selectionFrame.setContentPane(this);
        selectionFrame.pack();
        selectionFrame.setVisible(true);
        return selectionFrame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public boolean doExport() {
        return this.doExport;
    }

    public void genJTable() {
        this.table = new JTable(this.selectionTable);
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 800));
        this.table.setFillsViewportHeight(true);
        this.table.setShowVerticalLines(false);
    }

    public static class PointSelectorTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3826256129500169587L;
        final ArrayList<Boolean> selected;
        final ArrayList<String> names = new ArrayList();

        public PointSelectorTableModel(List<String> nameListIn) {
            this.selected = new ArrayList();
            for (String s : nameListIn) {
                this.names.add(s);
                this.selected.add(true);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return String.class;
            }
            return Boolean.class;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            return "Selected";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.names.get(rowIndex);
            }
            return this.selected.get(rowIndex);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.names.set(row, (String)value);
            } else {
                this.selected.set(row, (Boolean)value);
            }
        }
    }
}

