/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.bdv;

import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Cast;
import net.imglib2.util.Pair;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.utils.LabkitUtils;

class SimpleBdvShowable
implements BdvShowable {
    private final RandomAccessibleInterval<? extends NumericType<?>> image;
    private final AffineTransform3D transformation;

    SimpleBdvShowable(RandomAccessibleInterval<? extends NumericType<?>> image, AffineTransform3D transformation) {
        this.image = image;
        this.transformation = transformation;
    }

    @Override
    public Interval interval() {
        return new FinalInterval(this.image);
    }

    @Override
    public AffineTransform3D transformation() {
        return this.transformation;
    }

    @Override
    public BdvStackSource<?> show(String title, BdvOptions options) {
        Pair<Double, Double> minMax = LabkitUtils.estimateMinMax(this.image);
        BdvStackSource source = BdvFunctions.show((RandomAccessibleInterval)((RandomAccessibleInterval)Cast.unchecked(this.image)), (String)title, (BdvOptions)options.sourceTransform(this.transformation));
        source.setDisplayRange(((Double)minMax.getA()).doubleValue(), ((Double)minMax.getB()).doubleValue());
        return source;
    }
}

