/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils.sparse;

import gnu.trove.map.hash.TLongIntHashMap;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.IntType;
import sc.fiji.labkit.ui.utils.sparse.IntervalIndexer2;
import sc.fiji.labkit.ui.utils.sparse.MappingCursor;
import sc.fiji.labkit.ui.utils.sparse.ReadRetryWriteLock;
import sc.fiji.labkit.ui.utils.sparse.SparseIterableRegion;

public class SparseRandomAccessIntType
extends AbstractWrappedInterval<Interval>
implements RandomAccessibleInterval<IntType> {
    private final ReadRetryWriteLock lock = new ReadRetryWriteLock();
    private final IntervalIndexer2 indexer;
    private final TLongIntHashMap values;
    private final int noEntryValue;

    public SparseRandomAccessIntType(Interval source) {
        this(source, 0);
    }

    public SparseRandomAccessIntType(Interval source, int noEntryValue) {
        super(source);
        this.indexer = new IntervalIndexer2(source);
        this.values = new TLongIntHashMap(10, 0.5f, -1L, noEntryValue);
        this.noEntryValue = noEntryValue;
    }

    public RandomAccess<IntType> randomAccess() {
        return new MyRandomAccess();
    }

    public RandomAccess<IntType> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public Cursor<IntType> sparseCursor() {
        return new MappingCursor<IntType>(this.sparsityPattern().inside().cursor(), this.randomAccess());
    }

    public IterableRegion<? extends BooleanType<?>> sparsityPattern() {
        return new SparseIterableRegion((Interval)this, this.values.keySet());
    }

    public void clear() {
        this.values.clear();
    }

    private int get(MyRandomAccess position) {
        long index = this.indexer.positionToIndex((Localizable)position);
        while (true) {
            try {
                int value;
                long readId;
                do {
                    readId = this.lock.startRead();
                    value = this.values.get(index);
                } while (!this.lock.isReadValid(readId));
                return value;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(MyRandomAccess position, int value) {
        long index = this.indexer.positionToIndex((Localizable)position);
        ReadRetryWriteLock readRetryWriteLock = this.lock;
        synchronized (readRetryWriteLock) {
            this.lock.writeLock();
            try {
                if (value == this.noEntryValue) {
                    this.values.remove(index);
                } else {
                    this.values.put(index, value);
                }
            }
            finally {
                this.lock.writeUnlock();
            }
        }
    }

    public IntType getType() {
        return new IntType();
    }

    private class MyRandomAccess
    extends Point
    implements RandomAccess<IntType> {
        private IntType value;

        private MyRandomAccess() {
            super(SparseRandomAccessIntType.this.numDimensions());
            this.value = new IntType(new IntAccess(){

                public int getValue(int ignored) {
                    return SparseRandomAccessIntType.this.get(MyRandomAccess.this);
                }

                public void setValue(int ignored, int value) {
                    SparseRandomAccessIntType.this.set(MyRandomAccess.this, value);
                }
            });
        }

        private MyRandomAccess(Localizable localizable) {
            super(localizable);
            this.value = new IntType(new /* invalid duplicate definition of identical inner class */);
        }

        public RandomAccess<IntType> copy() {
            return new MyRandomAccess((Localizable)this);
        }

        public IntType get() {
            return this.value;
        }
    }
}

