/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class Calibrations {
    @Parameter
    LogService log;
    private Dataset data;
    private double dx;
    private double dy;
    private double dz;
    private double dt;
    private double sizeX;
    private double sizeY;
    private double sizeZ;
    private double sizeT;
    private String unitX;
    private String unitY;
    private String unitZ;
    private String unitT;
    private List<String> channelList;
    private int channelToUseIndex = 0;

    public Calibrations(Context context, Dataset data) {
        context.inject((Object)this);
        this.data = data;
        int xIndex = this.data.dimensionIndex(Axes.X);
        int yIndex = this.data.dimensionIndex(Axes.Y);
        int zIndex = this.data.dimensionIndex(Axes.Z);
        int timeIndex = this.data.dimensionIndex(Axes.TIME);
        int channelIndex = this.data.dimensionIndex(Axes.CHANNEL);
        this.dx = xIndex != -1 ? ((CalibratedAxis)this.data.axis(xIndex)).calibratedValue(1.0) : 1.0;
        this.dy = yIndex != -1 ? ((CalibratedAxis)this.data.axis(yIndex)).calibratedValue(1.0) : 1.0;
        this.dz = zIndex != -1 ? ((CalibratedAxis)this.data.axis(zIndex)).calibratedValue(1.0) : 1.0;
        this.dt = timeIndex != -1 ? ((CalibratedAxis)this.data.axis(timeIndex)).calibratedValue(1.0) : 1.0;
        this.unitX = xIndex != -1 ? ((CalibratedAxis)this.data.axis(xIndex)).unit() : "";
        this.unitY = yIndex != -1 ? ((CalibratedAxis)this.data.axis(yIndex)).unit() : "";
        this.unitZ = zIndex != -1 ? ((CalibratedAxis)this.data.axis(zIndex)).unit() : "";
        this.unitT = timeIndex != -1 ? ((CalibratedAxis)this.data.axis(timeIndex)).unit() : "";
        this.sizeX = xIndex != -1 ? (double)this.data.dimension(xIndex) : -1.0;
        this.sizeY = yIndex != -1 ? (double)this.data.dimension(yIndex) : -1.0;
        this.sizeZ = zIndex != -1 ? (double)this.data.dimension(zIndex) : -1.0;
        this.sizeT = timeIndex != -1 ? (double)this.data.dimension(timeIndex) : -1.0;
        this.channelList = new ArrayList<String>();
        int i = 1;
        while ((long)i <= this.data.dimension(Axes.CHANNEL)) {
            this.channelList.add("Channel " + i);
            ++i;
        }
    }

    public Dataset getData() {
        return this.data;
    }

    public double getDx() {
        return this.dx;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public void setDz(double dz) {
        this.dz = dz;
    }

    public void setDt(double dt) {
        this.dt = dt;
    }

    public double getDy() {
        return this.dy;
    }

    public double getDz() {
        return this.dz;
    }

    public double getDt() {
        return this.dt;
    }

    public String getUnitX() {
        return this.unitX;
    }

    public String getUnitY() {
        return this.unitY;
    }

    public String getUnitZ() {
        return this.unitZ;
    }

    public String getUnitT() {
        return this.unitT;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public double getSizeZ() {
        return this.sizeZ;
    }

    public double getSizeT() {
        return this.sizeT;
    }

    public List<String> getChannelList() {
        return this.channelList;
    }

    public void setChannelList(List<String> channelList) {
        this.channelList = channelList;
    }

    public void channelToUse(String channelToUse) {
        int newChannelIndex = IntStream.range(0, this.channelList.size()).filter(i -> this.channelList.get(i).equals(channelToUse)).findFirst().orElse(-1);
        if (newChannelIndex != -1) {
            this.channelToUseIndex = newChannelIndex;
        } else {
            this.log.error((Object)(channelToUse + " is not a valid channel."));
        }
    }

    public String getChannelToUse() {
        return this.channelList.get(this.channelToUseIndex);
    }

    public int getChannelToUseIndex() {
        return this.channelToUseIndex;
    }

    public void setChannelToUseIndex(int channelToUseIndex) {
        this.channelToUseIndex = channelToUseIndex;
    }
}

