/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller.analyzer;

import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.analyzer.TipFitterAnalyzer;
import sc.fiji.filamentdetector.gui.controller.analyzer.AbstractAnalyzerController;
import sc.fiji.filamentdetector.gui.controller.analyzer.AnalyzerController;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;
import sc.fiji.filamentdetector.model.TrackedFilaments;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;

public class TipFitterAnalyzerController
extends AbstractAnalyzerController
implements AnalyzerController {
    private static String FXML_VIEW_FILE = "/sc/fiji/filamentdetector/gui/view/analyzer/TipFitterAnalyzerView.fxml";
    @Parameter
    private StatusService status;
    @Parameter
    private LogService log;
    @Parameter
    private FilamentOverlayService overlay;
    @FXML
    private TextField channelIndexField;
    @FXML
    private Slider lineWidthSlider;
    @FXML
    private TextField lineWidthField;
    @FXML
    private Slider lineFitLengthSlider;
    @FXML
    private TextField lineFitLengthField;
    @FXML
    private Slider polynomDegreeSlider;
    @FXML
    private TextField polynomDegreeField;
    @FXML
    private Slider relativeDistSlider;
    @FXML
    private TextField relativeDistField;
    @FXML
    private CheckBox overlayFilamentsCheckbox;
    private SliderLabelSynchronizer lineWidthSync;
    private SliderLabelSynchronizer lineFitLengthSync;
    private SliderLabelSynchronizer polynomDegreeSync;
    private SliderLabelSynchronizer relativeDistSync;
    private TipFitterAnalyzer analyzer;

    public TipFitterAnalyzerController(Context context, TipFitterAnalyzer analyzer) {
        super(context);
        this.setFXMLPath(FXML_VIEW_FILE);
        this.analyzer = analyzer;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.lineWidthSync = new SliderLabelSynchronizer(this.lineWidthSlider, this.lineWidthField);
        this.lineWidthSync.setValue(this.analyzer.getFitter().getLineWidth());
        this.lineFitLengthSync = new SliderLabelSynchronizer(this.lineFitLengthSlider, this.lineFitLengthField);
        this.lineFitLengthSync.setValue(this.analyzer.getFitter().getLineFitLength());
        this.polynomDegreeSync = new SliderLabelSynchronizer(this.polynomDegreeSlider, this.polynomDegreeField);
        this.polynomDegreeSync.setValue(this.analyzer.getFitter().getPolynomDegree());
        this.relativeDistSync = new SliderLabelSynchronizer(this.relativeDistSlider, this.relativeDistField);
        this.relativeDistSync.setValue(this.analyzer.getFitter().getRelativePositionFromEnd());
        this.channelIndexField.setText(Integer.toString(this.analyzer.getFitter().getChannelIndex()));
    }

    @FXML
    void updateParameters(ActionEvent event) {
        if (this.lineWidthSync.isEvent((Event)event)) {
            this.lineWidthSync.update((Event)event);
            this.analyzer.getFitter().setLineWidth(this.lineWidthSync.getValue());
        } else if (this.lineFitLengthSync.isEvent((Event)event)) {
            this.lineFitLengthSync.update((Event)event);
            this.analyzer.getFitter().setLineFitLength(this.lineFitLengthSync.getValue());
        } else if (this.polynomDegreeSync.isEvent((Event)event)) {
            this.polynomDegreeSync.update((Event)event);
            this.analyzer.getFitter().setPolynomDegree((int)this.polynomDegreeSync.getValue());
        } else if (this.relativeDistSync.isEvent((Event)event)) {
            this.relativeDistSync.update((Event)event);
            this.analyzer.getFitter().setRelativePositionFromEnd(this.relativeDistSync.getValue());
        }
    }

    @Override
    public void runPostAnalysisAction() {
        Map side1 = (Map)this.analyzer.getResults().get("side1Filaments");
        Map side2 = (Map)this.analyzer.getResults().get("side2Filaments");
        TrackedFilaments side1AsList = side1.values().stream().collect(Collectors.toCollection(TrackedFilaments::new));
        TrackedFilaments side2AsList = side2.values().stream().collect(Collectors.toCollection(TrackedFilaments::new));
        this.overlay.reset();
        this.overlay.add(side1AsList);
        this.overlay.add(side2AsList);
    }
}

