/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.hdf5;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;

public class HDF5Utils {
    public static byte[] HDF5_SIG = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHDF5(String path) {
        File f = new File(path);
        if (!f.exists()) return false;
        if (!f.isFile()) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(f);){
            byte[] sig = new byte[8];
            in.read(sig);
            boolean bl = Arrays.equals(sig, HDF5_SIG);
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

