/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryLock;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponentUpdateInfo;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.NioImageBuffer;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.RasterRetained;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.VirtualUniverse;

abstract class ImageComponentRetained
extends NodeComponentRetained {
    static final int IMAGE_CHANGED = 1;
    static final int SUBIMAGE_CHANGED = 2;
    static final int TYPE_BYTE_BGR = 1;
    static final int TYPE_BYTE_RGB = 2;
    static final int TYPE_BYTE_ABGR = 4;
    static final int TYPE_BYTE_RGBA = 8;
    static final int TYPE_BYTE_LA = 16;
    static final int TYPE_BYTE_GRAY = 32;
    static final int TYPE_USHORT_GRAY = 64;
    static final int TYPE_INT_BGR = 128;
    static final int TYPE_INT_RGB = 256;
    static final int TYPE_INT_ARGB = 512;
    static final int IMAGE_SIZE_512X512 = 262144;
    static final int IMAGE_DATA_TYPE_BYTE_ARRAY = 4096;
    static final int IMAGE_DATA_TYPE_INT_ARRAY = 8192;
    static final int IMAGE_DATA_TYPE_BYTE_BUFFER = 16384;
    static final int IMAGE_DATA_TYPE_INT_BUFFER = 32768;
    private int apiFormat;
    int width;
    int height;
    int depth;
    boolean byReference = false;
    boolean yUp = false;
    boolean imageTypeIsSupported;
    boolean abgrSupported = true;
    boolean npotSupported = true;
    private int unitsPerPixel;
    private int numberOfComponents;
    private int imageType;
    private ImageFormatType imageFormatType = ImageFormatType.TYPE_UNKNOWN;
    ImageData imageData;
    private ImageComponent.ImageClass imageClass = ImageComponent.ImageClass.BUFFERED_IMAGE;
    private ImageData imageDataPowerOfTwo;
    private AffineTransformOp powerOfTwoATOp;
    private boolean enforceNonPowerOfTwoSupport = false;
    private boolean usedByOffScreenCanvas = false;
    private Object[] refImage = null;
    Object evaluateExtLock = new Object();
    GeometryLock geomLock = new GeometryLock();
    int tilew = 0;
    int tileh = 0;
    int numXTiles = 0;
    int numYTiles = 0;
    private ArrayList<NodeComponentRetained> userList = new ArrayList();

    ImageComponentRetained() {
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    int getFormat() {
        return this.apiFormat;
    }

    void setFormat(int format) {
        this.apiFormat = format;
    }

    void setByReference(boolean byReference) {
        this.byReference = byReference;
    }

    boolean isByReference() {
        return this.byReference;
    }

    void setYUp(boolean yUp) {
        this.yUp = yUp;
    }

    boolean isYUp() {
        return this.yUp;
    }

    int getUnitsPerPixel() {
        return this.unitsPerPixel;
    }

    void setUnitsPerPixel(int ipp) {
        this.unitsPerPixel = ipp;
    }

    ImageComponent.ImageClass getImageClass() {
        return this.imageClass;
    }

    void setImageClass(RenderedImage image) {
        this.imageClass = image instanceof BufferedImage ? ImageComponent.ImageClass.BUFFERED_IMAGE : ImageComponent.ImageClass.RENDERED_IMAGE;
    }

    void setImageClass(NioImageBuffer image) {
        this.imageClass = ImageComponent.ImageClass.NIO_IMAGE_BUFFER;
    }

    void setEnforceNonPowerOfTwoSupport(boolean npot) {
        this.enforceNonPowerOfTwoSupport = npot;
    }

    void setUsedByOffScreen(boolean used) {
        this.usedByOffScreenCanvas = used;
    }

    boolean getUsedByOffScreen() {
        return this.usedByOffScreenCanvas;
    }

    int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    void setNumberOfComponents(int numberOfComponents) {
        this.numberOfComponents = numberOfComponents;
    }

    int getImageDataTypeIntValue() {
        int idtValue = -1;
        switch (this.imageData.imageDataType) {
            case TYPE_BYTE_ARRAY: {
                idtValue = 4096;
                break;
            }
            case TYPE_INT_ARRAY: {
                idtValue = 8192;
                break;
            }
            case TYPE_BYTE_BUFFER: {
                idtValue = 16384;
                break;
            }
            case TYPE_INT_BUFFER: {
                idtValue = 32768;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return idtValue;
    }

    int getImageFormatTypeIntValue(boolean powerOfTwoData) {
        int iftValue = -1;
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: {
                iftValue = 1;
                break;
            }
            case TYPE_BYTE_RGB: {
                iftValue = 2;
                break;
            }
            case TYPE_BYTE_ABGR: {
                iftValue = 4;
                break;
            }
            case TYPE_BYTE_RGBA: {
                if (this.imageDataPowerOfTwo != null && powerOfTwoData) {
                    iftValue = 4;
                    break;
                }
                iftValue = 8;
                break;
            }
            case TYPE_BYTE_LA: {
                iftValue = 16;
                break;
            }
            case TYPE_BYTE_GRAY: {
                iftValue = 32;
                break;
            }
            case TYPE_USHORT_GRAY: {
                iftValue = 64;
                break;
            }
            case TYPE_INT_BGR: {
                iftValue = 128;
                break;
            }
            case TYPE_INT_RGB: {
                iftValue = 256;
                break;
            }
            case TYPE_INT_ARGB: {
                iftValue = 512;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return iftValue;
    }

    int getImageType() {
        return this.imageType;
    }

    void setImageFormatType(ImageFormatType ift) {
        this.imageFormatType = ift;
    }

    ImageFormatType getImageFormatType() {
        return this.imageFormatType;
    }

    void setRefImage(Object image, int index) {
        this.refImage[index] = image;
    }

    Object getRefImage(int index) {
        return this.refImage[index];
    }

    ImageData getImageData(boolean npotSupportNeeded) {
        if (npotSupportNeeded) {
            assert (this.enforceNonPowerOfTwoSupport);
            if (this.imageDataPowerOfTwo != null) {
                return this.imageDataPowerOfTwo;
            }
        }
        return this.imageData;
    }

    boolean useBilinearFilter() {
        return this.imageDataPowerOfTwo != null;
    }

    boolean isImageTypeSupported() {
        return this.imageTypeIsSupported;
    }

    void processParams(int format, int width, int height, int depth) {
        if (width < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained0"));
        }
        if (height < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained1"));
        }
        if (depth < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained2"));
        }
        switch (format) {
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                this.numberOfComponents = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this.numberOfComponents = 4;
                break;
            }
            case 7: 
            case 8: {
                this.numberOfComponents = 2;
                break;
            }
            case 10: {
                this.numberOfComponents = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponentRetained3"));
            }
        }
        this.setFormat(format);
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.refImage = new Object[depth];
    }

    int evaluateImageType(RenderedImage ri) {
        int imageType = 0;
        if (ri instanceof BufferedImage) {
            imageType = ((BufferedImage)ri).getType();
            if (imageType != 0) {
                return imageType;
            }
        } else {
            return imageType;
        }
        ColorModel cm = ri.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        SampleModel sm = ri.getSampleModel();
        int csType = cs.getType();
        boolean isAlphaPre = cm.isAlphaPremultiplied();
        if (csType == 6 && cm instanceof ComponentColorModel) {
            if (sm.getDataType() == 0) {
                imageType = 10;
            } else if (sm.getDataType() == 1) {
                imageType = 11;
            }
        } else if (csType == 5) {
            int comparedBit = 0;
            int smDataType = sm.getDataType();
            if (smDataType == 0) {
                comparedBit = 8;
            } else if (smDataType == 3) {
                comparedBit = 32;
            }
            if (comparedBit != 0) {
                int numBands = sm.getNumBands();
                if (cm instanceof ComponentColorModel && sm instanceof PixelInterleavedSampleModel) {
                    PixelInterleavedSampleModel csm = (PixelInterleavedSampleModel)sm;
                    int[] offs = csm.getBandOffsets();
                    ComponentColorModel ccm = (ComponentColorModel)cm;
                    int[] nBits = ccm.getComponentSize();
                    boolean isNBit = true;
                    for (int i = 0; i < numBands; ++i) {
                        if (nBits[i] == comparedBit) continue;
                        isNBit = false;
                        break;
                    }
                    if (comparedBit == 8) {
                        if (isNBit && offs[0] == numBands - 1 && offs[1] == numBands - 2 && offs[2] == numBands - 3) {
                            if (numBands == 3) {
                                imageType = 5;
                            } else if (offs[3] == 0) {
                                imageType = isAlphaPre ? 7 : 6;
                            }
                        }
                    } else if (isNBit) {
                        if (numBands == 3) {
                            if (offs[0] == numBands - 1 && offs[1] == numBands - 2 && offs[2] == numBands - 3) {
                                imageType = 4;
                            } else if (offs[0] == 0 && offs[1] == 1 && offs[2] == 2) {
                                imageType = 1;
                            }
                        } else if (offs[0] == 3 && offs[1] == 0 && offs[2] == 1 && offs[3] == 2) {
                            imageType = isAlphaPre ? 3 : 2;
                        }
                    }
                }
            }
        }
        return imageType;
    }

    boolean is3ByteRGB(RenderedImage ri) {
        int numBands;
        boolean value = false;
        ColorModel cm = ri.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        SampleModel sm = ri.getSampleModel();
        boolean isAlphaPre = cm.isAlphaPremultiplied();
        int csType = cs.getType();
        if (csType == 5 && (numBands = sm.getNumBands()) == 3 && sm.getDataType() == 0 && cm instanceof ComponentColorModel && sm instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel csm = (PixelInterleavedSampleModel)sm;
            int[] offs = csm.getBandOffsets();
            ComponentColorModel ccm = (ComponentColorModel)cm;
            int[] nBits = ccm.getComponentSize();
            boolean is8Bit = true;
            for (int i = 0; i < numBands; ++i) {
                if (nBits[i] == 8) continue;
                is8Bit = false;
                break;
            }
            if (is8Bit && offs[0] == 0 && offs[1] == 1 && offs[2] == 2) {
                value = true;
            }
        }
        return value;
    }

    boolean is4ByteRGBA(RenderedImage ri) {
        int numBands;
        boolean value = false;
        ColorModel cm = ri.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        SampleModel sm = ri.getSampleModel();
        boolean isAlphaPre = cm.isAlphaPremultiplied();
        int csType = cs.getType();
        if (csType == 5 && (numBands = sm.getNumBands()) == 4 && sm.getDataType() == 0 && cm instanceof ComponentColorModel && sm instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel csm = (PixelInterleavedSampleModel)sm;
            int[] offs = csm.getBandOffsets();
            ComponentColorModel ccm = (ComponentColorModel)cm;
            int[] nBits = ccm.getComponentSize();
            boolean is8Bit = true;
            for (int i = 0; i < numBands; ++i) {
                if (nBits[i] == 8) continue;
                is8Bit = false;
                break;
            }
            if (is8Bit && offs[0] == 0 && offs[1] == 1 && offs[2] == 2 && offs[3] == 3 && !isAlphaPre) {
                value = true;
            }
        }
        return value;
    }

    boolean isSubImageTypeEqual(RenderedImage ri) {
        int subImageType = this.evaluateImageType(ri);
        return this.imageType == subImageType;
    }

    void createBlankImageData() {
        assert (this.imageData == null);
        switch (this.numberOfComponents) {
            case 4: {
                this.imageType = 2;
                this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                this.unitsPerPixel = 1;
                break;
            }
            case 3: {
                this.imageType = 1;
                this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                this.unitsPerPixel = 1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.imageTypeIsSupported = true;
        this.imageData = this.createRenderedImageDataObject(null);
    }

    boolean isImageTypeSupported(NioImageBuffer nioImgBuf) {
        boolean isSupported = true;
        NioImageBuffer.ImageType nioImageType = nioImgBuf.getImageType();
        block0 : switch (this.numberOfComponents) {
            case 4: {
                switch (nioImageType) {
                    case TYPE_4BYTE_ABGR: {
                        if (this.abgrSupported) {
                            this.imageFormatType = ImageFormatType.TYPE_BYTE_ABGR;
                        } else {
                            this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                            isSupported = false;
                        }
                        this.unitsPerPixel = 4;
                        break block0;
                    }
                    case TYPE_4BYTE_RGBA: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                        this.unitsPerPixel = 4;
                        break block0;
                    }
                    case TYPE_INT_ARGB: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 3: {
                switch (nioImageType) {
                    case TYPE_3BYTE_BGR: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_BGR;
                        this.unitsPerPixel = 3;
                        break block0;
                    }
                    case TYPE_3BYTE_RGB: {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                        this.unitsPerPixel = 3;
                        break block0;
                    }
                    case TYPE_INT_BGR: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_BGR;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                    case TYPE_INT_RGB: {
                        this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                        this.unitsPerPixel = 1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 2: {
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            case 1: {
                if (nioImageType == NioImageBuffer.ImageType.TYPE_BYTE_GRAY) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                    this.unitsPerPixel = 1;
                    break;
                }
                throw new IllegalArgumentException(J3dI18N.getString("ImageComponent5"));
            }
            default: {
                throw new AssertionError();
            }
        }
        return isSupported;
    }

    boolean isImageTypeSupported(RenderedImage ri) {
        boolean isSupported = true;
        this.imageType = this.evaluateImageType(ri);
        switch (this.numberOfComponents) {
            case 4: {
                if (this.imageType == 6) {
                    if (this.abgrSupported) {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_ABGR;
                    } else {
                        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                        isSupported = false;
                    }
                    this.unitsPerPixel = 4;
                    break;
                }
                if (this.imageType == 2) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_ARGB;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.is4ByteRGBA(ri)) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                    this.unitsPerPixel = 4;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
                isSupported = false;
                this.unitsPerPixel = 4;
                break;
            }
            case 3: {
                if (this.imageType == 5) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_BGR;
                    this.unitsPerPixel = 3;
                    break;
                }
                if (this.imageType == 4) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_BGR;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.imageType == 1) {
                    this.imageFormatType = ImageFormatType.TYPE_INT_RGB;
                    this.unitsPerPixel = 1;
                    break;
                }
                if (this.is3ByteRGB(ri)) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                    this.unitsPerPixel = 3;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_RGB;
                isSupported = false;
                this.unitsPerPixel = 3;
                break;
            }
            case 2: {
                this.imageFormatType = ImageFormatType.TYPE_BYTE_LA;
                isSupported = false;
                this.unitsPerPixel = 2;
                break;
            }
            case 1: {
                if (this.imageType == 10) {
                    this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                    this.unitsPerPixel = 1;
                    break;
                }
                this.imageFormatType = ImageFormatType.TYPE_BYTE_GRAY;
                isSupported = false;
                this.unitsPerPixel = 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return isSupported;
    }

    ImageData createNioImageBufferDataObject(NioImageBuffer nioImageBuffer) {
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: 
            case TYPE_BYTE_RGB: 
            case TYPE_BYTE_ABGR: 
            case TYPE_BYTE_RGBA: 
            case TYPE_BYTE_LA: 
            case TYPE_BYTE_GRAY: {
                if (nioImageBuffer != null) {
                    return new ImageData(ImageDataType.TYPE_BYTE_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height, nioImageBuffer);
                }
                return new ImageData(ImageDataType.TYPE_BYTE_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height);
            }
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: 
            case TYPE_INT_ARGB: {
                return new ImageData(ImageDataType.TYPE_INT_BUFFER, this.width * this.height * this.depth * this.unitsPerPixel, this.width, this.height, nioImageBuffer);
            }
        }
        throw new AssertionError();
    }

    ImageData createRenderedImageDataObject(RenderedImage byRefImage, int dataWidth, int dataHeight) {
        switch (this.imageFormatType) {
            case TYPE_BYTE_BGR: 
            case TYPE_BYTE_RGB: 
            case TYPE_BYTE_ABGR: 
            case TYPE_BYTE_RGBA: 
            case TYPE_BYTE_LA: 
            case TYPE_BYTE_GRAY: {
                if (byRefImage != null) {
                    return new ImageData(ImageDataType.TYPE_BYTE_ARRAY, dataWidth * dataHeight * this.depth * this.unitsPerPixel, dataWidth, dataHeight, byRefImage);
                }
                return new ImageData(ImageDataType.TYPE_BYTE_ARRAY, dataWidth * dataHeight * this.depth * this.unitsPerPixel, dataWidth, dataHeight);
            }
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: 
            case TYPE_INT_ARGB: {
                if (byRefImage != null) {
                    return new ImageData(ImageDataType.TYPE_INT_ARRAY, dataWidth * dataHeight * this.depth * this.unitsPerPixel, dataWidth, dataHeight, byRefImage);
                }
                return new ImageData(ImageDataType.TYPE_INT_ARRAY, dataWidth * dataHeight * this.depth * this.unitsPerPixel, dataWidth, dataHeight);
            }
        }
        throw new AssertionError();
    }

    private void updateImageDataPowerOfTwo(int depthIndex) {
        assert (this.enforceNonPowerOfTwoSupport);
        BufferedImage bufImage = this.imageData.createBufferedImage(depthIndex);
        BufferedImage scaledImg = this.powerOfTwoATOp.filter(bufImage, null);
        this.copySupportedImageToImageData(scaledImg, 0, this.imageDataPowerOfTwo);
    }

    ImageData createRenderedImageDataObject(RenderedImage byRefImage) {
        return this.createRenderedImageDataObject(byRefImage, this.width, this.height);
    }

    void copySupportedImageToImageData(RenderedImage ri, int srcX, int srcY, int dstX, int dstY, int depthIndex, int copyWidth, int copyHeight, ImageData data) {
        int dstLineUnits;
        int sign;
        int tileStart;
        assert (data != null);
        ColorModel cm = ri.getColorModel();
        int xoff = ri.getTileGridXOffset();
        int yoff = ri.getTileGridYOffset();
        int minTileX = ri.getMinTileX();
        int minTileY = ri.getMinTileY();
        this.tilew = ri.getTileWidth();
        this.tileh = ri.getTileHeight();
        float mt = (float)(srcX - xoff) / (float)this.tilew;
        minTileX = mt < 0.0f ? (int)(mt - 1.0f) : (int)mt;
        mt = (float)(srcY - yoff) / (float)this.tileh;
        minTileY = mt < 0.0f ? (int)(mt - 1.0f) : (int)mt;
        int startXTile = minTileX * this.tilew + xoff;
        int startYTile = minTileY * this.tileh + yoff;
        int curw = startXTile + this.tilew - srcX;
        int curh = startYTile + this.tileh - srcY;
        if (curw > copyWidth) {
            curw = copyWidth;
        }
        if (curh > copyHeight) {
            curh = copyHeight;
        }
        int startw = curw;
        int tmpw = copyWidth;
        int tmph = copyHeight;
        int x = srcX - startXTile;
        int y = srcY - startYTile;
        this.numXTiles = (copyWidth + x) / this.tilew;
        this.numYTiles = (copyHeight + y) / this.tileh;
        if ((float)(copyWidth + x) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(copyHeight + y) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        Object pixel = null;
        byte[] dstByteBuffer = null;
        int[] dstIntBuffer = null;
        switch (data.getType()) {
            case TYPE_BYTE_ARRAY: {
                dstByteBuffer = data.getAsByteArray();
                break;
            }
            case TYPE_INT_ARRAY: {
                dstIntBuffer = data.getAsIntArray();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int dataWidth = data.dataWidth;
        int dataHeight = data.dataHeight;
        int lineUnits = dataWidth * this.unitsPerPixel;
        if (this.yUp) {
            tileStart = (depthIndex * dataWidth * dataHeight + dstY * dataWidth + dstX) * this.unitsPerPixel;
            sign = 1;
            dstLineUnits = lineUnits;
        } else {
            tileStart = (depthIndex * dataWidth * dataHeight + (dataHeight - dstY - 1) * dataWidth + dstX) * this.unitsPerPixel;
            sign = -1;
            dstLineUnits = -lineUnits;
        }
        Raster ras = ri.getTile(minTileX, minTileY);
        pixel = ImageComponentRetained.getDataElementBuffer(ras);
        int tileLineUnits = this.tilew * this.unitsPerPixel;
        for (int n = minTileY; n < minTileY + this.numYTiles; ++n) {
            int dstBegin = tileStart;
            tmpw = copyWidth;
            curw = startw;
            x = srcX - startXTile;
            for (int m = minTileX; m < minTileX + this.numXTiles; ++m) {
                ras = ri.getTile(m, n);
                int srcOffset = (y * this.tilew + x) * this.unitsPerPixel;
                int dstOffset = dstBegin;
                int copyUnits = curw * this.unitsPerPixel;
                switch (data.getType()) {
                    case TYPE_BYTE_ARRAY: {
                        int h;
                        byte[] srcByteBuffer = ((DataBufferByte)ras.getDataBuffer()).getData();
                        for (h = 0; h < curh; ++h) {
                            System.arraycopy(srcByteBuffer, srcOffset, dstByteBuffer, dstOffset, copyUnits);
                            srcOffset += tileLineUnits;
                            dstOffset += dstLineUnits;
                        }
                        break;
                    }
                    case TYPE_INT_ARRAY: {
                        int h;
                        int[] srcIntBuffer = ((DataBufferInt)ras.getDataBuffer()).getData();
                        for (h = 0; h < curh; ++h) {
                            System.arraycopy(srcIntBuffer, srcOffset, dstIntBuffer, dstOffset, copyUnits);
                            srcOffset += tileLineUnits;
                            dstOffset += dstLineUnits;
                        }
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                dstBegin += curw * this.unitsPerPixel;
                x = 0;
                curw = (tmpw -= curw) < this.tilew ? tmpw : this.tilew;
            }
            tileStart += dataWidth * this.unitsPerPixel * curh * sign;
            y = 0;
            curh = (tmph -= curh) < this.tileh ? tmph : this.tileh;
        }
        if (this.imageData == data && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(depthIndex);
        }
    }

    void copyImageLineByLine(BufferedImage bi, int srcX, int srcY, int dstX, int dstY, int depthIndex, int copyWidth, int copyHeight, ImageData data) {
        int dstBegin;
        assert (data != null);
        int dataWidth = data.dataWidth;
        int dataHeight = data.dataHeight;
        int dstUnitsPerRow = dataWidth * this.unitsPerPixel;
        int rowBegin = srcY;
        if (this.yUp) {
            dstBegin = (depthIndex * dataWidth * dataHeight + dstY * dataWidth + dstX) * this.unitsPerPixel;
        } else {
            dstBegin = (depthIndex * dataWidth * dataHeight + (dataHeight - dstY - 1) * dataWidth + dstX) * this.unitsPerPixel;
            dstUnitsPerRow = -1 * dstUnitsPerRow;
        }
        int copyUnits = copyWidth * this.unitsPerPixel;
        int srcWidth = bi.getWidth();
        int srcUnitsPerRow = srcWidth * this.unitsPerPixel;
        int srcBegin = (rowBegin * srcWidth + srcX) * this.unitsPerPixel;
        switch (data.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] srcByteBuffer = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                byte[] dstByteBuffer = data.getAsByteArray();
                for (int h = 0; h < copyHeight; ++h) {
                    System.arraycopy(srcByteBuffer, srcBegin, dstByteBuffer, dstBegin, copyUnits);
                    dstBegin += dstUnitsPerRow;
                    srcBegin += srcUnitsPerRow;
                }
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] srcIntBuffer = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                int[] dstIntBuffer = data.getAsIntArray();
                for (int h = 0; h < copyHeight; ++h) {
                    System.arraycopy(srcIntBuffer, srcBegin, dstIntBuffer, dstBegin, copyUnits);
                    dstBegin += dstUnitsPerRow;
                    srcBegin += srcUnitsPerRow;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == data && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(depthIndex);
        }
    }

    void copyImageByBlock(BufferedImage bi, int depthIndex, ImageData data) {
        assert (data != null && this.yUp);
        int dataWidth = data.dataWidth;
        int dataHeight = data.dataHeight;
        int dstBegin = depthIndex * dataWidth * dataHeight * this.unitsPerPixel;
        switch (this.imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] srcByteBuffer = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                byte[] dstByteBuffer = data.getAsByteArray();
                System.arraycopy(srcByteBuffer, 0, dstByteBuffer, dstBegin, dataWidth * dataHeight * this.unitsPerPixel);
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] srcIntBuffer = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                int[] dstIntBuffer = data.getAsIntArray();
                System.arraycopy(srcIntBuffer, 0, dstIntBuffer, dstBegin, dataWidth * dataHeight * this.unitsPerPixel);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == data && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(depthIndex);
        }
    }

    void copySupportedImageToImageData(RenderedImage ri, int depthIndex, ImageData data) {
        if (ri instanceof BufferedImage) {
            if (this.yUp) {
                this.copyImageByBlock((BufferedImage)ri, depthIndex, data);
            } else {
                this.copyImageLineByLine((BufferedImage)ri, 0, 0, 0, 0, depthIndex, data.dataWidth, data.dataHeight, data);
            }
        } else {
            this.copySupportedImageToImageData(ri, ri.getMinX(), ri.getMinY(), 0, 0, depthIndex, data.dataWidth, data.dataHeight, data);
        }
    }

    void copyUnsupportedNioImageToImageData(NioImageBuffer nioImage, int srcX, int srcY, int dstX, int dstY, int copyWidth, int copyHeight, ImageData iData) {
        if (MasterControl.isDevLoggable(Level.INFO)) {
            MasterControl.getDevLogger().info("ImageComponent - Copying Unsupported NioImage, use a different image type");
        }
        assert (iData.getType() == ImageDataType.TYPE_BYTE_BUFFER);
        assert (this.getImageFormatType() == ImageFormatType.TYPE_BYTE_RGBA);
        int length = copyWidth * copyHeight;
        ByteBuffer srcBuffer = (ByteBuffer)nioImage.getDataBuffer();
        srcBuffer.rewind();
        ByteBuffer dstBuffer = iData.getAsByteBuffer();
        dstBuffer.rewind();
        for (int i = 0; i < length; i += 4) {
            dstBuffer.put(i, srcBuffer.get(i + 3));
            dstBuffer.put(i + 1, srcBuffer.get(i + 2));
            dstBuffer.put(i + 2, srcBuffer.get(i + 1));
            dstBuffer.put(i + 3, srcBuffer.get(i));
        }
    }

    void copyUnsupportedImageToImageData(RenderedImage ri, int depthIndex, ImageData data) {
        assert (data.getType() == ImageDataType.TYPE_BYTE_ARRAY);
        if (MasterControl.isDevLoggable(Level.INFO)) {
            MasterControl.getDevLogger().info("ImageComponent - Copying Unsupported Image, use a different image type");
        }
        if (ri instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)ri, 0, 0, 0, 0, depthIndex, data.dataWidth, data.dataHeight, data);
        } else {
            this.copyUnsupportedImageToImageData(ri, ri.getMinX(), ri.getMinY(), 0, 0, depthIndex, data.dataWidth, data.dataHeight, data);
        }
    }

    void copyUnsupportedImageToImageData(BufferedImage bi, int srcX, int srcY, int dstX, int dstY, int depthIndex, int copyWidth, int copyHeight, ImageData data) {
        int dstBegin;
        int rowBegin = srcY;
        int rowInc = 1;
        assert (data != null);
        int dataWidth = data.dataWidth;
        int dataHeight = data.dataHeight;
        int dstBytesPerRow = dataWidth * this.unitsPerPixel;
        if (this.yUp) {
            dstBegin = (depthIndex * dataWidth * dataHeight + dstY * dataWidth + dstX) * this.unitsPerPixel;
        } else {
            dstBegin = (depthIndex * dataWidth * dataHeight + (dataHeight - dstY - 1) * dataWidth + dstX) * this.unitsPerPixel;
            dstBytesPerRow = -1 * dstBytesPerRow;
        }
        WritableRaster ras = bi.getRaster();
        ColorModel cm = bi.getColorModel();
        Object pixel = ImageComponentRetained.getDataElementBuffer(ras);
        byte[] dstBuffer = data.getAsByteArray();
        switch (this.numberOfComponents) {
            case 4: {
                int row = rowBegin;
                int h = 0;
                while (h < copyHeight) {
                    int j = dstBegin;
                    for (int w = srcX; w < copyWidth + srcX; ++w) {
                        ras.getDataElements(w, row, pixel);
                        dstBuffer[j++] = (byte)cm.getRed(pixel);
                        dstBuffer[j++] = (byte)cm.getGreen(pixel);
                        dstBuffer[j++] = (byte)cm.getBlue(pixel);
                        dstBuffer[j++] = (byte)cm.getAlpha(pixel);
                    }
                    dstBegin += dstBytesPerRow;
                    ++h;
                    row += rowInc;
                }
                break;
            }
            case 3: {
                int row = rowBegin;
                int h = 0;
                while (h < copyHeight) {
                    int j = dstBegin;
                    for (int w = srcX; w < copyWidth + srcX; ++w) {
                        ras.getDataElements(w, row, pixel);
                        dstBuffer[j++] = (byte)cm.getRed(pixel);
                        dstBuffer[j++] = (byte)cm.getGreen(pixel);
                        dstBuffer[j++] = (byte)cm.getBlue(pixel);
                    }
                    dstBegin += dstBytesPerRow;
                    ++h;
                    row += rowInc;
                }
                break;
            }
            case 2: {
                int row = rowBegin;
                int h = 0;
                while (h < copyHeight) {
                    int j = dstBegin;
                    for (int w = srcX; w < copyWidth + srcX; ++w) {
                        ras.getDataElements(w, row, pixel);
                        dstBuffer[j++] = (byte)cm.getRed(pixel);
                        dstBuffer[j++] = (byte)cm.getAlpha(pixel);
                    }
                    dstBegin += dstBytesPerRow;
                    ++h;
                    row += rowInc;
                }
                break;
            }
            case 1: {
                int row = rowBegin;
                int h = 0;
                while (h < copyHeight) {
                    int j = dstBegin;
                    for (int w = srcX; w < copyWidth + srcX; ++w) {
                        ras.getDataElements(w, row, pixel);
                        dstBuffer[j++] = (byte)cm.getRed(pixel);
                    }
                    dstBegin += dstBytesPerRow;
                    ++h;
                    row += rowInc;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == data && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(depthIndex);
        }
    }

    void copyUnsupportedImageToImageData(RenderedImage ri, int srcX, int srcY, int dstX, int dstY, int depthIndex, int copyWidth, int copyHeight, ImageData data) {
        int dstLineBytes;
        int sign;
        int tileStart;
        Object pixel = null;
        ColorModel cm = ri.getColorModel();
        int xoff = ri.getTileGridXOffset();
        int yoff = ri.getTileGridYOffset();
        int minTileX = ri.getMinTileX();
        int minTileY = ri.getMinTileY();
        this.tilew = ri.getTileWidth();
        this.tileh = ri.getTileHeight();
        float mt = (float)(srcX - xoff) / (float)this.tilew;
        minTileX = mt < 0.0f ? (int)(mt - 1.0f) : (int)mt;
        mt = (float)(srcY - yoff) / (float)this.tileh;
        minTileY = mt < 0.0f ? (int)(mt - 1.0f) : (int)mt;
        int startXTile = minTileX * this.tilew + xoff;
        int startYTile = minTileY * this.tileh + yoff;
        int curw = startXTile + this.tilew - srcX;
        int curh = startYTile + this.tileh - srcY;
        if (curw > copyWidth) {
            curw = copyWidth;
        }
        if (curh > copyHeight) {
            curh = copyHeight;
        }
        int startw = curw;
        int tmpw = copyWidth;
        int tmph = copyHeight;
        int x = srcX - startXTile;
        int y = srcY - startYTile;
        this.numXTiles = (copyWidth + x) / this.tilew;
        this.numYTiles = (copyHeight + y) / this.tileh;
        if ((float)(copyWidth + x) % (float)this.tilew > 0.0f) {
            ++this.numXTiles;
        }
        if ((float)(copyHeight + y) % (float)this.tileh > 0.0f) {
            ++this.numYTiles;
        }
        assert (data != null);
        int dataWidth = data.dataWidth;
        int dataHeight = data.dataHeight;
        int lineBytes = dataWidth * this.unitsPerPixel;
        if (this.yUp) {
            tileStart = (depthIndex * dataWidth * dataHeight + dstY * dataWidth + dstX) * this.unitsPerPixel;
            sign = 1;
            dstLineBytes = lineBytes;
        } else {
            tileStart = (depthIndex * dataWidth * dataHeight + (dataHeight - dstY - 1) * dataWidth + dstX) * this.unitsPerPixel;
            sign = -1;
            dstLineBytes = -lineBytes;
        }
        Raster ras = ri.getTile(minTileX, minTileY);
        pixel = ImageComponentRetained.getDataElementBuffer(ras);
        byte[] dstBuffer = this.imageData.getAsByteArray();
        switch (this.numberOfComponents) {
            case 4: {
                for (int n = minTileY; n < minTileY + this.numYTiles; ++n) {
                    int dstBegin = tileStart;
                    tmpw = copyWidth;
                    curw = startw;
                    x = srcX - startXTile;
                    for (int m = minTileX; m < minTileX + this.numXTiles; ++m) {
                        ras = ri.getTile(m, n);
                        int j = dstBegin;
                        int offset = 0;
                        for (int h = y; h < y + curh; ++h) {
                            for (int w = x; w < x + curw; ++w) {
                                ras.getDataElements(w, h, pixel);
                                dstBuffer[j++] = (byte)cm.getRed(pixel);
                                dstBuffer[j++] = (byte)cm.getGreen(pixel);
                                dstBuffer[j++] = (byte)cm.getBlue(pixel);
                                dstBuffer[j++] = (byte)cm.getAlpha(pixel);
                            }
                            j = dstBegin + (offset += dstLineBytes);
                        }
                        dstBegin += curw * this.unitsPerPixel;
                        x = 0;
                        curw = (tmpw -= curw) < this.tilew ? tmpw : this.tilew;
                    }
                    tileStart += dataWidth * this.unitsPerPixel * curh * sign;
                    y = 0;
                    curh = (tmph -= curh) < this.tileh ? tmph : this.tileh;
                }
                break;
            }
            case 3: {
                for (int n = minTileY; n < minTileY + this.numYTiles; ++n) {
                    int dstBegin = tileStart;
                    tmpw = copyWidth;
                    curw = startw;
                    x = srcX - startXTile;
                    for (int m = minTileX; m < minTileX + this.numXTiles; ++m) {
                        ras = ri.getTile(m, n);
                        int j = dstBegin;
                        int offset = 0;
                        for (int h = y; h < y + curh; ++h) {
                            for (int w = x; w < x + curw; ++w) {
                                ras.getDataElements(w, h, pixel);
                                dstBuffer[j++] = (byte)cm.getRed(pixel);
                                dstBuffer[j++] = (byte)cm.getGreen(pixel);
                                dstBuffer[j++] = (byte)cm.getBlue(pixel);
                            }
                            j = dstBegin + (offset += dstLineBytes);
                        }
                        dstBegin += curw * this.unitsPerPixel;
                        x = 0;
                        curw = (tmpw -= curw) < this.tilew ? tmpw : this.tilew;
                    }
                    tileStart += dataWidth * this.unitsPerPixel * curh * sign;
                    y = 0;
                    curh = (tmph -= curh) < this.tileh ? tmph : this.tileh;
                }
                break;
            }
            case 2: {
                for (int n = minTileY; n < minTileY + this.numYTiles; ++n) {
                    int dstBegin = tileStart;
                    tmpw = copyWidth;
                    curw = startw;
                    x = srcX - startXTile;
                    for (int m = minTileX; m < minTileX + this.numXTiles; ++m) {
                        ras = ri.getTile(m, n);
                        int j = dstBegin;
                        int offset = 0;
                        for (int h = y; h < y + curh; ++h) {
                            for (int w = x; w < x + curw; ++w) {
                                ras.getDataElements(w, h, pixel);
                                dstBuffer[j++] = (byte)cm.getRed(pixel);
                                dstBuffer[j++] = (byte)cm.getAlpha(pixel);
                            }
                            j = dstBegin + (offset += dstLineBytes);
                        }
                        dstBegin += curw * this.unitsPerPixel;
                        x = 0;
                        curw = (tmpw -= curw) < this.tilew ? tmpw : this.tilew;
                    }
                    tileStart += dataWidth * this.unitsPerPixel * curh * sign;
                    y = 0;
                    curh = (tmph -= curh) < this.tileh ? tmph : this.tileh;
                }
                break;
            }
            case 1: {
                for (int n = minTileY; n < minTileY + this.numYTiles; ++n) {
                    int dstBegin = tileStart;
                    tmpw = copyWidth;
                    curw = startw;
                    x = srcX - startXTile;
                    for (int m = minTileX; m < minTileX + this.numXTiles; ++m) {
                        ras = ri.getTile(m, n);
                        int j = dstBegin;
                        int offset = 0;
                        for (int h = y; h < y + curh; ++h) {
                            for (int w = x; w < x + curw; ++w) {
                                ras.getDataElements(w, h, pixel);
                                dstBuffer[j++] = (byte)cm.getRed(pixel);
                            }
                            j = dstBegin + (offset += dstLineBytes);
                        }
                        dstBegin += curw * this.unitsPerPixel;
                        x = 0;
                        curw = (tmpw -= curw) < this.tilew ? tmpw : this.tilew;
                    }
                    tileStart += dataWidth * this.unitsPerPixel * curh * sign;
                    y = 0;
                    curh = (tmph -= curh) < this.tileh ? tmph : this.tileh;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.imageData == data && this.imageDataPowerOfTwo != null) {
            this.updateImageDataPowerOfTwo(depthIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateExtensions(Canvas3D canvas) {
        Object object = this.evaluateExtLock;
        synchronized (object) {
            this.evaluateExtABGR(canvas.extensionsSupported);
            this.evaluateExtNonPowerOfTwo(canvas.textureExtendedFeatures);
        }
    }

    void evaluateExtABGR(int ext) {
        if (!this.abgrSupported) {
            return;
        }
        if (this.getImageFormatType() != ImageFormatType.TYPE_BYTE_ABGR) {
            return;
        }
        if ((ext & 2) != 0) {
            return;
        }
        this.abgrSupported = false;
        this.convertImageDataFromABGRToRGBA();
    }

    private int getClosestPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        while (value >= (powerValue *= 2)) {
        }
        int minBound = powerValue / 2;
        if (powerValue - value > value - minBound) {
            return minBound;
        }
        return powerValue;
    }

    private int getCeilPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        while (value > (powerValue *= 2)) {
        }
        return powerValue;
    }

    void evaluateExtNonPowerOfTwo(int ext) {
        int npotHeight;
        int npotWidth;
        if (!this.enforceNonPowerOfTwoSupport) {
            return;
        }
        if (!this.npotSupported) {
            return;
        }
        if (this.imageData == null && !this.isByReference()) {
            return;
        }
        if ((ext & 0x8000) != 0) {
            return;
        }
        this.npotSupported = false;
        if (this.width * this.height < 262144) {
            npotWidth = this.getCeilPowerOf2(this.width);
            npotHeight = this.getCeilPowerOf2(this.height);
        } else {
            npotWidth = this.getClosestPowerOf2(this.width);
            npotHeight = this.getClosestPowerOf2(this.height);
        }
        float xScale = (float)npotWidth / (float)this.width;
        float yScale = (float)npotHeight / (float)this.height;
        if (xScale != 1.0f || yScale != 1.0f) {
            if (this.imageData == null) {
                RenderedImage ri = (RenderedImage)this.getRefImage(0);
                assert (!(ri instanceof BufferedImage));
                ColorModel cm = ri.getColorModel();
                WritableRaster wRaster = ri.copyData(null);
                ri = new BufferedImage(cm, wRaster, cm.isAlphaPremultiplied(), null);
                this.imageData = this.createRenderedImageDataObject(null);
                this.copySupportedImageToImageData(ri, 0, this.imageData);
            }
            assert (this.imageData != null);
            BufferedImage bi = this.imageData.createBufferedImage(0);
            int imageType = bi.getType();
            BufferedImage scaledImg = new BufferedImage(npotWidth, npotHeight, imageType);
            AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
            this.powerOfTwoATOp = new AffineTransformOp(at, 2);
            this.powerOfTwoATOp.filter(bi, scaledImg);
            this.imageDataPowerOfTwo = this.createRenderedImageDataObject(null, npotWidth, npotHeight);
            this.copySupportedImageToImageData(scaledImg, 0, this.imageDataPowerOfTwo);
        } else {
            this.imageDataPowerOfTwo = null;
        }
    }

    void convertImageDataFromABGRToRGBA() {
        this.imageFormatType = ImageFormatType.TYPE_BYTE_RGBA;
        this.imageTypeIsSupported = false;
        this.imageData.convertFromABGRToRGBA();
    }

    void copyToRefImage(int depth) {
        int dstBegin;
        assert (this.refImage[depth] != null);
        assert (this.refImage[depth] instanceof BufferedImage);
        BufferedImage bi = (BufferedImage)this.refImage[depth];
        int dstUnitsPerRow = this.width * this.unitsPerPixel;
        int rowBegin = 0;
        if (this.yUp) {
            dstBegin = depth * this.width * this.height * this.unitsPerPixel;
        } else {
            dstBegin = (depth * this.width * this.height + (this.height - 1) * this.width) * this.unitsPerPixel;
            dstUnitsPerRow = -1 * dstUnitsPerRow;
        }
        int scanline = this.width * this.unitsPerPixel;
        int srcBegin = rowBegin * this.width * this.unitsPerPixel;
        switch (this.imageData.getType()) {
            case TYPE_BYTE_ARRAY: {
                byte[] dstByteBuffer = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                byte[] srcByteBuffer = this.imageData.getAsByteArray();
                for (int h = 0; h < this.height; ++h) {
                    System.arraycopy(srcByteBuffer, srcBegin, dstByteBuffer, dstBegin, scanline);
                    dstBegin += dstUnitsPerRow;
                    srcBegin += scanline;
                }
                break;
            }
            case TYPE_INT_ARRAY: {
                int[] dstIntBuffer = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                int[] srcIntBuffer = this.imageData.getAsIntArray();
                for (int h = 0; h < this.height; ++h) {
                    System.arraycopy(srcIntBuffer, srcBegin, dstIntBuffer, dstBegin, scanline);
                    dstBegin += dstUnitsPerRow;
                    srcBegin += scanline;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void copyToRefImageWithFormatConversion(int depth) {
        int dstIndexInc;
        int dstIndex;
        int dstBegin;
        int dstInc;
        assert (this.refImage[depth] != null);
        assert (this.refImage[depth] instanceof BufferedImage);
        BufferedImage bi = (BufferedImage)this.refImage[depth];
        int biType = bi.getType();
        byte[] buf = this.imageData.getAsByteArray();
        if (!this.yUp) {
            dstInc = -1 * this.width;
            dstBegin = (this.height - 1) * this.width;
            dstIndex = this.height - 1;
            dstIndexInc = -1;
        } else {
            dstInc = this.width;
            dstBegin = 0;
            dstIndex = 0;
            dstIndexInc = 1;
        }
        block0 : switch (biType) {
            case 2: {
                int[] intData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                int j = 0;
                switch (this.imageFormatType) {
                    case TYPE_BYTE_RGBA: {
                        int h = 0;
                        while (h < this.height) {
                            int i = dstBegin;
                            int w = 0;
                            while (w < this.width) {
                                intData[i] = (buf[j + 3] & 0xFF) << 24 | (buf[j] & 0xFF) << 16 | (buf[j + 1] & 0xFF) << 8 | buf[j + 2] & 0xFF;
                                ++w;
                                j += 4;
                                ++i;
                            }
                            ++h;
                            dstBegin += dstInc;
                        }
                        break block0;
                    }
                    case TYPE_BYTE_RGB: {
                        int h = 0;
                        while (h < this.height) {
                            int i = dstBegin;
                            int w = 0;
                            while (w < this.width) {
                                intData[i] = 0xFF000000 | (buf[j] & 0xFF) << 16 | (buf[j + 1] & 0xFF) << 8 | buf[j + 2] & 0xFF;
                                ++w;
                                j += 3;
                                ++i;
                            }
                            ++h;
                            dstBegin += dstInc;
                        }
                        break block0;
                    }
                    default: {
                        assert (false);
                        break block0;
                    }
                }
            }
            case 1: {
                int[] intData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                int j = 0;
                int h = 0;
                while (h < this.height) {
                    int i = dstBegin;
                    int w = 0;
                    while (w < this.width) {
                        intData[i] = 0xFF000000 | (buf[j] & 0xFF) << 16 | (buf[j + 1] & 0xFF) << 8 | buf[j + 2] & 0xFF;
                        ++w;
                        j += 4;
                        ++i;
                    }
                    ++h;
                    dstBegin += dstInc;
                }
                break;
            }
            case 6: {
                byte[] byteData = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                int j = 0;
                dstBegin <<= 2;
                switch (this.imageFormatType) {
                    case TYPE_BYTE_RGBA: {
                        int h = 0;
                        while (h < this.height) {
                            int i = dstBegin;
                            int w = 0;
                            while (w < this.width) {
                                byteData[i++] = buf[j + 3];
                                byteData[i++] = buf[j + 2];
                                byteData[i++] = buf[j + 1];
                                byteData[i++] = buf[j];
                                ++w;
                                j += 4;
                            }
                            ++h;
                            dstBegin += dstInc << 2;
                        }
                        break block0;
                    }
                    case TYPE_BYTE_RGB: {
                        int h = 0;
                        while (h < this.height) {
                            int i = dstBegin;
                            int w = 0;
                            while (w < this.width) {
                                byteData[i++] = -1;
                                byteData[i++] = buf[j + 2];
                                byteData[i++] = buf[j + 1];
                                byteData[i++] = buf[j];
                                ++w;
                                j += 3;
                            }
                            ++h;
                            dstBegin += dstInc << 2;
                        }
                        break block0;
                    }
                    default: {
                        assert (false);
                        break block0;
                    }
                }
            }
            case 4: {
                int[] intData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                int j = 0;
                int h = 0;
                while (h < this.height) {
                    int i = dstBegin;
                    int w = 0;
                    while (w < this.width) {
                        intData[i] = 0xFF000000 | buf[j] & 0xFF | (buf[j + 1] & 0xFF) << 8 | (buf[j + 2] & 0xFF) << 16;
                        ++w;
                        j += 4;
                        ++i;
                    }
                    ++h;
                    dstBegin += dstInc;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    synchronized void addUser(NodeComponentRetained node) {
        this.userList.add(node);
    }

    synchronized void removeUser(NodeComponentRetained node) {
        int i = this.userList.indexOf(node);
        if (i >= 0) {
            this.userList.remove(i);
        }
    }

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        if (this.getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("ImageComponent3"));
        }
        super.setLive(inBackgroundGroup, refCount);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        if ((component & 1) == 0 && (component & 2) == 0) {
            return;
        }
        for (int i = this.userList.size() - 1; i >= 0; --i) {
            NodeComponentRetained user = this.userList.get(i);
            if (user == null) continue;
            if (user instanceof TextureRetained) {
                ((TextureRetained)user).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)value);
                continue;
            }
            if (!(user instanceof RasterRetained)) continue;
            ((RasterRetained)user).notifyImageComponentImageChanged(this, (ImageComponentUpdateInfo)value);
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1152;
        createMessage.type = 54;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 3) {
            this.setFrequencyChangeMask(3, 1);
        }
    }

    static Object getDataElementBuffer(Raster ras) {
        int nc = ras.getNumDataElements();
        switch (ras.getTransferType()) {
            case 3: {
                return new int[nc];
            }
            case 0: {
                return new byte[nc];
            }
            case 1: 
            case 2: {
                return new short[nc];
            }
            case 4: {
                return new float[nc];
            }
            case 5: {
                return new double[nc];
            }
        }
        return null;
    }

    class ImageData {
        private Object data = null;
        private ImageDataType imageDataType = ImageDataType.TYPE_NULL;
        private int length = 0;
        private boolean dataIsByRef = false;
        private int dataWidth;
        private int dataHeight;

        ImageData(ImageDataType imageDataType, int length, int dataWidth, int dataHeight) {
            this.imageDataType = imageDataType;
            this.length = length;
            this.dataWidth = dataWidth;
            this.dataHeight = dataHeight;
            this.dataIsByRef = false;
            switch (imageDataType) {
                case TYPE_BYTE_ARRAY: {
                    this.data = new byte[length];
                    break;
                }
                case TYPE_INT_ARRAY: {
                    this.data = new int[length];
                    break;
                }
                case TYPE_BYTE_BUFFER: {
                    ByteOrder order = ByteOrder.nativeOrder();
                    this.data = ByteBuffer.allocateDirect(length).order(order);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        ImageData(ImageDataType imageDataType, int length, int dataWidth, int dataHeight, Object byRefImage) {
            this.imageDataType = imageDataType;
            this.length = length;
            this.dataWidth = dataWidth;
            this.dataHeight = dataHeight;
            this.dataIsByRef = true;
            switch (imageDataType) {
                case TYPE_BYTE_ARRAY: {
                    BufferedImage bi = (BufferedImage)byRefImage;
                    this.data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                    break;
                }
                case TYPE_INT_ARRAY: {
                    BufferedImage bi = (BufferedImage)byRefImage;
                    this.data = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                    break;
                }
                case TYPE_BYTE_BUFFER: 
                case TYPE_INT_BUFFER: {
                    NioImageBuffer nio = (NioImageBuffer)byRefImage;
                    this.data = nio.getDataBuffer();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        ImageData(Object data, boolean isByRef) {
            this.data = data;
            this.dataIsByRef = isByRef;
            this.dataWidth = ((ImageData)data).dataWidth;
            this.dataHeight = ((ImageData)data).dataHeight;
            if (data == null) {
                this.imageDataType = ImageDataType.TYPE_NULL;
                this.length = 0;
            } else if (data instanceof byte[]) {
                this.imageDataType = ImageDataType.TYPE_BYTE_ARRAY;
                this.length = ((byte[])data).length;
            } else if (data instanceof int[]) {
                this.imageDataType = ImageDataType.TYPE_INT_ARRAY;
                this.length = ((int[])data).length;
            } else if (data instanceof ByteBuffer) {
                this.imageDataType = ImageDataType.TYPE_BYTE_BUFFER;
                this.length = ((ByteBuffer)data).limit();
            } else if (data instanceof IntBuffer) {
                this.imageDataType = ImageDataType.TYPE_INT_BUFFER;
                this.length = ((IntBuffer)data).limit();
            } else assert (false);
        }

        ImageDataType getType() {
            return this.imageDataType;
        }

        int length() {
            return this.length;
        }

        int getWidth() {
            return this.dataWidth;
        }

        int getHeight() {
            return this.dataHeight;
        }

        Object get() {
            return this.data;
        }

        boolean isDataByRef() {
            return this.dataIsByRef;
        }

        byte[] getAsByteArray() {
            return (byte[])this.data;
        }

        int[] getAsIntArray() {
            return (int[])this.data;
        }

        ByteBuffer getAsByteBuffer() {
            return (ByteBuffer)this.data;
        }

        IntBuffer getAsIntBuffer() {
            return (IntBuffer)this.data;
        }

        void copyByLineAndExpand(BufferedImage bi, int depthIndex) {
            int srcBegin;
            int unitsPerRow;
            assert (ImageComponentRetained.this.imageData.getType() == ImageDataType.TYPE_BYTE_ARRAY);
            assert (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_LA);
            int scanline = unitsPerRow = ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel;
            if (ImageComponentRetained.this.yUp) {
                srcBegin = depthIndex * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            } else {
                srcBegin = (depthIndex * ImageComponentRetained.this.width * ImageComponentRetained.this.height + (ImageComponentRetained.this.height - 1) * ImageComponentRetained.this.width) * ImageComponentRetained.this.unitsPerPixel;
                unitsPerRow = -1 * unitsPerRow;
            }
            int dstBegin = 0;
            int dstUnitsPerRow = ImageComponentRetained.this.width * 4;
            byte[] dstByteBuffer = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
            byte[] srcByteBuffer = ImageComponentRetained.this.imageData.getAsByteArray();
            for (int h = 0; h < ImageComponentRetained.this.height; ++h) {
                int v = 0;
                int w = 0;
                while (w < scanline) {
                    dstByteBuffer[dstBegin + v] = srcByteBuffer[srcBegin + w + 1];
                    dstByteBuffer[dstBegin + v + 1] = 0;
                    dstByteBuffer[dstBegin + v + 2] = 0;
                    dstByteBuffer[dstBegin + v + 3] = srcByteBuffer[srcBegin + w];
                    w += ImageComponentRetained.this.unitsPerPixel;
                    v += 4;
                }
                dstBegin += dstUnitsPerRow;
                srcBegin += unitsPerRow;
            }
        }

        void copyByLine(BufferedImage bi, int depthIndex, boolean swapNeeded) {
            int srcBegin;
            int unitsPerRow;
            int copyUnits = unitsPerRow = ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel;
            if (ImageComponentRetained.this.yUp) {
                srcBegin = depthIndex * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            } else {
                srcBegin = (depthIndex * ImageComponentRetained.this.width * ImageComponentRetained.this.height + (ImageComponentRetained.this.height - 1) * ImageComponentRetained.this.width) * ImageComponentRetained.this.unitsPerPixel;
                unitsPerRow = -1 * unitsPerRow;
            }
            int dstBegin = 0;
            switch (ImageComponentRetained.this.imageData.getType()) {
                case TYPE_BYTE_ARRAY: {
                    byte[] dstByteBuffer = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                    byte[] srcByteBuffer = ImageComponentRetained.this.imageData.getAsByteArray();
                    for (int h = 0; h < ImageComponentRetained.this.height; ++h) {
                        int w;
                        if (!swapNeeded) {
                            System.arraycopy(srcByteBuffer, srcBegin, dstByteBuffer, dstBegin, copyUnits);
                        } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_RGB) {
                            assert (ImageComponentRetained.this.unitsPerPixel == 3);
                            for (w = 0; w < copyUnits; w += ImageComponentRetained.this.unitsPerPixel) {
                                dstByteBuffer[dstBegin + w] = srcByteBuffer[srcBegin + w + 2];
                                dstByteBuffer[dstBegin + w + 1] = srcByteBuffer[srcBegin + w + 1];
                                dstByteBuffer[dstBegin + w + 2] = srcByteBuffer[srcBegin + w];
                            }
                        } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_RGBA) {
                            assert (ImageComponentRetained.this.unitsPerPixel == 4);
                            for (w = 0; w < copyUnits; w += ImageComponentRetained.this.unitsPerPixel) {
                                dstByteBuffer[dstBegin + w] = srcByteBuffer[srcBegin + w + 3];
                                dstByteBuffer[dstBegin + w + 1] = srcByteBuffer[srcBegin + w + 2];
                                dstByteBuffer[dstBegin + w + 2] = srcByteBuffer[srcBegin + w + 1];
                                dstByteBuffer[dstBegin + w + 3] = srcByteBuffer[srcBegin + w];
                            }
                        } else assert (false);
                        dstBegin += copyUnits;
                        srcBegin += unitsPerRow;
                    }
                    break;
                }
                case TYPE_INT_ARRAY: {
                    assert (!swapNeeded);
                    int[] dstIntBuffer = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                    int[] srcIntBuffer = ImageComponentRetained.this.imageData.getAsIntArray();
                    for (int h = 0; h < ImageComponentRetained.this.height; ++h) {
                        System.arraycopy(srcIntBuffer, srcBegin, dstIntBuffer, dstBegin, copyUnits);
                        dstBegin += copyUnits;
                        srcBegin += unitsPerRow;
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        void copyByBlock(BufferedImage bi, int depthIndex) {
            int srcBegin = depthIndex * ImageComponentRetained.this.width * ImageComponentRetained.this.height * ImageComponentRetained.this.unitsPerPixel;
            switch (ImageComponentRetained.this.imageData.getType()) {
                case TYPE_BYTE_ARRAY: {
                    byte[] dstByteBuffer = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                    byte[] srcByteBuffer = ImageComponentRetained.this.imageData.getAsByteArray();
                    System.arraycopy(srcByteBuffer, srcBegin, dstByteBuffer, 0, ImageComponentRetained.this.height * ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel);
                    break;
                }
                case TYPE_INT_ARRAY: {
                    int[] dstIntBuffer = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                    int[] srcIntBuffer = ImageComponentRetained.this.imageData.getAsIntArray();
                    System.arraycopy(srcIntBuffer, srcBegin, dstIntBuffer, 0, ImageComponentRetained.this.height * ImageComponentRetained.this.width * ImageComponentRetained.this.unitsPerPixel);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        BufferedImage createBufferedImage(int depthIndex) {
            if (this.data != null) {
                int bufferType = 0;
                boolean swapNeeded = false;
                switch (ImageComponentRetained.this.imageFormatType) {
                    case TYPE_BYTE_BGR: {
                        bufferType = 5;
                        break;
                    }
                    case TYPE_BYTE_RGB: {
                        bufferType = 5;
                        swapNeeded = true;
                        break;
                    }
                    case TYPE_BYTE_ABGR: {
                        bufferType = 6;
                        break;
                    }
                    case TYPE_BYTE_RGBA: {
                        bufferType = 6;
                        swapNeeded = true;
                        break;
                    }
                    case TYPE_BYTE_LA: {
                        bufferType = 6;
                        break;
                    }
                    case TYPE_BYTE_GRAY: {
                        bufferType = 10;
                        break;
                    }
                    case TYPE_INT_BGR: {
                        bufferType = 4;
                        break;
                    }
                    case TYPE_INT_RGB: {
                        bufferType = 1;
                        break;
                    }
                    case TYPE_INT_ARGB: {
                        bufferType = 2;
                        break;
                    }
                    case TYPE_USHORT_GRAY: {
                        bufferType = 11;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                BufferedImage bi = new BufferedImage(ImageComponentRetained.this.width, ImageComponentRetained.this.height, bufferType);
                if (!swapNeeded && ImageComponentRetained.this.imageFormatType != ImageFormatType.TYPE_BYTE_LA) {
                    if (ImageComponentRetained.this.yUp) {
                        this.copyByBlock(bi, depthIndex);
                    } else {
                        this.copyByLine(bi, depthIndex, false);
                    }
                } else if (swapNeeded) {
                    this.copyByLine(bi, depthIndex, swapNeeded);
                } else if (ImageComponentRetained.this.imageFormatType == ImageFormatType.TYPE_BYTE_LA) {
                    this.copyByLineAndExpand(bi, depthIndex);
                } else assert (false);
                return bi;
            }
            return null;
        }

        void convertFromABGRToRGBA() {
            if (this.imageDataType == ImageDataType.TYPE_BYTE_ARRAY) {
                byte[] srcBuffer = this.getAsByteArray();
                if (this.dataIsByRef) {
                    byte[] dstBuffer = new byte[this.length];
                    for (int i = 0; i < this.length; i += 4) {
                        dstBuffer[i] = srcBuffer[i + 3];
                        dstBuffer[i + 1] = srcBuffer[i + 2];
                        dstBuffer[i + 2] = srcBuffer[i + 1];
                        dstBuffer[i + 3] = srcBuffer[i];
                    }
                    this.data = dstBuffer;
                    this.dataIsByRef = false;
                } else {
                    for (int i = 0; i < this.length; i += 4) {
                        byte a = srcBuffer[i];
                        byte b = srcBuffer[i + 1];
                        srcBuffer[i] = srcBuffer[i + 3];
                        srcBuffer[i + 1] = srcBuffer[i + 2];
                        srcBuffer[i + 2] = b;
                        srcBuffer[i + 3] = a;
                    }
                }
            } else if (this.imageDataType == ImageDataType.TYPE_BYTE_BUFFER) {
                assert (this.dataIsByRef);
                ByteBuffer srcBuffer = this.getAsByteBuffer();
                srcBuffer.rewind();
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer dstBuffer = ByteBuffer.allocateDirect(this.length).order(order);
                dstBuffer.rewind();
                for (int i = 0; i < this.length; i += 4) {
                    dstBuffer.put(i, srcBuffer.get(i + 3));
                    dstBuffer.put(i + 1, srcBuffer.get(i + 2));
                    dstBuffer.put(i + 2, srcBuffer.get(i + 1));
                    dstBuffer.put(i + 3, srcBuffer.get(i));
                }
                this.dataIsByRef = false;
            }
        }
    }

    static enum ImageDataType {
        TYPE_NULL,
        TYPE_BYTE_ARRAY,
        TYPE_INT_ARRAY,
        TYPE_BYTE_BUFFER,
        TYPE_INT_BUFFER;

    }

    static enum ImageFormatType {
        TYPE_UNKNOWN,
        TYPE_BYTE_BGR,
        TYPE_BYTE_RGB,
        TYPE_BYTE_ABGR,
        TYPE_BYTE_RGBA,
        TYPE_BYTE_LA,
        TYPE_BYTE_GRAY,
        TYPE_USHORT_GRAY,
        TYPE_INT_BGR,
        TYPE_INT_RGB,
        TYPE_INT_ARGB;

    }
}

