/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.integer.IntType;

public class BinaryInterpolation2D
implements OutputAlgorithm<BitType> {
    private final Image<BitType> img1;
    private final Image<BitType> img2;
    private float weight;
    private Image<BitType> interpolated;
    private String errorMessage;
    private IDT2D idt1;
    private IDT2D idt2;

    public BinaryInterpolation2D(Image<BitType> img1, Image<BitType> img2, float weight) {
        this.img1 = img1;
        this.img2 = img2;
        this.weight = weight;
    }

    public Image<BitType> getResult() {
        return this.interpolated;
    }

    public boolean checkInput() {
        if (this.img1.getNumDimensions() < 2 || this.img2.getNumDimensions() < 2) {
            this.errorMessage = "Need at least 2 dimensions";
            return false;
        }
        if (this.img1.getDimension(0) != this.img2.getDimension(0) || this.img1.getDimension(1) != this.img2.getDimension(1)) {
            this.errorMessage = "Dimensions do not match";
            return false;
        }
        if (this.weight < 0.0f || this.weight > 1.0f) {
            this.errorMessage = "Weight must be between 0 and 1, both inclusive.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setWeight(float weight) throws IllegalArgumentException {
        if (weight < 0.0f || weight > 1.0f) {
            throw new IllegalArgumentException("Weight must be between 0 and 1, both inclusive.");
        }
        this.weight = weight;
    }

    public boolean process() {
        this.interpolated = this.process(this.weight);
        return null != this.interpolated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image<BitType> process(float weight) {
        Cursor c2;
        Cursor c1;
        BinaryInterpolation2D binaryInterpolation2D = this;
        synchronized (binaryInterpolation2D) {
            if (null == this.idt1 || null == this.idt2) {
                ExecutorService exec = Executors.newFixedThreadPool(Math.min(2, Runtime.getRuntime().availableProcessors()));
                Future<IDT2D> fu1 = exec.submit(new NewITD2D(this.img1));
                Future<IDT2D> fu2 = exec.submit(new NewITD2D(this.img2));
                exec.shutdown();
                try {
                    this.idt1 = fu1.get();
                    this.idt2 = fu2.get();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ImageFactory f = new ImageFactory((Type)new BitType(), (ContainerFactory)new ArrayContainerFactory());
        Image interpolated = f.createImage(new int[]{this.img1.getDimension(0), this.img1.getDimension(1)});
        if (this.img1.getContainer().compareStorageContainerCompatibility(this.img2.getContainer())) {
            c1 = this.idt1.result.createCursor();
            c2 = this.idt2.result.createCursor();
            Cursor ci = interpolated.createCursor();
            while (ci.hasNext()) {
                c1.fwd();
                c2.fwd();
                ci.fwd();
                if (!((float)((IntType)c1.getType()).get() * weight + (float)((IntType)c2.getType()).get() * (1.0f - weight) > 0.0f)) continue;
                ((BitType)ci.getType()).set(true);
            }
            c1.close();
            c2.close();
            ci.close();
        } else {
            System.out.println("using option 2");
            c1 = this.idt1.result.createLocalizableByDimCursor();
            c2 = this.idt2.result.createLocalizableByDimCursor();
            LocalizableByDimCursor ci = interpolated.createLocalizableByDimCursor();
            while (ci.hasNext()) {
                ci.fwd();
                c1.setPosition((Localizable)ci);
                c2.setPosition((Localizable)ci);
                if (!(0.0f <= (float)((IntType)c1.getType()).get() * weight + (float)((IntType)c2.getType()).get() * (1.0f - weight))) continue;
                ((BitType)ci.getType()).set(true);
            }
            c1.close();
            c2.close();
            ci.close();
        }
        return interpolated;
    }

    private final class NewITD2D
    implements Callable<IDT2D> {
        private final Image<BitType> img;

        NewITD2D(Image<BitType> img) {
            this.img = img;
        }

        @Override
        public IDT2D call() throws Exception {
            return new IDT2D(this.img);
        }
    }

    private final class IDT2D {
        final Image<IntType> result;
        final int w;
        final int h;
        final int[] position = new int[2];
        final LocalizableByDimCursor<BitType> csrc;
        final LocalizableByDimCursor<IntType> cout;

        IDT2D(Image<BitType> img) {
            this.w = img.getDimension(0);
            this.h = img.getDimension(1);
            ImageFactory f = new ImageFactory((Type)new IntType(), (ContainerFactory)new ArrayContainerFactory());
            this.result = f.createImage(new int[]{this.w, this.h});
            int infinity = (this.w + this.h) * 9;
            for (IntType v : this.result) {
                v.set(infinity);
            }
            this.csrc = img.createLocalizableByDimCursor();
            this.cout = this.result.createLocalizableByDimCursor();
            int count = 0;
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    if (this.isBoundary(x, y)) {
                        this.setOutValueAt(x, y, 0);
                        ++count;
                        continue;
                    }
                    if (!this.isJustOutside(x, y)) continue;
                    this.setOutValueAt(x, y, -1);
                }
            }
            if (count > 0) {
                this.propagate();
            }
            this.csrc.close();
            this.cout.close();
        }

        private final void setPosition(LocalizableByDimCursor<?> c, int x, int y) {
            this.position[0] = x;
            this.position[1] = y;
            c.setPosition(this.position);
        }

        private final void setOutValueAt(int x, int y, int value) {
            this.setPosition(this.cout, x, y);
            ((IntType)this.cout.getType()).set(value);
        }

        private final int getSrcValueAt(int x, int y) {
            this.setPosition(this.csrc, x, y);
            return ((BitType)this.csrc.getType()).get() ? 1 : 0;
        }

        private final int getOutValueAt(int x, int y) {
            this.setPosition(this.cout, x, y);
            return ((IntType)this.cout.getType()).get();
        }

        private final void idt(int x, int y, int dx, int dy) {
            if (x + dx < 0 || y + dy < 0 || x + dx >= this.w || y + dy >= this.h) {
                return;
            }
            int value = this.getOutValueAt(x + dx, y + dy);
            int distance = dx == 0 || dy == 0 ? 3 : 4;
            int n = value < 0 ? -1 : 1;
            this.setPosition(this.cout, x, y);
            if (Math.abs(((IntType)this.cout.getType()).get()) > Math.abs(value += distance * n)) {
                ((IntType)this.cout.getType()).set(value);
            }
        }

        private final void propagate() {
            int j;
            int i;
            int i2;
            int j2;
            for (j2 = 0; j2 < this.h; ++j2) {
                for (i2 = 0; i2 < this.w; ++i2) {
                    this.idt(i2, j2, -1, 0);
                    this.idt(i2, j2, -1, -1);
                    this.idt(i2, j2, 0, -1);
                }
            }
            for (j2 = this.h - 1; j2 >= 0; --j2) {
                for (i2 = this.w - 1; i2 >= 0; --i2) {
                    this.idt(i2, j2, 1, 0);
                    this.idt(i2, j2, 1, 1);
                    this.idt(i2, j2, 0, 1);
                }
            }
            for (i = this.w - 1; i >= 0; --i) {
                for (j = this.h - 1; j >= 0; --j) {
                    this.idt(i, j, 1, 0);
                    this.idt(i, j, 1, 1);
                    this.idt(i, j, 0, 1);
                }
            }
            for (i = 0; i < this.w; ++i) {
                for (j = 0; j < this.h; ++j) {
                    this.idt(i, j, -1, 0);
                    this.idt(i, j, -1, -1);
                    this.idt(i, j, 0, -1);
                }
            }
        }

        private final boolean isBoundary(int x, int y) {
            if (this.getSrcValueAt(x, y) == 0) {
                return false;
            }
            if (x <= 0 || this.getSrcValueAt(x - 1, y) == 0) {
                return true;
            }
            if (x >= this.w - 1 || this.getSrcValueAt(x + 1, y) == 0) {
                return true;
            }
            if (y <= 0 || this.getSrcValueAt(x, y - 1) == 0) {
                return true;
            }
            if (y >= this.h - 1 || this.getSrcValueAt(x, y + 1) == 0) {
                return true;
            }
            if (x <= 0 || y <= 0 || this.getSrcValueAt(x - 1, y - 1) == 0) {
                return true;
            }
            if (x <= 0 || y >= this.h - 1 || this.getSrcValueAt(x - 1, y + 1) == 0) {
                return true;
            }
            if (x >= this.w - 1 || y <= 0 || this.getSrcValueAt(x + 1, y - 1) == 0) {
                return true;
            }
            return x >= this.w - 1 || y >= this.h - 1 || this.getSrcValueAt(x + 1, y + 1) == 0;
        }

        private final boolean isJustOutside(int x, int y) {
            if (this.getSrcValueAt(x, y) != 0) {
                return false;
            }
            if (x > 0 && this.getSrcValueAt(x - 1, y) != 0) {
                return true;
            }
            if (x < this.w - 1 && this.getSrcValueAt(x + 1, y) != 0) {
                return true;
            }
            if (y > 0 && this.getSrcValueAt(x, y - 1) != 0) {
                return true;
            }
            if (y < this.h - 1 && this.getSrcValueAt(x, y + 1) != 0) {
                return true;
            }
            if (x > 0 && y > 0 && this.getSrcValueAt(x - 1, y - 1) != 0) {
                return true;
            }
            if (x > 0 && y < this.h - 1 && this.getSrcValueAt(x - 1, y + 1) != 0) {
                return true;
            }
            if (x < this.w - 1 && y > 0 && this.getSrcValueAt(x + 1, y - 1) != 0) {
                return true;
            }
            return x < this.w - 1 && y < this.h - 1 && this.getSrcValueAt(x + 1, y + 1) != 0;
        }
    }
}

