/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.ImageStack;
import ij.VirtualStack;
import ij.process.ImageProcessor;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class LazyVirtualStack
extends VirtualStack {
    private final List<Callable<ImageProcessor>> tasks = new ArrayList<Callable<ImageProcessor>>();
    private int initial_size;

    public LazyVirtualStack(int width, int height, int initial_size) {
        Utils.setField((Object)this, ImageStack.class, "width", width);
        Utils.setField((Object)this, ImageStack.class, "height", width);
    }

    public void addSlice(String name) {
        throw new UnsupportedOperationException("LazyVirtualStack accepts Callable<ImageProcessor> slices only.");
    }

    public void deleteSlice(int i) {
        throw new UnsupportedOperationException("LazyVirtualStack: can't remove slices.");
    }

    public void addSlice(Callable<ImageProcessor> task) {
        this.tasks.add(task);
    }

    public ImageProcessor getProcessor(int n) {
        try {
            return this.tasks.get(n - 1).call();
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    public int getSize() {
        return Math.max(this.initial_size, this.tasks.size());
    }
}

