/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.plugin.filter.RankFilters;
import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class RankFilter
implements IFilter {
    protected double radius = 2.0;
    protected int type = 4;

    public RankFilter() {
    }

    public RankFilter(double radius, int type) {
        this.radius = radius;
    }

    public RankFilter(Map<String, String> params) {
        try {
            this.radius = Double.parseDouble(params.get("radius"));
            this.type = Integer.parseInt(params.get("type"));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Cannot create RankFilter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        RankFilters rf = new RankFilters();
        rf.rank(ip, this.radius, 4);
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" radius=\"" + this.radius + "\" type=\"" + this.type + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            RankFilter r = (RankFilter)o;
            return this.type == r.type && this.radius == r.radius;
        }
        return false;
    }
}

