/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ImageProcessor;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.imaging.BinaryInterpolation2D;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.MCTriangulator;
import ini.trakem2.utils.Utils;
import ini.trakem2.vector.Editions;
import ini.trakem2.vector.SkinMaker;
import ini.trakem2.vector.VectorString;
import ini.trakem2.vector.VectorString2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.shapelist.ShapeListCached;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.integer.ByteType;
import org.jogamp.vecmath.Point3f;

public final class AreaUtils {
    public static final String always_interpolate_areas_with_distance_map = "always_interpolate_areas_with_distance_map";

    private AreaUtils() {
    }

    public static List<Point3f> generateTriangles(Displayable d, double scale, int resample_, Map<Layer, Area> areas) {
        try {
            int resample;
            int n = areas.size();
            if (0 == n) {
                return null;
            }
            if (resample_ <= 0) {
                resample = 1;
                Utils.log2("Fixing zero or negative resampling value to 1.");
            } else {
                resample = resample_;
            }
            LayerSet layer_set = d.getLayerSet();
            AffineTransform aff = d.getAffineTransformCopy();
            Rectangle r = d.getBoundingBox(null);
            AffineTransform at_translate = new AffineTransform();
            at_translate.translate(-r.x, -r.y);
            aff.preConcatenate(at_translate);
            AffineTransform atK = new AffineTransform();
            double K = 1.0 / (double)resample * scale;
            atK.scale(K, K);
            aff.preConcatenate(atK);
            Calibration cal = layer_set.getCalibrationCopy();
            Layer first_layer = null;
            Layer last_layer = null;
            int w = (int)Math.ceil((double)r.width * K);
            int h = (int)Math.ceil((double)r.height * K);
            int depth = 0;
            HashMap<Integer, Area> ma = new HashMap<Integer, Area>();
            for (Layer la : layer_set.getLayers()) {
                Area area = areas.get(la);
                if (null != area) {
                    ma.put(depth, area);
                    if (null == first_layer) {
                        first_layer = la;
                    }
                    ++depth;
                    --n;
                } else if (0 != depth) {
                    ++depth;
                }
                if (0 != n) continue;
                last_layer = la;
                break;
            }
            if (0 == depth) {
                Utils.log("ERROR could not find any areas for " + d);
                return null;
            }
            if (0 != n) {
                Utils.log("WARNING could not find all areas for " + d);
            }
            ShapeListCached shapeList = new ShapeListCached(new int[]{w, h, depth}, (Type)new ByteType(), 32);
            Image shapeListImage = new Image((Container)shapeList, shapeList.getBackground(), "ShapeListContainer");
            ByteType intensity = new ByteType(127);
            for (Map.Entry e : ma.entrySet()) {
                Area a = (Area)e.getValue();
                if (!aff.isIdentity()) {
                    a = M.areaInIntsByRounding(a.createTransformedArea(aff));
                }
                shapeList.addShape((Shape)a, (Type)intensity, new int[]{(Integer)e.getKey()});
            }
            List<Point3f> list = new MCTriangulator().getTriangles(shapeListImage, 1, new float[3]);
            int i_first_layer = layer_set.indexOf(first_layer);
            float dx = (float)((double)r.x * scale * cal.pixelWidth);
            float dy = (float)((double)r.y * scale * cal.pixelHeight);
            float rsw = (float)((double)resample * cal.pixelWidth);
            float rsh = (float)((double)resample * cal.pixelHeight);
            double sz = scale * cal.pixelWidth;
            Point3f[] verts = new Point3f[list.size()];
            TreeMap<Integer, Point3f> output = new TreeMap<Integer, Point3f>();
            AreaUtils.fix3DPoints(list, output, verts, first_layer.getZ(), 0.0, -1, dx, dy, rsw, rsh, sz, 1);
            int slice_index = 0;
            for (Layer la : layer_set.getLayers().subList(i_first_layer, i_first_layer + depth)) {
                AreaUtils.fix3DPoints(list, output, verts, la.getZ(), la.getThickness(), slice_index, dx, dy, rsw, rsh, sz, 1);
                ++slice_index;
            }
            try {
                AreaUtils.fix3DPoints(list, output, verts, last_layer.getZ() + last_layer.getThickness(), 0.0, slice_index, dx, dy, rsw, rsh, sz, 2);
            }
            catch (Exception ee) {
                IJError.print(ee);
            }
            if (0 != list.size() - output.size()) {
                Utils.log2("Unprocessed/unused points: " + (list.size() - output.size()));
                for (int i = 0; i < verts.length; ++i) {
                    if (null != verts[i]) continue;
                    Point3f p = list.get(i);
                    Utils.log2("verts[" + i + "] = " + p.x + ", " + p.y + ", " + p.z + "  p.z as int: " + (int)(p.z + 0.05f));
                }
                return new ArrayList<Point3f>(output.values());
            }
            return Arrays.asList(verts);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final void fix3DPoints(List<Point3f> list, TreeMap<Integer, Point3f> output, Point3f[] verts, double la_z, double la_thickness, int layer_index, float dx, float dy, float rsw, float rsh, double sz, int n_slices) {
        int fixed = 0;
        for (int i = 0; i < verts.length; ++i) {
            if (null != verts[i]) continue;
            Point3f p = list.get(i);
            int pz = (int)(p.z + 0.05f);
            if (pz < layer_index || pz >= layer_index + n_slices) continue;
            p.x = p.x * rsw + dx;
            p.y = p.y * rsh + dy;
            p.z = (float)((la_z + la_thickness * (double)(p.z - (float)layer_index)) * sz);
            verts[i] = p;
            output.put(i, p);
            ++fixed;
        }
    }

    public static final Map<Float, Area> extractAreas(ImageProcessor ip) {
        return AreaUtils.extractAreas(ip, null, false, null, Thread.currentThread(), false);
    }

    public static final Map<Float, Area> extractAreas(ImageProcessor ip, HashMap<Float, Area> map_, boolean add_background, Rectangle box_, Thread parent, boolean report) {
        int height = ip.getHeight();
        int width = ip.getWidth();
        int inc = height / 100;
        if (inc < 10) {
            inc = 10;
        }
        HashMap<Float, Area> map = null == map_ ? new HashMap<Float, Area>() : map_;
        Rectangle box = null == box_ ? new Rectangle(0, 0, 1, 1) : box_;
        for (int y = 0; y < height; ++y) {
            if (0 == y % inc) {
                if (parent.isInterrupted()) {
                    return map;
                }
                if (report) {
                    Utils.showStatus("line: " + y + '/' + height);
                }
            }
            float prev = ip.getPixelValue(0, y);
            box.x = 0;
            box.y = y;
            box.width = 0;
            for (int x = 1; x < width; ++x) {
                float pix = ip.getPixelValue(x, y);
                if (pix == prev) {
                    ++box.width;
                    continue;
                }
                if (!Float.isNaN(prev) && (add_background || 0.0f != prev)) {
                    ++box.width;
                    Area area = (Area)map.get(new Float(prev));
                    if (null == area) {
                        area = new Area(box);
                        map.put(new Float(prev), area);
                    } else {
                        area.add(new Area(box));
                    }
                }
                box.x = x;
                box.y = y;
                box.width = 0;
                prev = pix;
            }
            if (Float.isNaN(prev) || !add_background && 0.0f == prev) continue;
            Area area = (Area)map.get(new Float(prev));
            if (null == area) {
                area = new Area(box);
                map.put(new Float(prev), area);
                continue;
            }
            area.add(new Area(box));
        }
        return map;
    }

    public static Area infiniteArea() {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(Double.MAX_VALUE, Double.MAX_VALUE);
        path.lineTo(-1.7976931348623157E308, Double.MAX_VALUE);
        path.lineTo(-1.7976931348623157E308, -1.7976931348623157E308);
        path.lineTo(Double.MAX_VALUE, -1.7976931348623157E308);
        path.lineTo(Double.MAX_VALUE, Double.MAX_VALUE);
        return new Area(path);
    }

    public static final Area[] singularInterpolation(Area a1, Area a2, int nInterpolates) throws Exception {
        if (!a1.isSingular() || !a2.isSingular()) {
            return null;
        }
        VectorString2D vs1 = M.asVectorString2D(M.getPolygons(a1).iterator().next(), 0.0);
        VectorString2D vs2 = M.asVectorString2D(M.getPolygons(a2).iterator().next(), 1.0);
        Editions ed = new Editions((VectorString)vs1, (VectorString)vs2, Math.min(vs1.getAverageDelta(), vs2.getAverageDelta()), true);
        double[][][] d = SkinMaker.getMorphedPerimeters((VectorString2D)vs1, (VectorString2D)vs2, (int)nInterpolates, (Editions)ed);
        Area[] a = new Area[d.length];
        for (int i = 0; i < d.length; ++i) {
            double[] x = d[i][0];
            double[] y = d[i][1];
            int[] xi = new int[x.length];
            int[] yi = new int[y.length];
            for (int k = 0; k < x.length; ++k) {
                xi[k] = (int)x[k];
                yi[k] = (int)y[k];
            }
            a[i] = new Area(new Polygon(xi, yi, xi.length));
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Area[] manyToManyInterpolation(Area a1, Area a2, int nInterpolates) throws InterruptedException, ExecutionException {
        Rectangle b = a1.getBounds();
        b.add(a2.getBounds());
        AffineTransform translate = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -b.x, -b.y);
        ShapeListCached shapeList1 = new ShapeListCached(new int[]{b.width, b.height}, (Type)new BitType(false), 32);
        shapeList1.addShape((Shape)a1.createTransformedArea(translate), (Type)new BitType(true), new int[]{0});
        Image img1 = new Image((Container)shapeList1, shapeList1.getBackground(), "ShapeListContainer");
        ShapeListCached shapeList2 = new ShapeListCached(new int[]{b.width, b.height}, (Type)new BitType(false), 32);
        shapeList2.addShape((Shape)a2.createTransformedArea(translate), (Type)new BitType(true), new int[]{0});
        Image img2 = new Image((Container)shapeList2, shapeList2.getBackground(), "ShapeListContainer");
        float inc = 1.0f / (float)(nInterpolates + 1);
        final BinaryInterpolation2D interpol = new BinaryInterpolation2D((Image<BitType>)img1, (Image<BitType>)img2, inc);
        if (!interpol.checkInput()) {
            System.out.println("Error: " + interpol.getErrorMessage());
            return null;
        }
        Area[] as = new Area[nInterpolates];
        final AffineTransform back = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, b.x, b.y);
        ExecutorService exec = Executors.newFixedThreadPool(Math.min(nInterpolates, Runtime.getRuntime().availableProcessors()));
        ArrayList<Future<Area>> fus = new ArrayList<Future<Area>>();
        try {
            int i;
            for (i = 1; i <= nInterpolates; ++i) {
                final float weight = 1.0f - inc * (float)i;
                fus.add(exec.submit(new Callable<Area>(){

                    @Override
                    public Area call() throws Exception {
                        Image<BitType> imb = interpol.process(weight);
                        ImagePlus imp = ImageJFunctions.copyToImagePlus(imb, (int)0);
                        ThresholdToSelection ts = new ThresholdToSelection();
                        ts.setup("", imp);
                        ImageProcessor ip = imp.getProcessor();
                        ip.setThreshold(1.0, 255.0, 2);
                        ts.run(ip);
                        Roi roi = imp.getRoi();
                        return null == roi ? new Area() : M.getArea(roi).createTransformedArea(back);
                    }
                }));
            }
            i = 0;
            for (Future future : fus) {
                as[i++] = (Area)future.get();
            }
        }
        catch (Throwable t) {
            IJError.print(t);
        }
        finally {
            exec.shutdown();
        }
        return as;
    }
}

