/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.io.ImageFileFilter;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.Utils;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

public class DNDInsertImage
implements DropTargetListener {
    private Display display;
    private DropTarget dt;

    public DNDInsertImage(Display display) {
        this.display = display;
        this.dt = new DropTarget((Component)((Object)display.getCanvas()), this);
    }

    public void destroy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DNDInsertImage.this.dt.setActive(false);
                DNDInsertImage.this.display.getCanvas().setDropTarget(null);
                DNDInsertImage.this.dt.setComponent(null);
            }
        });
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(1);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!this.display.getProject().isInputEnabled()) {
            return;
        }
        try {
            String path;
            Object data;
            dtde.acceptDrop(1);
            Point point = dtde.getLocation();
            point.x = this.display.getCanvas().offScreenX(point.x);
            point.y = this.display.getCanvas().offScreenY(point.y);
            Transferable t = dtde.getTransferable();
            DataFlavor[] flavors = t.getTransferDataFlavors();
            int success = 0;
            if (IJ.isMacOSX() && null != (data = t.getTransferData(DataFlavor.javaFileListFlavor))) {
                for (File f : (List)data) {
                    if (!this.importImageFile(f, path = f.getCanonicalPath().replace('\\', '/'), point)) continue;
                    ++success;
                }
            }
            if (0 == success) {
                for (int i = 0; i < flavors.length; ++i) {
                    String tmp;
                    Object ob;
                    if (!flavors[i].getRepresentationClass().equals(String.class) || !((ob = t.getTransferData(flavors[i])) instanceof String)) continue;
                    String s = ob.toString().trim();
                    BufferedReader br = new BufferedReader(new StringReader(s));
                    while (null != (tmp = br.readLine())) {
                        File f;
                        if ((tmp = URLDecoder.decode(tmp, "UTF-8")).startsWith("file://")) {
                            tmp = tmp.substring(7);
                        }
                        if (!this.importImageFile(f = new File(tmp), tmp, point)) continue;
                        ++success;
                    }
                    break;
                }
            }
            if (0 == success && t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                data = t.getTransferData(DataFlavor.javaFileListFlavor);
                for (File f : (List)data) {
                    path = f.getCanonicalPath().replace('\\', '/');
                    this.importImageFile(f, path, point);
                }
            }
            dtde.dropComplete(true);
        }
        catch (Exception e) {
            dtde.dropComplete(false);
        }
    }

    private boolean importImageFile(File f, String path, Point point) throws Exception {
        if (f.exists()) {
            final Layer layer = this.display.getLayer();
            Bureaucrat burro = null;
            if (f.isDirectory()) {
                GenericDialog gd = new GenericDialog("Import directory");
                String[] choice = new String[]{"Stack", "Grid", "Sequence as grid"};
                gd.addChoice("Directory as: ", choice, choice[0]);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return true;
                }
                this.display.getLayerSet().addLayerContentStep(layer);
                switch (gd.getNextChoiceIndex()) {
                    case 0: {
                        Object[] names = f.list(new ImageFileFilter());
                        Utils.log2("stack size: " + names.length);
                        for (int i = 0; i < names.length; ++i) {
                            Utils.log2((String)names[i]);
                        }
                        Arrays.sort(names);
                        VirtualStack stack = new VirtualStack(10, 10, null, f.getAbsolutePath().replace('\\', '/'));
                        for (int k = 0; k < names.length; ++k) {
                            IJ.redirectErrorMessages();
                            if (((String)names[k]).toLowerCase().endsWith(".xml")) continue;
                            stack.addSlice((String)names[k]);
                        }
                        if (stack.getSize() <= 0) break;
                        burro = this.display.getProject().getLoader().importStack(layer, point.x, point.y, new ImagePlus("stack", (ImageStack)stack), true, path, false);
                        break;
                    }
                    case 1: {
                        burro = this.display.getProject().getLoader().importGrid(layer, path);
                        break;
                    }
                    case 2: {
                        burro = this.display.getProject().getLoader().importSequenceAsGrid(layer, path);
                    }
                }
            } else {
                layer.getParent().addLayerContentStep(layer);
                burro = this.display.getProject().getLoader().importImage(layer, (double)point.x, (double)point.y, path, false);
            }
            if (null != burro) {
                burro.addPostTask(new Runnable(){

                    @Override
                    public void run() {
                        layer.getParent().addLayerContentStep(layer);
                    }
                });
            }
            return true;
        }
        Utils.log("File not found: " + path);
        return false;
    }
}

