/*
 * Decompiled with CFR 0.152.
 */
package video2;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Polygon;

public class Draw_Roi
implements PlugInFilter {
    private ImagePlus image;
    public static final int DEF_PIX_PER_SLICE = 3;

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 16;
    }

    public void run(ImageProcessor ip) {
        int current = this.image.getCurrentSlice();
        GenericDialog gd = new GenericDialog("Draw Roi");
        gd.addNumericField("Slice", (double)current, 0);
        gd.addNumericField("Pixels per slice", 3.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int slice = (int)gd.getNextNumber();
        int speed = (int)gd.getNextNumber();
        Draw_Roi.drawRois(this.image, this.image.getRoi(), slice, speed);
    }

    public static void drawRois(ImagePlus image, Roi roi, int slice, int speed) {
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi[] rois = null;
        rois = roi.getType() == 9 ? ((ShapeRoi)roi).getRois() : new Roi[]{roi};
        int c = 0;
        for (int i = 0; i < rois.length; ++i) {
            c += Draw_Roi.drawRoi(image, rois[i], slice, speed);
        }
    }

    public static int drawRoi(ImagePlus image, Roi roi, int slice, int speed) {
        if (roi == null) {
            return 0;
        }
        Polygon p = null;
        switch (roi.getType()) {
            case 5: {
                Line l = (Line)roi;
                p = new Polygon();
                p.addPoint(l.x1, l.y1);
                p.addPoint(l.x2, l.y2);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                p = roi.getPolygon();
                p.addPoint(p.xpoints[0], p.ypoints[0]);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                p = roi.getPolygon();
                break;
            }
            default: {
                throw new IllegalArgumentException("Roi type not supported");
            }
        }
        return Draw_Roi.drawRoi(image, p, slice, speed);
    }

    public static int drawRoi(ImagePlus image, Polygon p, int slice, int speed) {
        ImageStack stack = image.getStack();
        int linewidth = Line.getWidth();
        int color = Toolbar.getForegroundColor().getRGB();
        int n = p.npoints;
        int[] x = p.xpoints;
        int[] y = p.ypoints;
        int x_last = x[0];
        int y_last = y[0];
        ImageProcessor ip = stack.getProcessor(slice);
        LineIterator li = new LineIterator();
        int c = -1;
        int slicesInserted = 0;
        for (int z = 0; z < n - 1; ++z) {
            li.init(x[z], y[z], x[z + 1], y[z + 1]);
            while (li.next() != null) {
                ++c;
                ip.setValue((double)color);
                ip.setLineWidth(linewidth);
                ip.moveTo(x_last, y_last);
                x_last = (int)li.x;
                y_last = (int)li.y;
                ip.lineTo(x_last, y_last);
                if (speed < 1 || c % speed != 0) continue;
                stack.addSlice("", ip, slice + slicesInserted);
                ++slicesInserted;
            }
        }
        if (speed < 1 || c % speed != 0) {
            stack.addSlice("", ip, slice + slicesInserted);
            ++slicesInserted;
        }
        return slicesInserted;
    }

    private static class LineIterator {
        int x1;
        int y1;
        int x2;
        int y2;
        int dx;
        int dy;
        boolean finished;
        double x;
        double y;
        double dx_dt;
        double dy_dt;

        public LineIterator() {
        }

        public LineIterator(int x1, int y1, int x2, int y2) {
            this.init(x1, y1, x2, y2);
        }

        public void init(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.x = x1;
            this.y = y1;
            this.dx = x2 - x1;
            this.dy = y2 - y1;
            int dt = Math.abs(this.dx) > Math.abs(this.dy) ? this.dx : this.dy;
            if ((dt = Math.abs(dt)) == 0) {
                dt = 1;
            }
            this.dx_dt = (double)this.dx / (double)dt;
            this.dy_dt = (double)this.dy / (double)dt;
            this.dx = Math.abs(this.dx);
            this.dy = Math.abs(this.dy);
            this.finished = false;
        }

        public LineIterator next() {
            if (this.finished) {
                return null;
            }
            this.x += this.dx_dt;
            this.y += this.dy_dt;
            boolean bl = this.finished = Math.abs((int)this.x - this.x1) >= this.dx && Math.abs((int)this.y - this.y1) >= this.dy;
            if (this.finished) {
                this.x = this.x2;
                this.y = this.y2;
            }
            return this;
        }
    }
}

