/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.volatiles.AbstractVolatileRealType;

public class ClampingNLinearInterpolatorVolatileRealType<R extends RealType<R>, T extends AbstractVolatileRealType<R, T>>
extends NLinearInterpolator<T> {
    protected double acc;
    protected boolean valid;
    protected final double clampMin;
    protected final double clampMax;

    protected ClampingNLinearInterpolatorVolatileRealType(ClampingNLinearInterpolatorVolatileRealType<R, T> interpolator) {
        super(interpolator);
        this.clampMin = interpolator.clampMin;
        this.clampMax = interpolator.clampMax;
    }

    protected ClampingNLinearInterpolatorVolatileRealType(RandomAccessible<T> randomAccessible, T type) {
        super(randomAccessible, type);
        this.clampMin = ((AbstractVolatileRealType)type).getMinValue();
        this.clampMax = ((AbstractVolatileRealType)type).getMaxValue();
    }

    protected ClampingNLinearInterpolatorVolatileRealType(RandomAccessible<T> randomAccessible) {
        this(randomAccessible, (AbstractVolatileRealType)randomAccessible.randomAccess().get());
    }

    @Override
    public T get() {
        this.fillWeights();
        AbstractVolatileRealType t = (AbstractVolatileRealType)((RandomAccess)this.target).get();
        this.acc = t.getRealDouble() * this.weights[0];
        this.valid = t.isValid();
        this.code = 0;
        this.graycodeFwdRecursive(this.n - 1);
        ((RandomAccess)this.target).bck(this.n - 1);
        ((AbstractVolatileRealType)this.accumulator).setReal(Math.max(this.clampMin, Math.min(this.clampMax, this.acc)));
        ((AbstractVolatileRealType)this.accumulator).setValid(this.valid);
        return (T)((AbstractVolatileRealType)this.accumulator);
    }

    @Override
    public ClampingNLinearInterpolatorVolatileRealType<R, T> copy() {
        return new ClampingNLinearInterpolatorVolatileRealType<R, T>(this);
    }

    private final void graycodeFwdRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).fwd(0);
            ++this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).fwd(dimension);
            this.code += 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void graycodeBckRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).bck(0);
            --this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).bck(dimension);
            this.code -= 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void accumulate() {
        AbstractVolatileRealType t = (AbstractVolatileRealType)((RandomAccess)this.target).get();
        this.acc += t.getRealDouble() * this.weights[this.code];
        this.valid &= t.isValid();
    }
}

