/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.util.Util;

public abstract class AbstractIntegerType<T extends AbstractIntegerType<T>>
extends AbstractRealType<T>
implements IntegerType<T> {
    @Override
    public double getMinIncrement() {
        return 1.0;
    }

    @Override
    public float getRealFloat() {
        return this.getIntegerLong();
    }

    @Override
    public double getRealDouble() {
        return this.getIntegerLong();
    }

    @Override
    public void setReal(float real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setReal(double real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void inc() {
        this.setInteger(this.getIntegerLong() + 1L);
    }

    @Override
    public void dec() {
        this.setInteger(this.getIntegerLong() - 1L);
    }

    @Override
    public void setZero() {
        this.setInteger(0);
    }

    @Override
    public void setOne() {
        this.setInteger(1);
    }

    @Override
    public String toString() {
        return Long.toString(this.getIntegerLong());
    }

    @Override
    public int compareTo(T other) {
        return Long.compare(this.getIntegerLong(), other.getIntegerLong());
    }

    @Override
    public boolean valueEquals(T other) {
        return this.getIntegerLong() == this.getIntegerLong();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        AbstractIntegerType t = (AbstractIntegerType)obj;
        return this.valueEquals((T)t);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.getIntegerLong());
    }
}

