/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm;

import java.util.Arrays;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;

public abstract class ROIAlgorithm<T extends RealType<T>, S extends RealType<S>>
implements OutputAlgorithm<S>,
Benchmark {
    private final RegionOfInterestCursor<T> roiCursor;
    private final int[] patchSize;
    private final int[] originOffset;
    private final Image<T> inputImage;
    private final OutOfBoundsStrategyFactory<T> outsideFactory;
    private Image<S> outputImage;
    private ImageFactory<S> imageFactory;
    private String errorMsg;
    private String name;
    private final S typeS;
    private long pTime;

    protected ROIAlgorithm(S type, Image<T> imageIn, int[] patchSize) {
        this(type, imageIn, patchSize, null);
    }

    protected ROIAlgorithm(S type, Image<T> imageIn, int[] patchSize, OutOfBoundsStrategyFactory<T> inOutFactory) {
        int nd = imageIn.getNumDimensions();
        int[] initPos = new int[nd];
        this.pTime = 0L;
        this.originOffset = new int[nd];
        this.inputImage = imageIn;
        this.patchSize = (int[])patchSize.clone();
        this.outputImage = null;
        this.imageFactory = null;
        this.errorMsg = "";
        this.name = null;
        this.typeS = (RealType)type.copy();
        Arrays.fill(initPos, 0);
        if (inOutFactory == null) {
            RealType typeT = (RealType)imageIn.createType();
            typeT.setZero();
            this.outsideFactory = new OutOfBoundsStrategyValueFactory<RealType>(typeT);
        } else {
            this.outsideFactory = inOutFactory;
        }
        this.roiCursor = imageIn.createLocalizableByDimCursor(this.outsideFactory).createRegionOfInterestCursor(initPos, patchSize);
        for (int i = 0; i < nd; ++i) {
            this.originOffset[i] = patchSize[i] / 2;
        }
    }

    protected abstract boolean patchOperation(int[] var1, RegionOfInterestCursor<T> var2);

    public void setImageFactory(ImageFactory<S> factory) {
        this.imageFactory = factory;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getName() {
        return this.name;
    }

    public int[] getPatchSize() {
        return (int[])this.patchSize.clone();
    }

    protected Image<S> getOutputImage() {
        if (this.outputImage == null) {
            if (this.imageFactory == null) {
                this.imageFactory = new ImageFactory<S>(this.typeS, this.inputImage.getContainerFactory());
            }
            this.outputImage = this.name == null ? this.imageFactory.createImage(this.inputImage.getDimensions()) : this.imageFactory.createImage(this.inputImage.getDimensions(), this.name);
        }
        return this.outputImage;
    }

    @Override
    public Image<S> getResult() {
        return this.outputImage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    protected void setErrorMessage(String message) {
        this.errorMsg = message;
    }

    protected int[] positionOffset(int[] position, int[] offsetPosition) {
        if (offsetPosition.length < position.length) {
            throw new RuntimeException("Cannot copy " + position.length + " values into array of length " + offsetPosition.length);
        }
        if (position.length < this.originOffset.length) {
            throw new RuntimeException("Position vector has less cardinality than the input image's dimensionality.");
        }
        for (int i = 0; i < position.length; ++i) {
            offsetPosition[i] = position[i] - this.originOffset[i];
        }
        return offsetPosition;
    }

    @Override
    public boolean process() {
        LocalizableCursor<S> outputCursor = this.getOutputImage().createLocalizableCursor();
        int[] pos = new int[this.inputImage.getNumDimensions()];
        int[] offsetPos = new int[this.inputImage.getNumDimensions()];
        long sTime = System.currentTimeMillis();
        while (outputCursor.hasNext()) {
            outputCursor.fwd();
            outputCursor.getPosition(pos);
            this.roiCursor.reset(this.positionOffset(pos, offsetPos));
            if (this.patchOperation(pos, this.roiCursor)) continue;
            outputCursor.close();
            return false;
        }
        outputCursor.close();
        this.pTime = System.currentTimeMillis() - sTime;
        return true;
    }

    @Override
    public boolean checkInput() {
        return this.roiCursor.isActive();
    }

    public void close() {
        this.roiCursor.close();
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

