/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.floydsteinberg;

import java.util.Random;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

public class FloydSteinbergDithering<T extends RealType<T>>
implements OutputAlgorithm<BitType>,
Benchmark {
    Image<BitType> result;
    final Image<T> img;
    final Image<FloatType> errorDiffusionKernel;
    final int[] dim;
    final int[] tmp1;
    final int[] tmp2;
    final int numDimensions;
    final float ditheringThreshold;
    final float minValue;
    final float maxValue;
    long processingTime;
    String errorMessage = "";

    public FloydSteinbergDithering(Image<T> img, float ditheringThreshold) {
        this.img = img.clone();
        this.dim = img.getDimensions();
        this.tmp1 = img.createPositionArray();
        this.tmp2 = img.createPositionArray();
        this.errorDiffusionKernel = this.createErrorDiffusionKernel(img.getNumDimensions());
        this.ditheringThreshold = ditheringThreshold;
        img.getDisplay().setMinMax();
        this.minValue = (float)img.getDisplay().getMin();
        this.maxValue = (float)img.getDisplay().getMax();
        this.numDimensions = img.getNumDimensions();
    }

    public FloydSteinbergDithering(Image<T> img) {
        this(img, FloydSteinbergDithering.getThreshold(img));
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        ImageFactory<BitType> imgFactory = new ImageFactory<BitType>(new BitType(), this.img.getContainerFactory());
        this.result = imgFactory.createImage(this.dim);
        ArrayLocalizableCursor<FakeType> cursor = ArrayLocalizableCursor.createLinearCursor(this.dim);
        LocalizableByDimCursor<T> cursorInput = this.img.createLocalizableByDimCursor(new OutOfBoundsStrategyValueFactory());
        LocalizableByDimCursor<BitType> cursorOutput = this.result.createLocalizableByDimCursor();
        LocalizableCursor<FloatType> cursorKernel = this.errorDiffusionKernel.createLocalizableCursor();
        while (cursor.hasNext()) {
            float error;
            cursor.fwd();
            cursorInput.moveTo(cursor);
            cursorOutput.moveTo(cursor);
            float in = ((RealType)cursorInput.getType()).getRealFloat();
            if (in < this.ditheringThreshold) {
                ((BitType)cursorOutput.getType()).setZero();
                error = in - this.minValue;
            } else {
                ((BitType)cursorOutput.getType()).setOne();
                error = in - this.maxValue;
            }
            if (error == 0.0f) continue;
            cursorKernel.reset();
            cursorKernel.fwd(this.errorDiffusionKernel.getNumPixels() / 2);
            cursor.getPosition(this.tmp1);
            while (cursorKernel.hasNext()) {
                cursorKernel.fwd();
                float value = error * ((FloatType)cursorKernel.getType()).get();
                cursorKernel.getPosition(this.tmp2);
                for (int d = 0; d < this.numDimensions; ++d) {
                    int n = d;
                    this.tmp2[n] = this.tmp2[n] + (this.tmp1[d] - 1);
                }
                cursorInput.moveTo(this.tmp2);
                ((RealType)cursorInput.getType()).setReal(((RealType)cursorInput.getType()).getRealFloat() + value);
            }
        }
        cursor.close();
        cursorInput.close();
        cursorOutput.close();
        cursorKernel.close();
        this.img.close();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Image<BitType> getResult() {
        return this.result;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    public static <T extends RealType<T>> float getThreshold(Image<T> img) {
        img.getDisplay().setMinMax();
        return (float)(img.getDisplay().getMax() - img.getDisplay().getMin()) / 2.0f;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Image<FloatType> createErrorDiffusionKernel(int numDimensions) {
        int i;
        ImageFactory<FloatType> factory = new ImageFactory<FloatType>(new FloatType(), new ArrayContainerFactory());
        if (numDimensions == 2) {
            Image<FloatType> kernel = factory.createImage(new int[]{3, 3});
            LocalizableByDimCursor<FloatType> cursor = kernel.createLocalizableByDimCursor();
            cursor.setPosition(2, 0);
            cursor.setPosition(1, 1);
            ((FloatType)cursor.getType()).setReal(0.4375f);
            cursor.move(1, 1);
            ((FloatType)cursor.getType()).setReal(0.0625f);
            cursor.move(-1, 0);
            ((FloatType)cursor.getType()).setReal(0.3125f);
            cursor.move(-1, 0);
            ((FloatType)cursor.getType()).setReal(0.1875f);
            cursor.close();
            return kernel;
        }
        Image<FloatType> kernel = factory.createImage(Util.getArrayFromValue(3, numDimensions));
        LocalizableCursor<FloatType> cursor = kernel.createLocalizableCursor();
        int numValues = kernel.getNumPixels() / 2;
        float[] rndValues = new float[numValues];
        float sum = 0.0f;
        Random rnd = new Random(435345L);
        for (i = 0; i < numValues; ++i) {
            rndValues[i] = rnd.nextFloat();
            sum += rndValues[i];
        }
        i = 0;
        while (i < numValues) {
            int n = i++;
            rndValues[n] = rndValues[n] / sum;
        }
        int count = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            if (count > numValues) {
                ((FloatType)cursor.getType()).setReal(rndValues[count - numValues - 1]);
            }
            ++count;
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            for (int d = 0; d < numDimensions; ++d) {
                cursor.reset();
                float sumD = 0.0f;
                while (cursor.hasNext()) {
                    cursor.fwd();
                    if (cursor.getPosition(d) == 1) continue;
                    sumD += ((FloatType)cursor.getType()).get();
                }
                cursor.reset();
                while (cursor.hasNext()) {
                    cursor.fwd();
                    if (cursor.getPosition(d) == 1) continue;
                    ((FloatType)cursor.getType()).set(((FloatType)cursor.getType()).get() / sumD);
                }
            }
        }
        cursor.close();
        sum = 0.0f;
        cursor.reset();
        while (cursor.hasNext()) {
            cursor.fwd();
            sum += ((FloatType)cursor.getType()).get();
        }
        cursor.reset();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((FloatType)cursor.getType()).set(((FloatType)cursor.getType()).get() / sum);
        }
        return kernel;
    }
}

