/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

public class CellLocalizablePlaneCursor<T extends Type<T>>
extends CellLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    final ArrayLocalizableByDimCursor<FakeType> cursor;
    protected int maxCellsPlane;
    protected int currentCellsPlane;
    protected int planeDimA;
    protected int planeDimB;
    protected int planeSizeA;
    protected int planeSizeB;
    protected int incPlaneA;
    protected int incPlaneB;
    protected final int[] step;
    protected final int[] cellPosition;
    protected final int[] tmp;
    protected final int[] cellEnd;
    protected final int[] numCellsDim;
    protected final int[] cellStep;

    public CellLocalizablePlaneCursor(CellContainer<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.step = new int[this.numDimensions];
        this.cellPosition = new int[this.numDimensions];
        this.cellEnd = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
        this.numCellsDim = container.getNumCellsDim();
        this.cellStep = new int[this.numDimensions];
        this.cursor = ArrayLocalizableByDimCursor.createLinearByDimCursor(this.numCellsDim);
        this.cursor.setPosition(new int[container.getNumDimensions()]);
        Array.createAllocationSteps(this.numCellsDim, this.cellStep);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.currentCellsPlane < this.maxCellsPlane - 1) {
            return true;
        }
        return this.type.getIndex() < this.cellMaxI;
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI) {
            if (this.type.getIndex() == -1 || this.position[this.planeDimA] < this.cellEnd[this.planeDimA] - 1) {
                int n = this.planeDimA;
                this.position[n] = this.position[n] + 1;
                this.type.incIndex(this.incPlaneA);
            } else {
                this.position[this.planeDimA] = this.cellOffset[this.planeDimA];
                int n = this.planeDimB;
                this.position[n] = this.position[n] + 1;
                this.type.incIndex(this.incPlaneB);
                this.type.decIndex((this.planeSizeA - 1) * this.incPlaneA);
            }
        } else if (this.currentCellsPlane < this.maxCellsPlane - 1) {
            ++this.currentCellsPlane;
            if (this.cellPosition[this.planeDimA] < this.numCellsDim[this.planeDimA] - 1) {
                int n = this.planeDimA;
                this.cellPosition[n] = this.cellPosition[n] + 1;
            } else if (this.cellPosition[this.planeDimB] < this.numCellsDim[this.planeDimB] - 1) {
                this.cellPosition[this.planeDimA] = 0;
                int n = this.planeDimB;
                this.cellPosition[n] = this.cellPosition[n] + 1;
            }
            this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
            this.getCellData(this.cell);
            this.position[this.planeDimA] = this.cellOffset[this.planeDimA];
            if (this.planeDimB < this.numDimensions) {
                this.position[this.planeDimB] = this.cellOffset[this.planeDimB];
            }
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        }
    }

    @Override
    protected void getCellData(int cell) {
        int d;
        if (cell == this.lastCell) {
            return;
        }
        this.lastCell = cell;
        this.cellInstance = this.container.getCell(cell);
        this.cellInstance.getDimensions(this.cellDimensions);
        this.cellInstance.getOffset(this.cellOffset);
        this.planeSizeA = this.cellDimensions[this.planeDimA];
        if (this.planeDimB < this.numDimensions) {
            this.planeSizeB = this.cellDimensions[this.planeDimB];
        } else {
            this.planeDimB = 1;
        }
        for (d = 0; d < this.numDimensions; ++d) {
            this.cellEnd[d] = this.cellOffset[d] + this.cellDimensions[d];
        }
        this.cellInstance.getSteps(this.step);
        for (d = 0; d < this.numDimensions; ++d) {
            this.tmp[d] = this.position[d];
        }
        this.incPlaneA = this.step[this.planeDimA];
        this.tmp[this.planeDimA] = this.cellEnd[this.planeDimA] - 1;
        if (this.planeDimB > -1 && this.planeDimB < this.step.length) {
            this.tmp[this.planeDimB] = this.cellEnd[this.planeDimB] - 1;
            this.incPlaneB = this.step[this.planeDimB];
        } else {
            this.incPlaneB = 0;
        }
        this.cellMaxI = this.cellInstance.getPosGlobal(this.tmp);
        this.type.updateContainer(this);
    }

    @Override
    public void reset(int planeDimA, int planeDimB, int[] dimensionPositions) {
        this.lastCell = -1;
        this.planeDimA = planeDimA;
        this.planeDimB = planeDimB;
        this.maxCellsPlane = this.container.getNumCells(planeDimA) * this.container.getNumCells(planeDimB);
        this.currentCellsPlane = 0;
        int[] dimPos = (int[])dimensionPositions.clone();
        dimPos[planeDimA] = 0;
        if (planeDimB > -1 && planeDimB < this.step.length) {
            dimPos[planeDimB] = 0;
        }
        this.setPosition(dimPos);
        this.isClosed = false;
        this.position[planeDimA] = -1;
        this.type.decIndex(this.incPlaneA);
    }

    @Override
    public void reset(int planeDimA, int planeDimB) {
        this.reset(planeDimA, planeDimB, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.step == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    protected void setPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
        this.container.getCellPosition(position, this.cellPosition);
        this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
        this.getCellData(this.cell);
        this.type.updateIndex(this.cellInstance.getPosGlobal(position));
    }

    @Override
    public void close() {
        this.cursor.close();
        if (!this.isClosed) {
            this.lastCell = -1;
            this.isClosed = true;
        }
    }
}

