/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image;

import mpicbg.imglib.Factory;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ImageFactory<T extends Type<T>>
implements Factory {
    final ContainerFactory containerFactory;
    final T type;
    String errorMessage = "No errors.";

    public ImageFactory(T type, ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        this.type = type;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public T createType() {
        return this.type.createVariable();
    }

    public Image<T> createImage(int[] dim, String name) {
        return new Image(this, dim, name);
    }

    public Image<T> createImage(int[] dim) {
        return this.createImage(dim, null);
    }

    @Override
    public void printProperties() {
        System.out.println(this.getClass().getCanonicalName() + ": ");
        System.out.println("Use optimized containers if possible: " + this.containerFactory.useOptimizedContainers());
        this.containerFactory.printProperties();
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setParameters(String configuration) {
    }

    public void setOptimizedContainerUse(boolean useOptimizedContainers) {
        this.containerFactory.setOptimizedContainerUse(useOptimizedContainers);
    }

    public boolean useOptimizedContainers() {
        return this.containerFactory.useOptimizedContainers();
    }
}

