/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.RealType;

public class RealTypeDisplay<T extends RealType<T>>
extends Display<T> {
    public RealTypeDisplay(Image<T> img) {
        super(img);
        RealType type = (RealType)img.createType();
        this.min = type.getMinValue();
        this.max = type.getMaxValue();
    }

    @Override
    public void setMinMax() {
        Cursor c = this.img.createCursor();
        if (!c.hasNext()) {
            RealType type = (RealType)this.img.createType();
            this.min = type.getMinValue();
            this.max = type.getMaxValue();
            return;
        }
        c.fwd();
        this.min = this.max = ((RealType)c.getType()).getRealDouble();
        while (c.hasNext()) {
            c.fwd();
            double value = ((RealType)c.getType()).getRealDouble();
            if (value > this.max) {
                this.max = value;
                continue;
            }
            if (!(value < this.min)) continue;
            this.min = value;
        }
        c.close();
    }

    @Override
    public float get32Bit(T c) {
        return c.getRealFloat();
    }

    @Override
    public float get32BitNormed(T c) {
        return this.normFloat(c.getRealFloat());
    }

    @Override
    public byte get8BitSigned(T c) {
        return (byte)Math.round(this.normFloat(c.getRealFloat()) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(T c) {
        return (short)Math.round(this.normFloat(c.getRealFloat()) * 255.0f);
    }
}

