/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.algorithm.Affine3D;
import script.imglib.algorithm.fn.AbstractAffine3D;
import script.imglib.color.Alpha;
import script.imglib.color.Blue;
import script.imglib.color.Green;
import script.imglib.color.RGBA;
import script.imglib.color.Red;
import script.imglib.math.Compute;

public class Resample<N extends NumericType<N>>
extends Image<N> {
    public static final AbstractAffine3D.Mode LINEAR = Affine3D.LINEAR;
    public static final AbstractAffine3D.Mode NEAREST_NEIGHBOR = Affine3D.NEAREST_NEIGHBOR;
    public static final AbstractAffine3D.Mode BEST = Affine3D.BEST;

    public Resample(Image<N> img, Number scale) throws Exception {
        this(img, Resample.asDimArray(img, scale), BEST);
    }

    public Resample(Image<N> img, Number scale, AbstractAffine3D.Mode mode) throws Exception {
        this(img, Resample.asDimArray(img, scale), mode);
    }

    public Resample(Image<N> img, int[] dimensions) throws Exception {
        this(img, dimensions, BEST);
    }

    public Resample(Image<N> img, int[] dimensions, AbstractAffine3D.Mode mode) throws Exception {
        super(Resample.process(img, dimensions, mode).getContainer(), img.createType());
    }

    private static final int[] asDimArray(Image<?> img, Number scale) {
        int[] dim = new int[img.getNumDimensions()];
        double s = scale.doubleValue();
        for (int i = 0; i < dim.length; ++i) {
            dim[i] = (int)((double)img.getDimension(i) * s + 0.5);
        }
        return dim;
    }

    private static final <N extends NumericType<N>> Image<N> process(Image<N> img, int[] dim, AbstractAffine3D.Mode mode) throws Exception {
        N type;
        if (dim.length != img.getNumDimensions()) {
            int i;
            int[] d = new int[img.getNumDimensions()];
            for (i = 0; i < dim.length; ++i) {
                d[i] = dim[i];
            }
            while (i < img.getNumDimensions()) {
                d[i] = img.getDimension(i);
                ++i;
            }
            dim = d;
        }
        if (RGBALegacyType.class.isAssignableFrom((type = img.createType()).getClass())) {
            return Resample.processRGBA(img, dim, mode);
        }
        if (type instanceof RealType) {
            return Resample.processReal(img, dim, mode);
        }
        throw new Exception("Affine transform: cannot handle type " + type.getClass());
    }

    private static final Image<RGBALegacyType> processRGBA(Image<RGBALegacyType> img, int[] dim, AbstractAffine3D.Mode mode) throws Exception {
        return new RGBA(Resample.processReal(Compute.inFloats(new Red(img)), dim, mode), Resample.processReal(Compute.inFloats(new Green(img)), dim, mode), Resample.processReal(Compute.inFloats(new Blue(img)), dim, mode), Resample.processReal(Compute.inFloats(new Alpha(img)), dim, mode)).asImage();
    }

    private static final <T extends RealType<T>> Image<T> processReal(Image<T> img, int[] dim, AbstractAffine3D.Mode mode) throws Exception {
        InterpolatorFactory ifac;
        Image<T> res = img.getImageFactory().createImage(dim);
        switch (mode) {
            case LINEAR: {
                ifac = new LinearInterpolatorFactory(new OutOfBoundsStrategyMirrorFactory());
                break;
            }
            case NEAREST_NEIGHBOR: {
                ifac = new NearestNeighborInterpolatorFactory(new OutOfBoundsStrategyMirrorFactory());
                break;
            }
            default: {
                throw new Exception("Resample: unknown mode!");
            }
        }
        Interpolator<T> inter = ifac.createInterpolator(img);
        LocalizableCursor<T> c2 = res.createLocalizableCursor();
        float[] s = new float[dim.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (float)img.getDimension(i) / (float)dim[i];
        }
        int[] d = new int[dim.length];
        float[] p = new float[dim.length];
        while (c2.hasNext()) {
            c2.fwd();
            c2.getPosition(d);
            for (int i = 0; i < d.length; ++i) {
                p[i] = (float)d[i] * s[i];
            }
            inter.moveTo(p);
            ((RealType)c2.getType()).set(inter.getType());
        }
        return res;
    }
}

