/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class KaiserWindow {
    private double _error;
    private double _width;
    private double _length;
    private double _alpha;
    private double _scale;
    private double _xxmax;

    public static KaiserWindow fromErrorAndWidth(double error, double width) {
        Check.argument(error > 0.0, "error>0.0");
        Check.argument(error < 1.0, "error<1.0");
        Check.argument(width > 0.0, "width>0.0");
        double a = -20.0 * MathPlus.log10(error);
        double d = a > 21.0 ? (a - 7.95) / 14.36 : 0.9222;
        double length = d / width;
        return new KaiserWindow(error, width, length);
    }

    public static KaiserWindow fromErrorAndLength(double error, double length) {
        Check.argument(error > 0.0, "error>0.0");
        Check.argument(error < 1.0, "error<1.0");
        Check.argument(length > 0.0, "length>0");
        double a = -20.0 * MathPlus.log10(error);
        double d = a > 21.0 ? (a - 7.95) / 14.36 : 0.9222;
        double width = d / length;
        return new KaiserWindow(error, width, length);
    }

    public static KaiserWindow fromWidthAndLength(double width, double length) {
        Check.argument(width > 0.0, "width>0.0");
        Check.argument(length > 0.0, "length>0");
        Check.argument(width * length >= 1.0, "width*length>=1.0");
        double d = width * length;
        double a = 14.36 * d + 7.95;
        double error = MathPlus.pow(10.0, -a / 20.0);
        return new KaiserWindow(error, width, length);
    }

    public double evaluate(double x) {
        double xx = x * x;
        return xx <= this._xxmax ? this._scale * this.ino(this._alpha * MathPlus.sqrt(1.0 - xx / this._xxmax)) : 0.0;
    }

    public double getError() {
        return this._error;
    }

    public double getLength() {
        return this._length;
    }

    public double getWidth() {
        return this._width;
    }

    private KaiserWindow(double error, double width, double length) {
        this._error = error;
        this._width = width;
        this._length = length;
        double a = -20.0 * MathPlus.log10(this._error);
        this._alpha = a <= 21.0 ? 0.0 : (a <= 50.0 ? 0.5842 * MathPlus.pow(a - 21.0, 0.4) + 0.07886 * (a - 21.0) : 0.1102 * (a - 8.7));
        this._scale = 1.0 / this.ino(this._alpha);
        this._xxmax = 0.25 * this._length * this._length;
    }

    private double ino(double x) {
        double s = 1.0;
        double ds = 1.0;
        double d = 0.0;
        while ((ds *= x * x / ((d += 2.0) * d)) > (s += ds) * 2.220446049250313E-16) {
        }
        return s;
    }
}

