/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.util.Check;
import java.util.ArrayList;
import java.util.Iterator;

public class LasserreVolume {
    private int _m = 0;
    private int _n;
    private AbList _ab;
    private ArrayList<AbList> _abStack;

    public LasserreVolume(int n) {
        this._n = n;
        this._abStack = new ArrayList(this._n);
        for (int i = 1; i <= n; ++i) {
            this._ab = new AbList(i);
            this._abStack.add(this._ab);
        }
    }

    public void addHalfSpace(double a1, double b) {
        Check.state(this._n >= 1, "dimension >= 1");
        double[] ab = this._ab.add();
        for (int i = 1; i < this._n; ++i) {
            ab[i] = 0.0;
        }
        ab[0] = a1;
        ab[this._n] = b;
        ++this._m;
    }

    public void addHalfSpace(double a1, double a2, double b) {
        Check.state(this._n >= 2, "dimension >= 2");
        double[] ab = this._ab.add();
        for (int i = 2; i < this._n; ++i) {
            ab[i] = 0.0;
        }
        ab[0] = a1;
        ab[1] = a2;
        ab[this._n] = b;
        ++this._m;
    }

    public void addHalfSpace(double a1, double a2, double a3, double b) {
        Check.state(this._n >= 3, "dimension >= 3");
        double[] ab = this._ab.add();
        for (int i = 3; i < this._n; ++i) {
            ab[i] = 0.0;
        }
        ab[0] = a1;
        ab[1] = a2;
        ab[2] = a3;
        ab[this._n] = b;
        ++this._m;
    }

    public void addHalfSpace(double[] a, double b) {
        int i;
        int n = a.length;
        if (n > this._n) {
            n = this._n;
        }
        double[] ab = this._ab.add();
        for (i = n; i < this._n; ++i) {
            ab[i] = 0.0;
        }
        for (i = 0; i < n; ++i) {
            ab[i] = a[i];
        }
        ab[this._n] = b;
        ++this._m;
    }

    public void clear() {
        this._ab.clear();
        this._m = 0;
    }

    public double getVolume() {
        return this.volume(this._m, this._n);
    }

    private double volume(int m, int n) {
        if (m <= n) {
            return Double.POSITIVE_INFINITY;
        }
        AbList abList = this._abStack.get(n - 1);
        if (n == 1) {
            double xlower = Double.NEGATIVE_INFINITY;
            double xupper = Double.POSITIVE_INFINITY;
            for (int irow = 0; irow < m; ++irow) {
                double x;
                double[] arow = (double[])abList.get(irow);
                double aval = arow[0];
                double bval = arow[1];
                if (aval < 0.0) {
                    x = bval / aval;
                    if (!(x > xlower)) continue;
                    xlower = x;
                    continue;
                }
                if (!(aval > 0.0) || !((x = bval / aval) < xupper)) continue;
                xupper = x;
            }
            double len = xupper - xlower;
            if (len < 0.0) {
                len = 0.0;
            }
            return len;
        }
        double sum = 0.0;
        for (int irow = 0; irow < m; ++irow) {
            double[] arow = (double[])abList.get(irow);
            double brow = arow[n];
            if (brow == 0.0) continue;
            int jpiv = 0;
            double amax = 0.0;
            for (int j = 0; j < n; ++j) {
                double a = arow[j];
                if (a < 0.0) {
                    a = -a;
                }
                if (!(a > amax)) continue;
                jpiv = j;
                amax = a;
            }
            if (amax == 0.0) continue;
            AbList abNext = this._abStack.get(n - 2);
            abNext.clear();
            double spiv = 1.0 / arow[jpiv];
            for (int i = 0; i < m; ++i) {
                if (i == irow) continue;
                double[] ai = (double[])abList.get(i);
                double[] ak = abNext.add();
                int l = 0;
                for (int j = 0; j <= n; ++j) {
                    if (j == jpiv) continue;
                    ak[l++] = ai[j] - spiv * ai[jpiv] * arow[j];
                }
            }
            double vol = this.volume(m - 1, n - 1);
            if (vol == Double.POSITIVE_INFINITY) {
                return vol;
            }
            sum += brow / amax * vol;
        }
        return sum / (double)n;
    }

    private static class AbList
    extends ArrayList<double[]> {
        private int _m = 0;
        private int _n;

        AbList(int n) {
            super(n + 1);
            this._n = n;
        }

        public double[] add() {
            if (this._m == this.size()) {
                this.add(new double[this._n + 1]);
            }
            ++this._m;
            return (double[])this.get(this._m - 1);
        }

        @Override
        public void clear() {
            this._m = 0;
        }

        void dump() {
            System.out.println("m=" + this._m + " n=" + this._n);
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                double[] ab;
                for (double abi : ab = (double[])i$.next()) {
                    System.out.print(abi + " ");
                }
                System.out.println();
            }
        }
    }
}

