/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.bead;

import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.BeadIdentification;
import mpicbg.spim.registration.detection.DetectionView;
import net.imglib2.util.Util;
import spim.vecmath.Point3d;

public class Bead
extends DetectionView<BeadIdentification, Bead> {
    public boolean relocalized = false;
    private static final long serialVersionUID = -2875282502611466531L;

    public Bead(int id, Point3d location, ViewDataBeads myView) {
        super(id, new double[]{location.x, location.y, location.z}, myView);
    }

    public Bead(int id, double[] location, ViewDataBeads myView) {
        super(id, location, myView);
    }

    @Override
    public String toString() {
        String desc = "Bead " + this.getID() + " l" + Util.printCoordinates((double[])this.getL()) + "; w" + Util.printCoordinates((double[])this.getW());
        if (this.myView != null) {
            return desc + " of view " + this.myView;
        }
        return desc + " - no view assigned";
    }

    public boolean equals(Bead bead) {
        return this.getID() == bead.getID() && this.getViewID() == bead.getViewID();
    }

    public boolean equals(BeadIdentification beadID) {
        return this.getID() == beadID.getDetectionID() && this.getViewID() == beadID.getViewID();
    }

    public Bead[] createArray(int n) {
        return new Bead[n];
    }

    @Override
    public BeadIdentification createIdentification() {
        return new BeadIdentification(this);
    }
}

