/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection;

import java.util.ArrayList;
import java.util.Collection;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.detection.AbstractDetection;
import mpicbg.spim.registration.detection.DetectionIdentification;

public abstract class DetectionView<S extends DetectionIdentification<S, T>, T extends DetectionView<S, T>>
extends AbstractDetection<T> {
    private static final long serialVersionUID = 1L;
    protected final ViewDataBeads myView;
    protected final ArrayList<S> descriptorCorrespondence = new ArrayList();
    protected final ArrayList<S> ransacCorrespondence = new ArrayList();
    protected final ArrayList<S> icpCorrespondence = new ArrayList();

    public DetectionView(int id, double[] location, ViewDataBeads myView) {
        super(id, location);
        this.myView = myView;
    }

    public abstract S createIdentification();

    public ViewDataBeads getView() {
        return this.myView;
    }

    public int getViewID() {
        return this.myView.getID();
    }

    public ArrayList<S> getDescriptorCorrespondence() {
        return this.descriptorCorrespondence;
    }

    public ArrayList<S> getRANSACCorrespondence() {
        return this.ransacCorrespondence;
    }

    public ArrayList<S> getICPCorrespondence() {
        return this.icpCorrespondence;
    }

    public synchronized void addPointDescriptorCorrespondence(T detection) {
        this.addPointDescriptorCorrespondence(detection, 1.0);
    }

    public synchronized void addPointDescriptorCorrespondence(T detection, double weight) {
        this.descriptorCorrespondence.add(((DetectionView)((Object)detection)).createIdentification());
    }

    public synchronized void addICPCorrespondence(T detection) {
        this.addICPCorrespondence(detection, 1.0);
    }

    public synchronized void addICPCorrespondence(T detection, double weight) {
        this.icpCorrespondence.add(((DetectionView)((Object)detection)).createIdentification());
    }

    public synchronized void addRANSACCorrespondence(T detection) {
        this.addRANSACCorrespondence(detection, 1.0);
    }

    public synchronized void addRANSACCorrespondence(T detection, double weight) {
        if (!DetectionView.containsDetectionID(this.descriptorCorrespondence, detection)) {
            IOFunctions.println("Error: Cannot set RANSAC correspondence for bead " + (Object)((Object)this) + "; it has no correspondence from a point descriptor.");
            return;
        }
        int sameViewIndex = -1;
        for (int i = 0; i < this.ransacCorrespondence.size(); ++i) {
            if (((DetectionIdentification)this.ransacCorrespondence.get(i)).getViewID() != ((DetectionView)((Object)detection)).getViewID()) continue;
            sameViewIndex = i;
        }
        if (sameViewIndex >= 0) {
            IOFunctions.println("Warning: RANSAC Correspondence for Detection " + (Object)((Object)this) + ", currently " + this.ransacCorrespondence.get(sameViewIndex) + " overwritten by " + detection);
            this.ransacCorrespondence.remove(sameViewIndex);
        }
        this.ransacCorrespondence.add(((DetectionView)((Object)detection)).createIdentification());
    }

    public static <S extends DetectionIdentification<S, T>, T extends DetectionView<S, T>> boolean containsDetectionID(Collection<S> list, T detection) {
        boolean contains = false;
        for (DetectionIdentification content : list) {
            if (content.getDetectionID() != detection.getID() || content.getViewID() != detection.getViewID()) continue;
            contains = true;
        }
        return contains;
    }

    public static <T extends DetectionView<?, T>> boolean containsDetection(Collection<T> list, T detection) {
        boolean contains = false;
        for (DetectionView content : list) {
            if (content.getID() != detection.getID() || content.getViewID() != detection.getViewID()) continue;
            contains = true;
        }
        return contains;
    }

    public boolean equals(DetectionView<?, ?> otherDetection) {
        return this.getID() == otherDetection.getID() && this.getViewID() == otherDetection.getViewID();
    }
}

