/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.deconvolution.ExtractPSF;
import spim.process.fusion.weightedavg.ProcessFusion;

public class Max_Project
implements PlugIn {
    public void run(String arg) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("image fusion", true, true, true, true)) {
            return;
        }
        Max_Project.maxProject((SpimData)result.getData(), SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess()), new UnsignedShortType());
    }

    public static <T extends RealType<T> & NativeType<T>> boolean maxProject(SpimData data, List<? extends ViewId> viewIds, T type) {
        ArrayList<ViewDescription> list = new ArrayList<ViewDescription>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (vd == null || !vd.isPresent()) continue;
            list.add(vd);
        }
        return Max_Project.maxProject(list, (ImgLoader)((SequenceDescription)data.getSequenceDescription()).getImgLoader(), type);
    }

    public static <T extends RealType<T> & NativeType<T>> boolean maxProject(List<? extends ViewDescription> vds, ImgLoader imgLoader, T type) {
        Collections.sort(vds);
        ArrayList<TimePoint> tps = SpimData2.getAllTimePointsSorted(vds);
        ArrayList<ViewSetup> setups = SpimData2.getAllViewSetups(vds);
        for (ViewSetup setup : setups) {
            ImageStack stack = null;
            for (TimePoint t : tps) {
                for (ViewDescription viewDescription : vds) {
                    if (viewDescription.getTimePointId() != t.getId() || viewDescription.getViewSetupId() != setup.getId()) continue;
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading image for timepoint " + t.getId() + " viewsetup " + viewDescription.getViewSetupId());
                    RandomAccessibleInterval<T> img = ProcessFusion.getImage(type, imgLoader, (ViewId)viewDescription, false);
                    FloatProcessor fp = Max_Project.toProcessor(ExtractPSF.computeMaxProjection(img, new ArrayImgFactory(), 2));
                    if (stack == null) {
                        stack = new ImageStack(fp.getWidth(), fp.getHeight());
                    }
                    stack.addSlice("Timepoint=" + t.getId(), (ImageProcessor)fp);
                }
            }
            ImagePlus imp = new ImagePlus("ViewSetupId=" + setup.getId(), stack);
            imp.setDimensions(1, 1, stack.getSize());
            imp.show();
        }
        return true;
    }

    public static FloatProcessor toProcessor(Img<? extends RealType<?>> img) {
        FloatProcessor fp = new FloatProcessor((int)img.dimension(0), (int)img.dimension(1));
        float[] array = (float[])fp.getPixels();
        Cursor c = img.cursor();
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((RealType)c.next()).getRealFloat();
        }
        return fp;
    }

    public static void main(String[] args) {
    }
}

