/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;

public class Grids {
    public static <P extends Positionable & Localizable> void forEachOffset(long[] min, long[] max, int[] blockSize, P p, Runnable runAtOffset) {
        assert (p.numDimensions() == min.length) : "Dimensionality mismatch!";
        Grids.forEachOffset(min, max, blockSize, (to, d) -> p.setPosition(to, d), d -> ((Localizable)((Object)p)).getLongPosition(d), (by, d) -> p.move(by, d), runAtOffset);
    }

    public static void forEachOffset(long[] min, long[] max, int[] blockSize, Consumer<long[]> runAtOffset) {
        long[] offset = new long[min.length];
        Grids.forEachOffset(min, max, blockSize, (to, d) -> {
            offset[d] = to;
        }, d -> offset[d], (by, d) -> {
            int n = d;
            offset[n] = offset[n] + by;
        }, () -> runAtOffset.accept(offset));
    }

    public static void forEachOffset(long[] min, long[] max, int[] blockSize, SetForDimension setOffsetForDimension, GetForDimension getOffsetForDimension, MoveForDimension moveForDimension, Runnable runAtEachOffset) {
        int d2;
        assert (Arrays.stream(blockSize).filter(b -> b < 1).count() == 0L) : "Only non-zero blockSize allowed!";
        assert (min.length == blockSize.length) : "Dimensionality mismatch!";
        assert (max.length == blockSize.length) : "Dimensionality mismatch!";
        assert (IntStream.range(0, min.length).filter(d -> max[d] < min[d]).count() == 0L) : "max has to greater or equal than min for all dimensions!";
        int nDim = min.length;
        for (d2 = 0; d2 < nDim; ++d2) {
            setOffsetForDimension.set(min[d2], d2);
        }
        d2 = 0;
        block1: while (d2 < nDim) {
            runAtEachOffset.run();
            for (d2 = 0; d2 < nDim; ++d2) {
                moveForDimension.move(blockSize[d2], d2);
                if (getOffsetForDimension.get(d2) <= max[d2]) continue block1;
                setOffsetForDimension.set(min[d2], d2);
            }
        }
    }

    public static List<Pair<Interval, long[]>> collectAllContainedIntervalsWithGridPositions(long[] dimensions, int[] blockSize) {
        return Grids.collectAllOffsets(dimensions, blockSize, Grids.croppedIntervalAndGridPosition(dimensions, blockSize));
    }

    public static List<Pair<Interval, long[]>> collectAllContainedIntervalsWithGridPositions(long[] min, long[] max, int[] blockSize) {
        return Grids.collectAllOffsets(min, max, blockSize, Grids.croppedIntervalAndGridPosition(min, max, blockSize));
    }

    public static List<Interval> collectAllContainedIntervals(long[] dimensions, int[] blockSize) {
        return Grids.collectAllOffsets(dimensions, blockSize, new CreateAndCropBlockToFitInterval(blockSize, new FinalInterval(dimensions)));
    }

    public static List<Interval> collectAllContainedIntervals(long[] min, long[] max, int[] blockSize) {
        return Grids.collectAllOffsets(min, max, blockSize, new CreateAndCropBlockToFitInterval(blockSize, max));
    }

    public static List<long[]> collectAllOffsets(long[] dimensions, int[] blockSize) {
        return Grids.collectAllOffsets(dimensions, blockSize, block -> (long[])block.clone());
    }

    public static <T> List<T> collectAllOffsets(long[] dimensions, int[] blockSize, Function<long[], T> func) {
        return Grids.collectAllOffsets(new long[dimensions.length], Arrays.stream(dimensions).map(d -> d - 1L).toArray(), blockSize, func);
    }

    public static List<long[]> collectAllOffsets(long[] min, long[] max, int[] blockSize) {
        return Grids.collectAllOffsets(min, max, blockSize, block -> (long[])block.clone());
    }

    public static <T> List<T> collectAllOffsets(long[] min, long[] max, int[] blockSize, Function<long[], T> func) {
        ArrayList blocks = new ArrayList();
        Grids.forEachOffset(min, max, blockSize, offset -> blocks.add(func.apply((long[])offset)));
        return blocks;
    }

    public static Function<long[], Pair<Interval, long[]>> croppedIntervalAndGridPosition(long[] dimensions, int[] blockSize) {
        CreateAndCropBlockToFitInterval makeInterval = new CreateAndCropBlockToFitInterval(blockSize, new FinalInterval(dimensions));
        GetGridCoordinates getGridCoordinates = new GetGridCoordinates(blockSize);
        return blockMinimum -> new ValuePair<Interval, long[]>(makeInterval.apply((long[])blockMinimum), getGridCoordinates.apply((long[])blockMinimum));
    }

    public static Function<long[], Pair<Interval, long[]>> croppedIntervalAndGridPosition(long[] min, long[] max, int[] blockSize) {
        CreateAndCropBlockToFitInterval makeInterval = new CreateAndCropBlockToFitInterval(blockSize, max);
        GetGridCoordinates getGridCoordinates = new GetGridCoordinates(blockSize, min);
        return blockMinimum -> new ValuePair<Interval, long[]>(makeInterval.apply((long[])blockMinimum), getGridCoordinates.apply((long[])blockMinimum));
    }

    public static class GetGridCoordinates
    implements Function<long[], long[]> {
        private final int[] blockSize;
        private final long[] gridMin;

        public GetGridCoordinates(int[] blockSize, long[] min) {
            this.blockSize = blockSize;
            this.gridMin = min;
        }

        public GetGridCoordinates(int[] blockSize, Interval interval) {
            this(blockSize, Intervals.minAsLongArray(interval));
        }

        public GetGridCoordinates(int[] blockSize) {
            this(blockSize, new long[blockSize.length]);
        }

        @Override
        public long[] apply(long[] min) {
            long[] gridPosition = new long[min.length];
            Arrays.setAll(gridPosition, d -> (min[d] - this.gridMin[d]) / (long)this.blockSize[d]);
            return gridPosition;
        }
    }

    public static class CreateAndCropBlockToFitInterval
    implements Function<long[], Interval> {
        private final int[] blockSize;
        private final long[] max;

        public CreateAndCropBlockToFitInterval(int[] blockSize, long[] max) {
            this.blockSize = blockSize;
            this.max = max;
        }

        public CreateAndCropBlockToFitInterval(int[] blockSize, Interval interval) {
            this(blockSize, Intervals.maxAsLongArray(interval));
        }

        @Override
        public Interval apply(long[] min) {
            long[] max = new long[min.length];
            Arrays.setAll(max, d -> Math.min(min[d] + (long)this.blockSize[d] - 1L, this.max[d]));
            return new FinalInterval(min, max);
        }
    }

    public static interface GetForDimension {
        public long get(int var1);
    }

    public static interface SetForDimension {
        public void set(long var1, int var3);
    }

    public static interface MoveForDimension {
        public void move(long var1, int var3);
    }
}

