/*
 * Decompiled with CFR 0.152.
 */
package inference;

import inference.BinBoundariesInference;
import inference.BinClassificationInference;
import inference.DistributionInference;
import inference.InferenceCaller;
import inference.LogFuncs;
import inference.ModelInference;
import java.util.Vector;

public class Inference {
    public int[] data;
    public int[] count;
    public double[] subEvidences;
    public InferenceCaller caller;
    double[] logA;
    double[] logEvidences;

    public void setData(int[] data_) {
        this.data = data_;
        this.initCount();
    }

    public void setData(Vector data_) {
        int size = data_.size();
        this.data = new int[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = (Integer)data_.get(i);
        }
        this.initCount();
    }

    public void initCount() {
        int i;
        this.count = new int[this.K() + 1];
        this.subEvidences = new double[this.K() * this.K()];
        this.count[0] = 0;
        for (i = 1; i <= this.K(); ++i) {
            this.count[i] = this.count[i - 1] + this.data[i - 1];
        }
        for (i = -1; i < this.K() - 1; ++i) {
            for (int j = i + 1; j < this.K(); ++j) {
                int n = this.getCount(i, j);
                this.subEvidences[j + (i + 1) * this.K()] = LogFuncs.LogFactorial(n) - LogFuncs.LogPow(j - i, n);
            }
        }
    }

    public int getCount(int k1, int k2) {
        return this.count[k2 + 1] - this.count[k1 + 1];
    }

    public int K() {
        return this.data.length;
    }

    public int N() {
        return this.count[this.K()];
    }

    private void init(int M) {
        this.logA = new double[this.K()];
        this.logEvidences = new double[M + 1];
        for (int k = 0; k < this.K(); ++k) {
            this.logA[k] = this.subEvidences[k] + this.caller.logExpectationFactor(0, -1, k);
        }
        this.logEvidences[0] = this.substep4b(0);
    }

    private double substep4aii(int k, int begin) {
        double a = -1.0E300;
        for (int kk = begin; kk < k; ++kk) {
            a = LogFuncs.LogAddLogLog(a, this.logA[kk] + this.subEvidences[k + (kk + 1) * this.K()] + this.caller.logExpectationFactor(begin + 1, kk, k));
        }
        return a;
    }

    private double substep4b(int m) {
        return this.logA[this.K() - 1] + this.caller.logPrior(m);
    }

    private void step4(int M) {
        for (int m = 1; m < M; ++m) {
            for (int k = this.K() - 1; k >= m; --k) {
                this.logA[k] = this.substep4aii(k, m - 1);
            }
            this.logEvidences[m] = this.substep4b(m);
        }
    }

    void step6(int M) {
        this.logA[this.K() - 1] = this.substep4aii(this.K() - 1, M - 1);
        this.logEvidences[M] = this.substep4b(M);
    }

    public void doit(int M) {
        this.init(M);
        this.step4(M);
        this.step6(M);
    }

    public double defaultLogPrior(int m) {
        return LogFuncs.LogFactorial(this.K() - 1 - m) + 2.0 * LogFuncs.LogFactorial(m) - LogFuncs.LogFactorial(this.K() - 1) - LogFuncs.LogFactorial(this.N() + m);
    }

    public static void main(String[] args) {
        BinBoundariesInference m = new BinBoundariesInference();
        ModelInference moi = new ModelInference();
        int[] data = new int[]{0, 0, 0, 100, 30, 100, 0, 0};
        moi.setData(data);
        moi.doit(7, 0.03);
        m.setData(data);
        m.doit(2);
        for (int k = 0; k < data.length; ++k) {
            System.err.println(k + " -> " + m.rebin(k));
        }
        BinClassificationInference mbc = new BinClassificationInference();
        mbc.setData(data);
        mbc.doit(2);
        for (int k = 0; k < data.length; ++k) {
            System.err.println(k + " -> " + mbc.rebin(k));
        }
        DistributionInference dii = new DistributionInference();
        dii.setData(data);
        dii.doit(4);
    }
}

