/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.AbstractOverlapResolver;
import de.biomedical_imaging.ij.steger.Junction;
import de.biomedical_imaging.ij.steger.Junctions;
import de.biomedical_imaging.ij.steger.Line;
import de.biomedical_imaging.ij.steger.Lines;
import de.biomedical_imaging.ij.steger.LinesUtil;
import ij.IJ;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SlopeOverlapResolver
extends AbstractOverlapResolver {
    private static final float SIGMA = 2.0f;
    private static final int SLOPE_DIST = 5;
    private static final float STRAIGHT_TOLERANCE = 1.02f;

    @Override
    public Lines resolve(Lines originalLines, Junctions junctions, boolean verbose) {
        if (verbose) {
            IJ.log((String)"### Overlap detection using Slope heuristic");
        }
        HashSet<Line> enclosedLines = new HashSet<Line>();
        ArrayList<List<Line>> nWayIntersections = new ArrayList<List<Line>>();
        this.findOverlap(enclosedLines, nWayIntersections, junctions, verbose);
        HashMap<Line, List<Line>> startIntersections = new HashMap<Line, List<Line>>();
        HashMap<Line, List<Line>> endIntersections = new HashMap<Line, List<Line>>();
        this.buildIntersectionMaps(originalLines, enclosedLines, startIntersections, endIntersections, verbose);
        ArrayList<List<Line>> lineMerges = new ArrayList<List<Line>>();
        this.buildMergeList(lineMerges, enclosedLines, startIntersections, endIntersections, verbose);
        this.buildMergeList(lineMerges, nWayIntersections, verbose);
        HashMap<Line, Line> lineMap = new HashMap<Line, Line>();
        Lines resolvedLines = this.buildResolvedList(originalLines, lineMerges, lineMap, verbose);
        Set<Junction> updatedJunctions = this.updateJunctions(junctions, lineMap);
        this.pruneJunctions(junctions, updatedJunctions);
        this.updateContourClasses(updatedJunctions);
        return resolvedLines;
    }

    /*
     * WARNING - void declaration
     */
    private void findOverlap(Set<Line> enclosed, List<List<Line>> nWay, Junctions junctions, boolean verbose) {
        HashMap<Line, Junction> startMatches = new HashMap<Line, Junction>();
        HashMap<Line, Junction> endMatches = new HashMap<Line, Junction>();
        for (Junction j : junctions) {
            if (this.matchesStart(j, j.getLine1())) {
                startMatches.put(j.getLine1(), j);
            }
            if (this.matchesEnd(j, j.getLine1())) {
                endMatches.put(j.getLine1(), j);
            }
            if (this.matchesStart(j, j.getLine2())) {
                startMatches.put(j.getLine2(), j);
            }
            if (!this.matchesEnd(j, j.getLine2())) continue;
            endMatches.put(j.getLine2(), j);
        }
        if (verbose) {
            for (Line l : startMatches.keySet()) {
                IJ.log((String)("Found line " + l.getID() + " intersects with junction " + startMatches.get(l) + " at line start"));
            }
            for (Line l : endMatches.keySet()) {
                IJ.log((String)("Found line " + l.getID() + " intersects with junction " + endMatches.get(l) + " at line end"));
            }
        }
        enclosed.addAll(startMatches.keySet());
        enclosed.retainAll(endMatches.keySet());
        HashSet tSections = new HashSet(startMatches.keySet());
        tSections.addAll(endMatches.keySet());
        tSections.removeAll(enclosed);
        ArrayList lineSets = new ArrayList();
        for (Line line : tSections) {
            boolean found = false;
            for (int i = 0; i < lineSets.size() && !found; ++i) {
                List intersects = (List)lineSets.get(i);
                for (int j = 0; j < intersects.size() && !found; ++j) {
                    Line l2 = (Line)intersects.get(j);
                    if (!this.intersects(line, l2, 2.0f)) continue;
                    found = true;
                    intersects.add(line);
                }
            }
            if (found) continue;
            ArrayList<Line> lineList = new ArrayList<Line>();
            lineList.add(line);
            lineSets.add(lineList);
        }
        for (List list : lineSets) {
            if (list.size() < 3) continue;
            nWay.add(list);
        }
        if (verbose) {
            for (List list : nWay) {
                StringBuffer sb = new StringBuffer();
                sb.append("Found n-way intersection: ");
                for (Line l : list) {
                    sb.append(l.getID() + " ");
                }
                IJ.log((String)sb.toString());
            }
        }
        boolean pruneEnclosed = true;
        while (pruneEnclosed) {
            void var10_18;
            pruneEnclosed = false;
            Object var10_17 = null;
            for (Line l1 : enclosed) {
                boolean foundStartMatch = false;
                boolean foundEndMatch = false;
                for (Line l2 : enclosed) {
                    if (l2 == l1) continue;
                    if (this.intersectsStart(l1, l2, 2.0f)) {
                        foundStartMatch = true;
                    } else if (this.intersectsEnd(l1, l2, 2.0f)) {
                        foundEndMatch = true;
                    }
                    if (!foundStartMatch || !foundEndMatch) continue;
                    break;
                }
                if (!foundStartMatch || !foundEndMatch) continue;
                Line line = l1;
                pruneEnclosed = true;
            }
            if (var10_18 == null) continue;
            enclosed.remove(var10_18);
        }
        if (verbose) {
            for (Line l : enclosed) {
                IJ.log((String)("Found enclosed line: " + l.getID()));
            }
        }
    }

    private void buildIntersectionMaps(Lines lines, Set<Line> enclosedLines, Map<Line, List<Line>> startIntersections, Map<Line, List<Line>> endIntersections, boolean verbose) {
        for (Line l1 : enclosedLines) {
            ArrayList<Line> startIsect = new ArrayList<Line>();
            ArrayList<Line> endIsect = new ArrayList<Line>();
            for (Line l2 : lines) {
                if (l2 == l1) continue;
                if (this.intersectsStart(l1, l2, 2.0f)) {
                    startIsect.add(l2);
                    continue;
                }
                if (!this.intersectsEnd(l1, l2, 2.0f)) continue;
                endIsect.add(l2);
            }
            startIntersections.put(l1, startIsect);
            endIntersections.put(l1, endIsect);
        }
        if (verbose) {
            for (Line l1 : enclosedLines) {
                IJ.log((String)("For enclosed line " + l1.getID() + " found intersecting lines: "));
                for (Line l2 : startIntersections.get(l1)) {
                    IJ.log((String)("\tat start: " + l2.getID()));
                }
                for (Line l2 : endIntersections.get(l1)) {
                    IJ.log((String)("\tat end: " + l2.getID()));
                }
            }
        }
    }

    private void buildMergeList(List<List<Line>> lineMerges, Set<Line> enclosedLines, Map<Line, List<Line>> startIntersections, Map<Line, List<Line>> endIntersections, boolean verbose) {
        for (Line enclosed : enclosedLines) {
            ArrayList<Line> toMerge;
            ArrayList<float[]> startPoints = new ArrayList<float[]>();
            ArrayList<float[]> endPoints = new ArrayList<float[]>();
            List<Line> startLines = startIntersections.get(enclosed);
            List<Line> endLines = endIntersections.get(enclosed);
            float[] enclosedStart = new float[]{enclosed.getXCoordinates()[0], enclosed.getYCoordinates()[0]};
            float[] enclosedEnd = new float[]{enclosed.getXCoordinates()[enclosed.getNumber() - 1], enclosed.getYCoordinates()[enclosed.getNumber() - 1]};
            for (Line l : startLines) {
                startPoints.add(this.getInterceptPoint(enclosedStart, l));
            }
            for (Line l : endLines) {
                endPoints.add(this.getInterceptPoint(enclosedEnd, l));
            }
            while (startLines.size() > 0 && endLines.size() > 0) {
                int startIndex = 0;
                int endIndex = 0;
                float minStraightness = Float.MAX_VALUE;
                toMerge = new ArrayList<Line>();
                for (int i = 0; i < startLines.size(); ++i) {
                    for (int j = 0; j < endLines.size(); ++j) {
                        float[][] fArrayArray = new float[][]{(float[])startPoints.get(i), enclosedStart, enclosedEnd, (float[])endPoints.get(j)};
                        float straightness = this.straightCalc(fArrayArray);
                        if (!(straightness < minStraightness)) continue;
                        startIndex = i;
                        endIndex = j;
                        minStraightness = straightness;
                    }
                }
                toMerge.add(startLines.remove(startIndex));
                toMerge.add(enclosed);
                toMerge.add(endLines.remove(endIndex));
                lineMerges.add(toMerge);
                startPoints.remove(startIndex);
                endPoints.remove(endIndex);
            }
            List<Line> unmatched = startLines.size() > 0 ? startLines : endLines;
            for (Line line : unmatched) {
                toMerge = new ArrayList();
                toMerge.add(line);
                lineMerges.add(toMerge);
            }
        }
        int i = 0;
        int j = 1;
        while (j < lineMerges.size()) {
            List<Line> list1 = lineMerges.get(i);
            List<Line> list2 = lineMerges.get(j);
            if (list1.get(0) == list2.get(list2.size() - 1)) {
                lineMerges.remove(i);
                list1.remove(0);
                list2.addAll(list1);
                i = 0;
                j = 1;
                continue;
            }
            if (list2.get(0) == list1.get(list1.size() - 1)) {
                lineMerges.remove(j);
                list2.remove(0);
                list1.addAll(list2);
                i = 0;
                j = 1;
                continue;
            }
            if (++j != lineMerges.size()) continue;
            j = ++i + 1;
        }
        if (verbose) {
            for (List<Line> merge : lineMerges) {
                StringBuilder sb = new StringBuilder();
                sb.append("Merging lines: ");
                for (Line line : merge) {
                    sb.append(line.getID());
                    sb.append(" ");
                }
                IJ.log((String)sb.toString());
            }
        }
    }

    private void buildMergeList(List<List<Line>> lineMerges, List<List<Line>> nWayIntersections, boolean verbose) {
        for (List<Line> iSection : nWayIntersections) {
            float[] junction = new float[2];
            Line testLine = iSection.get(0);
            int index = 0;
            if (this.intersectsEnd(testLine, iSection.get(1), 2.0f)) {
                index = testLine.getNumber() - 1;
            }
            junction[0] = testLine.getXCoordinates()[index];
            junction[1] = testLine.getYCoordinates()[index];
            while (iSection.size() > 1) {
                ArrayList<Line> merge = new ArrayList<Line>();
                int idx1 = 0;
                int idx2 = 1;
                float minStraightness = Float.MAX_VALUE;
                for (int i = 0; i < iSection.size(); ++i) {
                    float[] icept = this.getInterceptPoint(junction, iSection.get(i));
                    for (int j = i + 1; j < iSection.size(); ++j) {
                        float[] jcept = this.getInterceptPoint(junction, iSection.get(j));
                        float[][] fArrayArray = new float[][]{icept, junction, jcept};
                        float curStraightness = this.straightCalc(fArrayArray);
                        if (!(curStraightness < minStraightness)) continue;
                        minStraightness = curStraightness;
                        idx1 = i;
                        idx2 = j;
                    }
                }
                merge.add(iSection.get(idx1));
                merge.add(iSection.get(idx2));
                iSection.remove(idx1);
                iSection.remove(--idx2);
                lineMerges.add(merge);
            }
            if (iSection.size() != 1) continue;
            lineMerges.add(iSection);
        }
    }

    private Lines buildResolvedList(Lines originalLines, List<List<Line>> lineMerges, Map<Line, Line> lineMap, boolean verbose) {
        HashSet<Line> finalLines = new HashSet<Line>(originalLines);
        for (List<Line> toMerge : lineMerges) {
            finalLines.removeAll(toMerge);
            int newSize = 0;
            int frame = 0;
            for (Line l : toMerge) {
                frame = l.getFrame();
                newSize += l.getNumber();
            }
            Line merged = null;
            if (toMerge.size() == 1) {
                merged = toMerge.get(0);
            } else {
                merged = new Line();
                merged.angle = new float[newSize];
                merged.asymmetry = new float[newSize];
                merged.col = new float[newSize];
                merged.row = new float[newSize];
                merged.response = new float[newSize];
                merged.intensity = new float[newSize];
                merged.width_l = new float[newSize];
                merged.width_r = new float[newSize];
                merged.num = newSize;
                merged.setContourClass(LinesUtil.contour_class.cont_no_junc);
                merged.setFrame(frame);
                int pos = 0;
                for (int i = 0; i < toMerge.size(); ++i) {
                    Line line = toMerge.get(i);
                    Line adjacent = null;
                    adjacent = i == 0 ? toMerge.get(i + 1) : toMerge.get(i - 1);
                    int num = line.getNumber();
                    this.fillArray(line, adjacent, i == 0, merged.angle, pos, line.angle, num);
                    this.fillArray(line, adjacent, i == 0, merged.asymmetry, pos, line.asymmetry, num);
                    this.fillArray(line, adjacent, i == 0, merged.col, pos, line.col, num);
                    this.fillArray(line, adjacent, i == 0, merged.row, pos, line.row, num);
                    this.fillArray(line, adjacent, i == 0, merged.response, pos, line.response, num);
                    this.fillArray(line, adjacent, i == 0, merged.intensity, pos, line.intensity, num);
                    this.fillArray(line, adjacent, i == 0, merged.width_l, pos, line.width_l, num);
                    this.fillArray(line, adjacent, i == 0, merged.width_r, pos, line.width_r, num);
                    pos += num;
                    lineMap.put(line, merged);
                }
            }
            finalLines.add(merged);
        }
        Lines resolvedLines = new Lines(originalLines.getFrame());
        resolvedLines.addAll(finalLines);
        return resolvedLines;
    }

    private Set<Junction> updateJunctions(Junctions junctions, Map<Line, Line> lineMap) {
        HashSet<Junction> updated = new HashSet<Junction>();
        for (Junction junction : junctions) {
            Line mergedLine = null;
            mergedLine = lineMap.get(junction.lineCont1);
            if (mergedLine != null) {
                junction.lineCont1 = mergedLine;
                junction.cont1 = mergedLine.getID();
                updated.add(junction);
            }
            mergedLine = null;
            mergedLine = lineMap.get(junction.lineCont2);
            if (mergedLine == null) continue;
            junction.lineCont2 = mergedLine;
            junction.cont2 = mergedLine.getID();
            updated.add(junction);
        }
        return updated;
    }

    private void pruneJunctions(Junctions junctions, Set<Junction> updatedJunctions) {
        HashMap<String, Junction> jMap = new HashMap<String, Junction>();
        for (Junction j : updatedJunctions) {
            String key = null;
            if (j.cont1 == j.cont2) {
                junctions.remove(j);
                continue;
            }
            key = this.getKey(j);
            if (jMap.containsKey(key)) {
                junctions.remove(j);
                continue;
            }
            jMap.put(key, j);
        }
        updatedJunctions.retainAll(junctions);
    }

    private void updateContourClasses(Set<Junction> updatedJunctions) {
        for (Junction j : updatedJunctions) {
            j.isNonTerminal = this.processLine(j, j.lineCont1, true);
            j.isNonTerminal = this.processLine(j, j.lineCont2, false) && j.isNonTerminal;
        }
    }

    private boolean processLine(Junction j, Line line, boolean updatePos) {
        int pos = -1;
        float[] x = line.getXCoordinates();
        float[] y = line.getYCoordinates();
        for (int i = 0; i < line.num && pos < 0; ++i) {
            if (Float.compare(x[i], j.x) != 0 || Float.compare(y[i], j.y) != 0) continue;
            pos = i;
        }
        if (updatePos) {
            j.pos = pos;
        }
        if (!line.getContourClass().equals((Object)LinesUtil.contour_class.cont_both_junc)) {
            if (pos == 0) {
                if (line.getContourClass().equals((Object)LinesUtil.contour_class.cont_end_junc)) {
                    line.setContourClass(LinesUtil.contour_class.cont_both_junc);
                } else {
                    line.setContourClass(LinesUtil.contour_class.cont_start_junc);
                }
            } else if (pos == line.num - 1) {
                if (line.getContourClass().equals((Object)LinesUtil.contour_class.cont_start_junc)) {
                    line.setContourClass(LinesUtil.contour_class.cont_both_junc);
                } else {
                    line.setContourClass(LinesUtil.contour_class.cont_end_junc);
                }
            }
        }
        return pos != 0 && pos != line.num - 1;
    }

    private float straightCalc(float[] ... points) {
        float ideal = this.dist(points[0], points[points.length - 1]);
        float sum = 0.0f;
        for (int i = 1; i < points.length; ++i) {
            sum += this.dist(points[i - 1], points[i]);
        }
        return sum / ideal;
    }

    private float dist(float[] p1, float[] p2) {
        return (float)Math.sqrt(Math.pow(p2[0] - p1[0], 2.0) + Math.pow(p2[1] - p1[1], 2.0));
    }

    private void fillArray(Line line, Line adjacent, boolean adjacentIsNext, float[] target, int pos, float[] source, int length) {
        if (source == null) {
            Arrays.fill(target, pos, pos + length, 0.0f);
        } else if (adjacentIsNext && this.intersectsStart(line, adjacent, 2.0f) || !adjacentIsNext && this.intersectsEnd(line, adjacent, 2.0f)) {
            for (int i = source.length - 1; i >= 0; --i) {
                target[pos++] = source[i];
            }
        } else {
            System.arraycopy(source, 0, target, pos, length);
        }
    }

    private float[] getInterceptPoint(float[] p1, Line query) {
        int dist = 0;
        ArrayList<float[]> points = new ArrayList<float[]>();
        points.add(p1);
        return this.findLongestPath(query, dist, points);
    }

    private float[] findLongestPath(Line query, int dist, List<float[]> points) {
        float[] p1 = points.get(0);
        int pos = 0;
        pos = Math.abs(p1[0] - query.getXCoordinates()[0]) < 2.0f && Math.abs(p1[1] - query.getYCoordinates()[0]) < 2.0f ? Math.min(dist, query.getNumber() - 1) : Math.max(0, query.getNumber() - 1 - (dist += 5));
        float[] p2 = new float[]{query.getXCoordinates()[pos], query.getYCoordinates()[pos]};
        if (pos == 0 || pos == query.getNumber() - 1) {
            return p2;
        }
        points.add(p2);
        if (this.straightCalc((float[][])points.toArray((T[])new float[points.size()][])) <= 1.02f) {
            return this.findLongestPath(query, dist, points);
        }
        return points.get(points.size() - 2);
    }

    private boolean intersects(Line l1, Line l2, float threshold) {
        return this.intersectsStart(l1, l2, threshold) || this.intersectsEnd(l1, l2, threshold);
    }

    private boolean intersectsStart(Line target, Line query, float threshold) {
        float[] tStart = this.getPoint(target, 0);
        float[] qStart = this.getPoint(query, 0);
        float[] qEnd = this.getPoint(query, query.getNumber() - 1);
        return this.intersects(tStart, qStart, threshold) || this.intersects(tStart, qEnd, threshold);
    }

    private boolean intersectsEnd(Line target, Line query, float threshold) {
        float[] tEnd = this.getPoint(target, target.getNumber() - 1);
        float[] qStart = this.getPoint(query, 0);
        float[] qEnd = this.getPoint(query, query.getNumber() - 1);
        return this.intersects(tEnd, qStart, threshold) || this.intersects(tEnd, qEnd, threshold);
    }

    private boolean intersects(float[] tEnd, float[] qEnd, float threshold) {
        return Math.abs(qEnd[0] - tEnd[0]) < threshold && Math.abs(qEnd[1] - tEnd[1]) < threshold;
    }

    private String getKey(Junction junction) {
        StringBuilder sb = new StringBuilder();
        sb.append(Math.min(junction.cont1, junction.cont2));
        sb.append(Math.max(junction.cont1, junction.cont2));
        sb.append(junction.x);
        sb.append(junction.y);
        return sb.toString();
    }

    private float[] getPoint(Line target, int i) {
        float[] coords = new float[]{target.getXCoordinates()[i], target.getYCoordinates()[i]};
        return coords;
    }

    private boolean matchesStart(Junction junction, Line line) {
        return line.getXCoordinates()[0] == junction.getX() && line.getYCoordinates()[0] == junction.getY();
    }

    private boolean matchesEnd(Junction junction, Line line) {
        int count = line.getNumber() - 1;
        return line.getXCoordinates()[count] == junction.getX() && line.getYCoordinates()[count] == junction.getY();
    }
}

