/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJFlow;
import bijnum.BIJmatrix;
import ij.IJ;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;

public class FlowJError {
    private float[][] psi;
    private float[][] angular;
    private float[][][] delta;
    private boolean[][] hasflow;
    private int binNr;
    public FlowJFlow flow;
    public FlowJFlow trueFlow;
    private float binWidth;
    private float[] binPsi;
    private float[] binStdDev;
    private float[] density;
    private float[] binMax;
    private float[] binMin;
    private float[] binDeltaAngle;
    private float[] binDeltaLength;
    private int[] n;
    private int[] total;
    private int width;
    private int height;

    public FlowJError(int width, int height) {
        this.width = width;
        this.height = height;
        this.psi = new float[height][width];
        this.angular = new float[height][width];
        this.delta = new float[height][width][2];
        this.hasflow = new boolean[height][width];
    }

    public float xExpected(int x, int y) {
        return this.trueFlow.getX(x, y);
    }

    public float yExpected(int x, int y) {
        return this.trueFlow.getY(x, y);
    }

    public float psi(int x, int y) {
        return this.psi[y][x];
    }

    private static float PsiErr(float[] ve, float[] va) {
        float r;
        float[] veNorm = new float[3];
        float[] vaNorm = new float[3];
        veNorm[0] = ve[0];
        veNorm[1] = ve[1];
        veNorm[2] = 1.0f;
        vaNorm[0] = va[0];
        vaNorm[1] = va[1];
        vaNorm[2] = 1.0f;
        float v = (veNorm[0] * vaNorm[0] + veNorm[1] * vaNorm[1] + 1.0f) / (BIJmatrix.norm(vaNorm) * BIJmatrix.norm(veNorm));
        if (v > 1.0f && (double)v < 1.0001) {
            v = 1.0f;
        }
        if ((r = (float)Math.acos(v) * 180.0f / (float)Math.PI) < 0.0f || r >= 180.0f) {
            IJ.error((String)("ERROR in PsiErr() " + r + " " + v + "\nActual " + va[0] + ", " + va[1] + " expected " + ve[0] + " ," + ve[1]));
        }
        return r;
    }

    private static float PsiEN(float[] ve, float[] va) {
        float r;
        float[] veNorm = new float[2];
        float nva = BIJmatrix.norm(va);
        float nve = BIJmatrix.norm(ve);
        if ((double)nve > 1.0E-8) {
            veNorm[0] = ve[0] / nve;
            veNorm[1] = ve[1] / nve;
            r = va[0] * veNorm[0] + va[1] * veNorm[1] - nve;
            float t = r / ((float)Math.sqrt(1.0f + nva * nva) * (float)Math.sqrt(1.0f + nve * nve));
            if ((r = (float)Math.asin(t) * 180.0f / (float)Math.PI) < -90.0f || r > 90.0f) {
                IJ.error((String)("ERROR in PsiEN() r " + r + " t " + t));
            }
        } else {
            r = 100.0f;
        }
        return Math.abs(r);
    }

    public float average(Roi roi) {
        Rectangle r = roi.getBoundingRect();
        float psiSum = 0.0f;
        int s = 0;
        for (int y = 0; y < r.height; ++y) {
            for (int x = 0; x < r.width; ++x) {
                if (roi instanceof Roi && !roi.contains(r.x + x, r.y + y)) continue;
                psiSum += this.psi[r.y + y][r.x + x];
                ++s;
            }
        }
        return psiSum / (float)s;
    }

    public void computePsi(FlowJFlow flow, FlowJFlow trueFlow) {
        this.flow = flow;
        this.trueFlow = trueFlow;
        int full = 0;
        int total = 0;
        float sumPsi = 0.0f;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                boolean f4;
                this.psi[y][x] = 0.0f;
                if (!flow.valid(x, y)) continue;
                float[] actA = FlowJFlow.polar(flow.getX(x, y), flow.getY(x, y));
                float[] trueA = FlowJFlow.polar(trueFlow.getX(x, y), trueFlow.getY(x, y));
                this.angular[y][x] = trueA[0];
                boolean f1 = flow.full[y][x];
                boolean f2 = flow.getX(x, y) == 100.0f && flow.getY(x, y) == 100.0f;
                boolean f3 = trueFlow.full[y][x];
                boolean bl = f4 = trueFlow.getX(x, y) == 100.0f && trueFlow.getY(x, y) == 100.0f;
                if (!f1 || f2 || !f3 || f4) {
                    this.hasflow[y][x] = false;
                } else {
                    this.hasflow[y][x] = true;
                    this.psi[y][x] = FlowJError.PsiErr(flow.get(x, y), trueFlow.get(x, y));
                    sumPsi += this.psi[y][x];
                    this.delta[y][x][0] = actA[0] - trueA[0];
                    this.delta[y][x][1] = (float)((double)((actA[1] - trueA[1]) * 180.0f) / Math.PI);
                    if (this.delta[y][x][1] >= 360.0f) {
                        float[] fArray = this.delta[y][x];
                        fArray[1] = fArray[1] - 360.0f;
                    }
                    if (this.delta[y][x][1] <= -360.0f) {
                        float[] fArray = this.delta[y][x];
                        fArray[1] = fArray[1] + 360.0f;
                    }
                    if (Math.abs(this.delta[y][x][1]) > 180.0f) {
                        this.delta[y][x][1] = -(360.0f - Math.abs(this.delta[y][x][1]));
                    }
                    ++full;
                }
                ++total;
            }
        }
        IJ.log((String)("Density " + IJ.d2s((double)(100.0f * (float)full / (float)total), (int)2) + "%; psi average: " + IJ.d2s((double)(sumPsi / (float)full), (int)2)));
    }

    public static void map(Graphics g, int width, int height, FlowJFlow flow, FlowJFlow trueFlow) {
        int MARGIN = 5;
        height = Math.min(height - 5 - 2, width - 5 - 2);
        float max = 4.0f;
        float scaling = (float)height / max;
        Rectangle frame = new Rectangle(7, 0, height - 1, height);
        g.setColor(new Color(0xFF3D3D));
        int[][] duplicate = new int[height + 1][height + 1];
        for (int y = 0; y < flow.getHeight(); ++y) {
            for (int x = 0; x < flow.getWidth(); ++x) {
                if (!flow.valid(x, y)) continue;
                float[] actA = FlowJFlow.polar(flow.getX(x, y), flow.getY(x, y));
                float[] trueA = FlowJFlow.polar(trueFlow.getX(x, y), trueFlow.getY(x, y));
                if (!(actA[0] < max) || !(trueA[0] < max) || !(actA[0] >= 0.0f) || !(trueA[0] >= 0.0f)) continue;
                int xC = (int)((double)(trueA[0] * scaling) + 0.5);
                int yC = (int)((double)(actA[0] * scaling) + 0.5);
                int[] nArray = duplicate[yC];
                int n = xC;
                nArray[n] = nArray[n] + 1;
                int i = 255 - duplicate[yC][xC] * 85;
                int p = (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
                g.setColor(new Color(p));
                g.drawLine(frame.x + xC, frame.y + frame.height - yC, frame.x + xC, frame.y + frame.height - yC);
            }
        }
        g.setColor(new Color(0));
        g.drawLine(0, frame.y + frame.height, frame.x + frame.width, frame.y + frame.height);
        g.drawLine(frame.x, frame.y, frame.x, frame.y + frame.height);
        for (float d = 0.0f; d <= max; d += 1.0f) {
            g.drawLine(frame.x + (int)((double)(d * scaling) + 0.5), frame.y + frame.height, frame.x + (int)((double)(d * scaling) + 0.5), frame.y + frame.height + 5);
            g.drawLine(frame.x - 5, frame.y + frame.height - (int)((double)(d * scaling) + 0.5), frame.x, frame.y + frame.height - (int)((double)(d * scaling) + 0.5));
        }
    }

    public void map(ColorProcessor ip) {
        int[] pixels = (int[])ip.getPixels();
        int p = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int i = this.hasflow[y][x] ? (int)(this.psi[y][x] / 180.0f * 155.0f + 100.0f) : 0;
                int r = i;
                int g = i;
                int b = i;
                pixels[p++] = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            }
        }
    }

    public void averageOverVelocity() {
        int i;
        this.binWidth = 0.1f;
        this.binNr = 60;
        this.binPsi = new float[this.binNr];
        this.total = new int[this.binNr];
        this.density = new float[this.binNr];
        this.n = new int[this.binNr];
        this.binStdDev = new float[this.binNr];
        this.binMin = new float[this.binNr];
        this.binMax = new float[this.binNr];
        this.binDeltaAngle = new float[this.binNr];
        this.binDeltaLength = new float[this.binNr];
        float rangeMax = 3.0f;
        float rangePsi = 0.0f;
        int rangeN = 0;
        int rangeS = 0;
        float rangeStddev = 0.0f;
        float rangeLength = 0.0f;
        for (int i2 = 0; i2 < this.binNr; ++i2) {
            this.total[i2] = 0;
            this.n[i2] = 0;
            this.binDeltaLength[i2] = this.binDeltaAngle[i2] = (float)0;
            this.binStdDev[i2] = this.binDeltaAngle[i2];
            this.binPsi[i2] = this.binDeltaAngle[i2];
            this.binMin[i2] = Float.MAX_VALUE;
            this.binMax[i2] = -3.4028235E38f;
        }
        int validSurface = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.flow.valid(x, y)) continue;
                if (this.angular[y][x] < rangeMax) {
                    if (this.hasflow[y][x]) {
                        rangePsi += this.psi[y][x];
                        rangeStddev += this.psi[y][x] * this.psi[y][x];
                        rangeLength += this.delta[y][x][0];
                        ++rangeN;
                    }
                    ++rangeS;
                }
                if ((i = (int)(this.angular[y][x] / this.binWidth)) < this.binNr) {
                    if (this.hasflow[y][x]) {
                        int n = i;
                        this.binPsi[n] = this.binPsi[n] + this.psi[y][x];
                        int n2 = i;
                        this.binStdDev[n2] = this.binStdDev[n2] + this.psi[y][x] * this.psi[y][x];
                        int n3 = i;
                        this.binDeltaLength[n3] = this.binDeltaLength[n3] + this.delta[y][x][0];
                        int n4 = i;
                        this.binDeltaAngle[n4] = this.binDeltaAngle[n4] + this.delta[y][x][1];
                        int n5 = i;
                        this.n[n5] = this.n[n5] + 1;
                        if (this.binMax[i] < this.psi[y][x]) {
                            this.binMax[i] = this.psi[y][x];
                        }
                        if (this.binMin[i] > this.psi[y][x]) {
                            this.binMin[i] = this.psi[y][x];
                        }
                    }
                    int n = i;
                    this.total[n] = this.total[n] + 1;
                }
                ++validSurface;
            }
        }
        float std = Math.abs((rangeStddev - (float)rangeN * (rangePsi /= (float)rangeN) * rangePsi) / (float)(rangeN - 1));
        rangeStddev = (float)Math.sqrt(std);
        float rangeDensity = (float)rangeN / (float)rangeS;
        IJ.log((String)("Average psi (0.0-" + rangeMax + "): " + IJ.d2s((double)rangePsi, (int)2) + " stddev: " + IJ.d2s((double)rangeStddev, (int)2) + " (" + IJ.d2s((double)(rangeDensity * 100.0f), (int)2) + "%) relative speed error: " + IJ.d2s((double)(rangeLength / (float)rangeN), (int)2)));
        for (i = 0; i < this.binNr; ++i) {
            if (this.n[i] > 0) {
                int n = i;
                this.binPsi[n] = this.binPsi[n] / (float)this.n[i];
                int n6 = i;
                this.binDeltaAngle[n6] = this.binDeltaAngle[n6] / (float)this.n[i];
                int n7 = i;
                this.binDeltaLength[n7] = this.binDeltaLength[n7] / (float)this.n[i];
                this.binStdDev[i] = this.n[i] > 1 ? (float)Math.sqrt(Math.abs((this.binStdDev[i] - (float)this.n[i] * this.binPsi[i] * this.binPsi[i]) / (float)(this.n[i] - 1))) : 0.0f;
            }
            this.density[i] = (float)this.n[i] / (float)validSurface;
        }
    }

    public void mapAverage(Graphics g) {
        int WIDTH = 257;
        int HEIGHT = 128;
        int BAR_HEIGHT = 12;
        int XMARGIN = 20;
        int YMARGIN = 10;
        float scaling = 0.7111111f;
        int xScale = 257 / this.binNr;
        Rectangle frame = new Rectangle(20, 10, 257, 128);
        g.drawRect(frame.x, frame.y, frame.width, frame.height);
        for (int i = 0; i < this.binNr; ++i) {
            g.drawLine(i * xScale + 20, 138, i * xScale + 20, 138 - (int)(this.binPsi[i] * scaling));
        }
        g.drawString("180\u00ba", 0, 10);
        int y = 158;
        g.drawString("0.0", xScale * 0 + 20, y);
        g.drawString("1.0", (int)((float)(xScale * 1) / this.binWidth) + 20, y);
        g.drawString("2.0", (int)((float)(xScale * 2) / this.binWidth) + 20, y);
        g.drawString("3.0", (int)((float)(xScale * 3) / this.binWidth) + 20, y);
        g.drawString("4.0", (int)((float)(xScale * 4) / this.binWidth) + 20, y);
        g.drawString("5.0", (int)((float)(xScale * 5) / this.binWidth) + 20, y);
        g.drawString("(" + IJ.d2s((double)this.binPsi[(int)(0.0f / this.binWidth)], (int)2) + "\u00ba)", (int)((float)(xScale * 0) / this.binWidth) + 20, y += 20);
        g.drawString("(" + IJ.d2s((double)this.binPsi[(int)(1.0f / this.binWidth)], (int)2) + "\u00ba)", (int)((float)(xScale * 1) / this.binWidth) + 20, y);
        g.drawString("(" + IJ.d2s((double)this.binPsi[(int)(2.0f / this.binWidth)], (int)2) + "\u00ba)", (int)((float)(xScale * 2) / this.binWidth) + 20, y);
        g.drawString("(" + IJ.d2s((double)this.binPsi[(int)(3.0f / this.binWidth)], (int)2) + "\u00ba)", (int)((float)(xScale * 3) / this.binWidth) + 20, y);
        g.drawString("(" + IJ.d2s((double)this.binPsi[(int)(4.0f / this.binWidth)], (int)2) + "\u00ba)", (int)((float)(xScale * 4) / this.binWidth) + 20, y);
        g.drawString("(" + IJ.d2s((double)this.binPsi[(int)(5.0f / this.binWidth)], (int)2) + "\u00ba)", (int)((float)(xScale * 5) / this.binWidth) + 20, y);
    }

    public void clipboard(PrintWriter pw) {
        pw.print("v-ang\tpsi " + this.flow.toString() + "\tstddev\tdelta l\tdelta angle\tdensity\n");
        for (int i = 0; i < this.binNr; ++i) {
            pw.print(IJ.d2s((double)((float)i * this.binWidth), (int)2) + "\t" + IJ.d2s((double)this.binPsi[i], (int)2) + "\t" + IJ.d2s((double)this.binStdDev[i], (int)2) + "\t" + IJ.d2s((double)this.binDeltaLength[i], (int)2) + "\t" + IJ.d2s((double)this.binDeltaAngle[i], (int)2) + "\t" + IJ.d2s((double)(this.density[i] * 100.0f), (int)3) + "%\n");
        }
    }
}

