/*
 * Decompiled with CFR 0.152.
 */
package registration;

import bijfit.Maximum;
import bijnum.BIJfht;
import bijnum.BIJmatrix;
import bijnum.BIJutil;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import registration.Register;
import volume.Equalize;

public class RegisterFFT
extends Register {
    protected BIJfht fht;
    protected float[] referencefft;
    protected int debug = 0;

    public RegisterFFT(float[] reference, int width) {
        ImagePlus mimp;
        IJ.showStatus((String)"Registering...equalizing reference image");
        if (this.debug == 1) {
            mimp = new ImagePlus("reference before equal", (ImageProcessor)new FloatProcessor(width, reference.length / width, reference, null));
            mimp.show();
        }
        reference = Equalize.sliding(reference, width, 0.0f, Equalize.getDefaultWindowSize(), true);
        if (this.debug == 1) {
            mimp = new ImagePlus("reference ", (ImageProcessor)new FloatProcessor(width, reference.length / width, reference, null));
            mimp.show();
            FileSaver fs = new FileSaver(mimp);
            fs.saveAsTiff("c:/" + mimp.getTitle() + ".tif");
        }
        this.referencefft = BIJutil.tile(reference, width);
        if (this.debug == 2) {
            new ImagePlus("reference_tile", (ImageProcessor)new FloatProcessor((int)Math.sqrt(this.referencefft.length), (int)Math.sqrt(this.referencefft.length), this.referencefft, null)).show();
        }
        this.fht = new BIJfht(this.referencefft.length);
        IJ.showStatus((String)"Registering...computing FFT of reference image");
        this.fht.compute(this.referencefft, false);
        this.width = width;
        this.mask = null;
    }

    public RegisterFFT(float[] reference, int width, float[] mask) {
        IJ.showStatus((String)"Registering...equalizing reference image");
        reference = Equalize.sliding(reference, width, 0.0f, Equalize.getDefaultWindowSize(), true);
        if (mask != null) {
            reference = BIJmatrix.mulElements(reference, mask);
        }
        if (this.debug == 1) {
            ImagePlus mimp = new ImagePlus("masked reference ", (ImageProcessor)new FloatProcessor(width, reference.length / width, reference, null));
            mimp.show();
            FileSaver fs = new FileSaver(mimp);
            fs.saveAsTiff("c:/" + mimp.getTitle() + ".tif");
        }
        this.referencefft = BIJutil.tile(reference, width);
        if (this.debug == 2) {
            new ImagePlus("reference_tile", (ImageProcessor)new FloatProcessor((int)Math.sqrt(this.referencefft.length), (int)Math.sqrt(this.referencefft.length), this.referencefft, null)).show();
        }
        this.fht = new BIJfht(this.referencefft.length);
        IJ.showStatus((String)"Registering...computing FFT of reference image");
        this.fht.compute(this.referencefft, false);
        this.width = width;
        this.mask = mask;
    }

    @Override
    public float[] register(float[] image) {
        image = Equalize.sliding(image, this.width, 0.0f, Equalize.getDefaultWindowSize(), true);
        if (this.mask != null) {
            image = BIJmatrix.mulElements(image, this.mask);
        }
        if (this.debug == 1) {
            ImagePlus mimp = new ImagePlus("(masked) image ", (ImageProcessor)new FloatProcessor(this.width, image.length / this.width, image, null));
            mimp.show();
            FileSaver fs = new FileSaver(mimp);
            fs.saveAsTiff("c:/" + mimp.getTitle() + ".tif");
        }
        float[] imagefft = BIJutil.tile(image, this.width);
        if (this.debug == 2) {
            new ImagePlus("image_tile", (ImageProcessor)new FloatProcessor((int)Math.sqrt(imagefft.length), (int)Math.sqrt(imagefft.length), imagefft, null)).show();
        }
        IJ.showStatus((String)"Registering...computing FFT");
        this.fht.compute(imagefft, false);
        IJ.showStatus((String)"Registering...computing inverse power spectrum");
        float[] icps = this.fht.crossPowerSpectrum(this.referencefft, imagefft);
        this.fht.compute(icps, true);
        float[] spectrum = this.fht.flipquad(icps);
        if (this.debug == 2) {
            new ImagePlus("Inverse cross power spectrum", (ImageProcessor)new FloatProcessor((int)Math.sqrt(spectrum.length), (int)Math.sqrt(spectrum.length), spectrum, null)).show();
        }
        float[] crosscorrelation = BIJutil.fit(spectrum, this.width, image.length / this.width);
        if (this.mask != null) {
            BIJmatrix.mulElements(crosscorrelation, this.mask);
        }
        this.estimate = Maximum.findSubpixel(crosscorrelation, this.width);
        if (this.debug == 2) {
            new ImagePlus("X corr", (ImageProcessor)new FloatProcessor(this.width, image.length / this.width, crosscorrelation, null)).show();
        }
        return this.estimate;
    }

    public String toString() {
        return "" + this.estimate[0] + "\t" + this.estimate[1] + "\t";
    }
}

