/*
 * Decompiled with CFR 0.152.
 */
package registration;

import bijnum.BIJmatrix;
import bijnum.BIJmi;
import ij.IJ;
import numericalMethods.function.nmDoubleArrayParametrized;
import numericalMethods.function.nmDoubleValued;
import volume.Transformer;

public class SearchMI
extends BIJmi
implements nmDoubleArrayParametrized,
nmDoubleValued {
    public float[] a;
    public float[] b;
    public int width;
    public double[] p;

    public SearchMI(float min, float max, float scale, float[] a, float[] b, int width) {
        super(min, max, scale);
        this.a = a;
        this.b = b;
        this.width = width;
    }

    @Override
    public int getDoubleArrayParameterLength() {
        return 3;
    }

    @Override
    public void setDoubleArrayParameter(double[] p, int offset) {
        this.p = p;
        if (offset != 0) {
            IJ.log((String)"HELP offset not 0".concat(String.valueOf(String.valueOf(offset))));
        }
    }

    @Override
    public double getDoubleValue() {
        return this.mi(this.p);
    }

    public double mi(double[] p) {
        double[] n = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            n[i] = p[i];
        }
        return this.mi(n);
    }

    public float mi(float[] p) {
        float ret = 3.402823E38f;
        if (p.length > 0 && Math.abs(p[0]) > (float)(this.width / 2)) {
            ret = Math.abs(10000.0f * p[0]);
        } else if (p.length > 1 && Math.abs(p[1]) > (float)(this.width / 2)) {
            ret = Math.abs(10000.0f * p[1]);
        } else if (p.length > 2 && Math.abs(p[2]) > 180.0f) {
            ret = Math.abs(10000.0f * p[2]);
        } else if (p.length > 3 && (p[3] >= 100.0f || (double)p[3] < 0.01)) {
            ret = Math.abs(10000.0f * p[3]);
        } else if (p.length > 4 && (p[4] >= 100.0f || (double)p[4] < 0.01)) {
            ret = Math.abs(10000.0f * p[4]);
        } else {
            float[][] m = Transformer.convertParametersIntoTransformationMatrix(p);
            ret = this.mi(this.a, this.b, this.width, m);
        }
        return ret;
    }

    protected float mi(float[] a, float[] b, int width, float[][] m) {
        this.zeroHistograms();
        this.n = 0;
        float[][] mi = null;
        try {
            mi = BIJmatrix.inverse(m);
        }
        catch (Exception e) {
            IJ.error((String)"mi error ".concat(String.valueOf(String.valueOf(e))));
            float f = 0.0f;
            return f;
        }
        int height = a.length / width;
        float[] coordinates = new float[3];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                coordinates[0] = x;
                coordinates[1] = y;
                coordinates[2] = 1.0f;
                float[] tv = null;
                try {
                    tv = BIJmatrix.mul(mi, coordinates);
                }
                catch (Exception e) {
                    IJ.error((String)"mi error ".concat(String.valueOf(String.valueOf(e))));
                    float f1 = 0.0f;
                    return f1;
                }
                int i = y * width + x;
                if (tv[0] < 0.0f || tv[0] >= (float)(width - 1) || tv[1] < 0.0f || tv[1] >= (float)(height - 1)) continue;
                float ai = a[i];
                float bi = Transformer.bilinear(b, width, tv[0], tv[1]);
                if (ai == Float.NaN || bi == Float.NaN) continue;
                int ix0 = Math.round((ai - this.min) * this.scale);
                int ix1 = Math.round((bi - this.min) * this.scale);
                if (ix0 >= this.Pu.length || ix1 >= this.Pv.length) {
                    IJ.error((String)String.valueOf(String.valueOf(new StringBuffer("mi: array index out of bounds ix0=").append(ix0).append(" ix1= ").append(ix1).append(" ai=").append(ai).append(" bi=").append(bi))));
                }
                if (ix0 < 0 || ix1 < 0) {
                    IJ.error((String)String.valueOf(String.valueOf(new StringBuffer("mi: array index underflow ix0=").append(ix0).append(" ix1= ").append(ix1).append(" ai=").append(ai).append(" bi=").append(bi))));
                }
                if (ix0 < 0 || ix1 < 0) continue;
                int n = ix0;
                this.Pu[n] = this.Pu[n] + 1;
                int n2 = ix1;
                this.Pv[n2] = this.Pv[n2] + 1;
                int n3 = ix0 * this.bins + ix1;
                this.Puv[n3] = this.Puv[n3] + 1;
                ++this.n;
            }
        }
        return this.computeProbs(this.n);
    }
}

