/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kalman;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.SegmentTracker;
import fiji.plugin.trackmate.tracking.kalman.KalmanTracker;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.algorithm.Benchmark;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Cancelable;

public class AdvancedKalmanTracker
implements SpotTracker,
Benchmark,
Cancelable {
    private static final String BASE_ERROR_MSG = "[AdvancedKalmanTracker] ";
    private SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph;
    private String errorMessage;
    private Logger logger = Logger.VOID_LOGGER;
    private final SpotCollection spots;
    protected final Map<String, Object> settings;
    private long processingTime;
    private boolean isCanceled;
    private String cancelReason;

    public AdvancedKalmanTracker(SpotCollection spots, Map<String, Object> settings) {
        this.spots = spots;
        this.settings = settings;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return this.graph;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        this.isCanceled = false;
        this.cancelReason = null;
        StringBuilder errorHolder = new StringBuilder();
        HashMap<String, Object> kalSettings = new HashMap<String, Object>();
        kalSettings.put("KALMAN_SEARCH_RADIUS", this.settings.get("KALMAN_SEARCH_RADIUS"));
        kalSettings.put("LINKING_MAX_DISTANCE", this.settings.get("LINKING_MAX_DISTANCE"));
        kalSettings.put("MAX_FRAME_GAP", this.settings.get("MAX_FRAME_GAP"));
        kalSettings.put("LINKING_FEATURE_PENALTIES", this.settings.get("LINKING_FEATURE_PENALTIES"));
        if (!this.checkSettingsValidity(kalSettings, errorHolder)) {
            this.errorMessage = BASE_ERROR_MSG + errorHolder.toString();
            return false;
        }
        double maxSearchRadius = (Double)kalSettings.get("KALMAN_SEARCH_RADIUS");
        double initialSearchRadius = (Double)kalSettings.get("LINKING_MAX_DISTANCE");
        int maxFrameGap = (Integer)kalSettings.get("MAX_FRAME_GAP");
        Map featurePenalties = (Map)kalSettings.get("LINKING_FEATURE_PENALTIES");
        KalmanTracker kalmanTracker = new KalmanTracker(this.spots, maxSearchRadius, maxFrameGap, initialSearchRadius, featurePenalties);
        kalmanTracker.setLogger(this.logger);
        if (!kalmanTracker.checkInput() || !kalmanTracker.process()) {
            this.errorMessage = kalmanTracker.getErrorMessage();
            return false;
        }
        this.graph = kalmanTracker.getResult();
        SegmentTracker segmentLinker = new SegmentTracker(this.graph, this.settings, this.logger);
        if (!segmentLinker.checkInput() || !segmentLinker.process()) {
            this.errorMessage = segmentLinker.getErrorMessage();
            return false;
        }
        this.processingTime = System.currentTimeMillis() - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setNumThreads() {
    }

    public void setNumThreads(int numThreads) {
    }

    public int getNumThreads() {
        return 1;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected boolean checkSettingsValidity(Map<String, Object> settings, StringBuilder str) {
        if (null == settings) {
            str.append("Settings map is null.\n");
            return false;
        }
        boolean ok = true;
        StringBuilder errorHolder = new StringBuilder();
        ok &= TMUtils.checkParameter(settings, "LINKING_MAX_DISTANCE", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "KALMAN_SEARCH_RADIUS", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "MAX_FRAME_GAP", Integer.class, errorHolder);
        ok &= LAPUtils.checkFeatureMap(settings, "LINKING_FEATURE_PENALTIES", errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("KALMAN_SEARCH_RADIUS");
        mandatoryKeys.add("LINKING_MAX_DISTANCE");
        mandatoryKeys.add("MAX_FRAME_GAP");
        ArrayList<String> optionalKeys = new ArrayList<String>();
        optionalKeys.add("LINKING_FEATURE_PENALTIES");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, optionalKeys, str);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

