/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.gui.displaysettings.StyleElements;
import fiji.plugin.trackmate.util.DetectionPreview;
import fiji.plugin.trackmate.util.DetectionPreviewPanel;
import fiji.plugin.trackmate.util.cli.Configurator;
import fiji.plugin.trackmate.util.cli.GenericConfigurationPanel;
import fiji.plugin.trackmate.util.cli.HasInteractivePreview;
import java.awt.Component;
import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import javax.swing.Icon;

public class GenericDetectionConfigurationPanel
extends GenericConfigurationPanel {
    private static final long serialVersionUID = 1L;

    public GenericDetectionConfigurationPanel(Settings settings, Model model, Configurator config, String title, Icon icon, String docURL, Supplier<SpotDetectorFactoryBase<?>> factorySupplier) {
        super(config, title, icon, docURL);
        DetectionPreview detectionPreview = this.getDetectionPreview(model, settings, factorySupplier);
        DetectionPreviewPanel p = detectionPreview.getPanel();
        this.add((Component)p, "South");
    }

    protected DetectionPreview getDetectionPreview(Model model, Settings settings, Supplier<SpotDetectorFactoryBase<?>> factorySupplier) {
        DetectionPreview.Builder builder = DetectionPreview.create().model(model).settings(settings).detectorFactory(factorySupplier.get()).detectionSettingsSupplier(() -> this.getSettings());
        if (this.config instanceof HasInteractivePreview) {
            HasInteractivePreview hasPreview = (HasInteractivePreview)((Object)this.config);
            String key = hasPreview.getPreviewArgumentKey();
            builder.thresholdKey(key);
            if (key != null) {
                DoubleConsumer thresholdUpdater;
                StyleElements.StyleElement element = this.mainPanel.elements.get(key);
                if (element instanceof StyleElements.DoubleElement) {
                    thresholdUpdater = t -> {
                        ((StyleElements.DoubleElement)element).set(t);
                        this.mainPanel.refresh();
                    };
                } else if (element instanceof StyleElements.BoundedDoubleElement) {
                    thresholdUpdater = t -> {
                        ((StyleElements.BoundedDoubleElement)element).set(t);
                        this.mainPanel.refresh();
                    };
                } else if (element instanceof StyleElements.IntElement) {
                    StyleElements.IntElement el = (StyleElements.IntElement)element;
                    thresholdUpdater = t -> {
                        el.set((int)t);
                        this.mainPanel.refresh();
                    };
                } else {
                    throw new IllegalStateException("Cannot create interactive thresholding preview for arguments that map of an element of class: " + String.valueOf(element.getClass().getDeclaringClass()));
                }
                builder.thresholdUpdater(thresholdUpdater);
            }
            builder.axisLabel(hasPreview.getPreviewAxisLabel());
        }
        return builder.get();
    }
}

