/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.model.mxCell;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxCellEditor;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import fiji.plugin.trackmate.visualization.trackscheme.mxScaledLabelShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class TrackSchemeGraphComponent
extends mxGraphComponent
implements mxEventSource.mxIEventListener {
    private static final long serialVersionUID = -1L;
    private static final int MAX_DECCORATION_LEVELS = 2;
    int[] columnWidths = new int[0];
    Integer[] columnTrackIDs;
    private final TrackScheme trackScheme;
    private int paintDecorationLevel = 1;
    private boolean spaceDown = false;
    private final DisplaySettings ds;

    public TrackSchemeGraphComponent(JGraphXAdapter graph, TrackScheme trackScheme, DisplaySettings ds) {
        super((mxGraph)graph);
        this.trackScheme = trackScheme;
        this.ds = ds;
        this.getViewport().setOpaque(true);
        this.getViewport().setBackground(ds.getTrackSchemeBackgroundColor1());
        this.setZoomFactor(2.0);
        this.connectionHandler.addListener("connect", (mxEventSource.mxIEventListener)this);
        mxGraphics2DCanvas.putShape((String)"scaledLabel", (mxIShape)new mxScaledLabelShape());
        this.setRowHeaderView(new RowHeader());
        this.setColumnHeaderView(new ColumnHeader());
        this.setCorner("UPPER_LEFT_CORNER", new TopLeftCorner());
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TrackSchemeGraphComponent.this.spaceDown = false;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && !TrackSchemeGraphComponent.this.spaceDown) {
                    TrackSchemeGraphComponent.this.spaceDown = true;
                }
            }
        });
    }

    public JGraphXAdapter getGraph() {
        return (JGraphXAdapter)super.getGraph();
    }

    public boolean isToggleEvent(MouseEvent event) {
        return event.isShiftDown();
    }

    public boolean isPanningEvent(MouseEvent event) {
        return this.spaceDown;
    }

    protected mxICellEditor createCellEditor() {
        mxCellEditor editor = new mxCellEditor(this, this){

            public void startEditing(Object cell, EventObject evt) {
                this.textArea.setOpaque(true);
                this.textArea.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 1));
                super.startEditing(cell, evt);
            }
        };
        editor.setShiftEnterSubmitsText(true);
        return editor;
    }

    protected mxGraphHandler createGraphHandler() {
        return new mxGraphHandler(this, this){

            public void mousePressed(MouseEvent e) {
                if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed() && !this.graphComponent.isForceMarqueeEvent(e)) {
                    this.initialCell = this.cell = this.graphComponent.getCellAt(e.getX(), e.getY(), false);
                    if (this.cell != null) {
                        if (this.isSelectEnabled() && !this.graphComponent.getGraph().isCellSelected(this.cell)) {
                            this.graphComponent.selectCellForEvent(this.cell, e);
                            this.cell = null;
                        }
                        if (this.isMoveEnabled() && !e.isPopupTrigger()) {
                            this.start(e);
                            e.consume();
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed()) {
                    mxGraph lGraph = this.graphComponent.getGraph();
                    double dx = 0.0;
                    double dy = 0.0;
                    if (this.first != null && (this.cellBounds != null || this.movePreview.isActive())) {
                        double scale = lGraph.getView().getScale();
                        mxPoint trans = lGraph.getView().getTranslate();
                        dx = e.getX() - this.first.x;
                        dy = e.getY() - this.first.y;
                        if (this.cellBounds != null) {
                            double dxg = (this.cellBounds.getX() + dx) / scale - trans.getX();
                            double dyg = (this.cellBounds.getY() + dy) / scale - trans.getY();
                            double x = (dxg + trans.getX()) * scale + this.bbox.getX() - this.cellBounds.getX();
                            double y = (dyg + trans.getY()) * scale + this.bbox.getY() - this.cellBounds.getY();
                            dx = Math.round((x - this.bbox.getX()) / scale);
                            dy = Math.round((y - this.bbox.getY()) / scale);
                        }
                    }
                    if (this.first == null || !this.graphComponent.isSignificant((double)(e.getX() - this.first.x), (double)(e.getY() - this.first.y))) {
                        if (!(this.cell == null || e.isPopupTrigger() || !this.isSelectEnabled() || this.first == null && this.isMoveEnabled())) {
                            this.graphComponent.selectCellForEvent(this.cell, e);
                        }
                        if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(this.initialCell, e.getX(), e.getY())) {
                            this.fold(this.initialCell);
                        } else {
                            Object tmp = this.graphComponent.getCellAt(e.getX(), e.getY(), this.graphComponent.isSwimlaneSelectionEnabled());
                            if (this.cell == null && this.first == null) {
                                if (tmp == null && e.getButton() == 1) {
                                    lGraph.clearSelection();
                                } else if (lGraph.isSwimlane(tmp) && this.graphComponent.getCanvas().hitSwimlaneContent(this.graphComponent, lGraph.getView().getState(tmp), e.getX(), e.getY())) {
                                    this.graphComponent.selectCellForEvent(tmp, e);
                                }
                            }
                            if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(tmp, e.getX(), e.getY())) {
                                this.fold(tmp);
                                e.consume();
                            }
                        }
                    } else if (this.movePreview.isActive()) {
                        boolean clone;
                        Object[] result;
                        mxCellState markedState;
                        Object target;
                        if (this.graphComponent.isConstrainedEvent(e)) {
                            if (Math.abs(dx) > Math.abs(dy)) {
                                dy = 0.0;
                            } else {
                                dx = 0.0;
                            }
                        }
                        Object object = target = (markedState = this.marker.getMarkedState()) != null ? markedState.getCell() : null;
                        if (target == null && this.isRemoveCellsFromParent() && this.shouldRemoveCellFromParent(lGraph.getModel().getParent(this.initialCell), this.cells, e)) {
                            target = lGraph.getDefaultParent();
                        }
                        if (this.cells != (result = this.movePreview.stop(true, e, dx, dy, clone = this.isCloneEnabled() && this.graphComponent.isCloneEvent(e), target))) {
                            lGraph.setSelectionCells(result);
                        }
                        e.consume();
                    } else if (this.isVisible()) {
                        mxCellState targetState;
                        Object target;
                        if (this.constrainedEvent) {
                            if (Math.abs(dx) > Math.abs(dy)) {
                                dy = 0.0;
                            } else {
                                dx = 0.0;
                            }
                        }
                        Object object = target = (targetState = this.marker.getValidState()) != null ? targetState.getCell() : null;
                        if (lGraph.isSplitEnabled() && lGraph.isSplitTarget(target, this.cells)) {
                            lGraph.splitEdge(target, this.cells, dx, dy);
                        } else {
                            this.moveCells(this.cells, dx, dy, target, e);
                        }
                        e.consume();
                    }
                }
                this.reset();
            }
        };
    }

    public void paintBackground(Graphics g) {
        if (this.paintDecorationLevel == 0) {
            return;
        }
        int width = this.getViewport().getView().getSize().width;
        int height = this.getViewport().getView().getSize().height;
        double scale = this.graph.getView().getScale();
        Graphics2D g2d = (Graphics2D)g;
        g.setFont(this.ds.getFont().deriveFont((float)(12.0 * scale)));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.ds.getUseAntialiasing() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle paintBounds = g.getClipBounds();
        double xcs = 160.0 * scale;
        double ycs = 96.0 * scale;
        if (this.paintDecorationLevel > 1) {
            g.setColor(this.ds.getTrackSchemeBackgroundColor2());
            for (double y = 0.0; y < (double)height; y += 2.0 * ycs) {
                if (!(y > (double)paintBounds.y - ycs) || !(y < (double)(paintBounds.y + paintBounds.height))) continue;
                g.fillRect(0, (int)y, width, (int)ycs);
            }
        }
        if (this.paintDecorationLevel > 0) {
            double x = xcs;
            if (null != this.columnWidths) {
                g.setColor(this.ds.getTrackSchemeDecorationColor());
                for (int i = 0; i < this.columnWidths.length; ++i) {
                    int cw = this.columnWidths[i];
                    g.drawLine((int)(x += (double)cw * xcs), 0, (int)x, height);
                }
            }
        }
        this.getColumnHeader().revalidate();
        this.getRowHeader().revalidate();
        this.getCorner("UPPER_LEFT_CORNER").revalidate();
    }

    public void invoke(Object sender, mxEventObject evt) {
        Map props = evt.getProperties();
        Object obj = props.get("cell");
        mxCell cell = (mxCell)obj;
        this.trackScheme.addEdgeManually(cell);
        evt.consume();
    }

    public void zoomTo(double newScale, boolean center) {
        mxGraphView view = this.graph.getView();
        double scale = view.getScale();
        mxPoint translate = this.pageVisible && this.centerPage ? this.getPageTranslate(newScale) : new mxPoint();
        this.graph.getView().scaleAndTranslate(newScale, translate.getX(), translate.getY());
        if (this.keepSelectionVisibleOnZoom && !this.graph.isSelectionEmpty()) {
            this.getGraphControl().scrollRectToVisible(view.getBoundingBox(this.graph.getSelectionCells()).getRectangle());
        } else {
            this.maintainScrollBar(true, newScale / scale, center);
            this.maintainScrollBar(false, newScale / scale, center);
        }
    }

    public void loopPaintDecorationLevel() {
        if (this.paintDecorationLevel++ >= 2) {
            this.paintDecorationLevel = 0;
        }
        this.repaint();
    }

    private class RowHeader
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RowHeader() {
            this.setOpaque(true);
            this.setBackground(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
            this.setToolTipText("Row header tooltip");
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point point = event.getPoint();
            double scale = TrackSchemeGraphComponent.this.graph.getView().getScale();
            int frame = (int)((double)point.y / (96.0 * scale));
            return "frame " + frame;
        }

        @Override
        public void paint(Graphics g) {
            double y;
            Graphics2D g2d = (Graphics2D)g;
            double scale = TrackSchemeGraphComponent.this.graph.getView().getScale();
            float fontScale = (float)(12.0 * Math.min(1.0, scale));
            fontScale = Math.max(fontScale, 4.0f);
            g.setFont(TrackSchemeGraphComponent.this.ds.getFont().deriveFont(fontScale));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, TrackSchemeGraphComponent.this.ds.getUseAntialiasing() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            Rectangle paintBounds = g.getClipBounds();
            int height = ((TrackSchemeGraphComponent)TrackSchemeGraphComponent.this).viewport.getView().getSize().height;
            double xcs = 160.0 * Math.min(1.0, scale);
            double ycs = 96.0 * scale;
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
            g.fillRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
            if (TrackSchemeGraphComponent.this.paintDecorationLevel > 1) {
                g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor2());
                for (y = 0.0; y < (double)height; y += 2.0 * ycs) {
                    if (!(y > (double)paintBounds.y - ycs) || !(y < (double)(paintBounds.y + paintBounds.height))) continue;
                    g.fillRect(0, (int)y, (int)xcs, (int)ycs);
                }
            }
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeDecorationColor());
            if (xcs > (double)paintBounds.x && xcs < (double)(paintBounds.x + paintBounds.width)) {
                g.drawLine((int)xcs, paintBounds.y, (int)xcs, paintBounds.y + paintBounds.height);
            }
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeForegroundColor());
            double x = xcs / 4.0;
            if (xcs > (double)paintBounds.x) {
                for (y = ycs / 2.0; y < (double)height; y += ycs) {
                    if (!(y > (double)paintBounds.y - ycs) || !(y < (double)(paintBounds.y + paintBounds.height))) continue;
                    int frame = (int)(y / ycs);
                    g.drawString(String.format("frame %d", frame), (int)x, (int)Math.round(y + 12.0 * scale));
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            double scale = Math.min(1.0, TrackSchemeGraphComponent.this.graph.getView().getScale());
            double xcs = 160.0 * scale + 1.0;
            return new Dimension((int)xcs, (int)TrackSchemeGraphComponent.this.viewport.getPreferredSize().getHeight());
        }
    }

    private class ColumnHeader
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ColumnHeader() {
            this.setLayout(null);
            this.setOpaque(true);
            this.setBackground(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
            this.setToolTipText("Column header tool tip");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() != 2) {
                        return;
                    }
                    int x = event.getPoint().x;
                    float scale = (float)TrackSchemeGraphComponent.this.graph.getView().getScale();
                    int xcs = Math.round(160.0f * scale);
                    int ycs = Math.min(96, Math.round(96.0f * scale));
                    if (null != TrackSchemeGraphComponent.this.columnWidths) {
                        int cw;
                        int column;
                        int xc = xcs;
                        for (column = 0; column < TrackSchemeGraphComponent.this.columnWidths.length && x >= (xc += (cw = TrackSchemeGraphComponent.this.columnWidths[column]) * xcs); ++column) {
                        }
                        if (column >= TrackSchemeGraphComponent.this.columnWidths.length) {
                            return;
                        }
                        String oldName = TrackSchemeGraphComponent.this.trackScheme.getModel().getTrackModel().name(TrackSchemeGraphComponent.this.columnTrackIDs[column]);
                        final Integer trackID = TrackSchemeGraphComponent.this.columnTrackIDs[column];
                        int cwidth = TrackSchemeGraphComponent.this.columnWidths[column] * xcs;
                        if (column == 0) {
                            cwidth += xcs;
                        }
                        Rectangle paintBounds = ColumnHeader.this.getVisibleRect();
                        int minx = Math.max(xc - cwidth, paintBounds.x);
                        int maxx = Math.min(xc, paintBounds.x + paintBounds.width);
                        cwidth = Math.min(cwidth, maxx - minx);
                        final JScrollPane scrollPane = new JScrollPane();
                        scrollPane.getViewport().setOpaque(false);
                        scrollPane.setVisible(false);
                        scrollPane.setOpaque(false);
                        scrollPane.setBounds(minx, 0, maxx - minx, ycs);
                        scrollPane.setVisible(true);
                        final JTextField textArea = new JTextField(oldName);
                        textArea.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
                        textArea.setOpaque(true);
                        textArea.setBackground(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
                        textArea.setHorizontalAlignment(0);
                        float fontScale = (float)(12.0 * Math.min(1.0, (double)scale));
                        fontScale = Math.max(fontScale, 4.0f);
                        textArea.setFont(TrackSchemeGraphComponent.this.ds.getFont().deriveFont(fontScale).deriveFont(1));
                        textArea.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                if (TrackSchemeGraphComponent.this.trackScheme.getModel().getTrackModel().unsortedTrackIDs(false).contains(trackID)) {
                                    String newname = textArea.getText();
                                    TrackSchemeGraphComponent.this.trackScheme.getModel().getTrackModel().setName(trackID, newname);
                                }
                                scrollPane.remove(textArea);
                                ColumnHeader.this.remove(scrollPane);
                                TrackSchemeGraphComponent.this.repaint();
                            }
                        });
                        scrollPane.setViewportView(textArea);
                        ColumnHeader.this.add(scrollPane);
                        textArea.revalidate();
                        textArea.requestFocusInWindow();
                        textArea.selectAll();
                    }
                }
            });
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point point = event.getPoint();
            double scale = TrackSchemeGraphComponent.this.graph.getView().getScale();
            if (null != TrackSchemeGraphComponent.this.columnWidths) {
                String columnName;
                double xcs;
                int cw;
                int index = 0;
                for (double x = xcs = 160.0 * scale; x < (double)point.x; x += (double)cw * xcs) {
                    if (index >= TrackSchemeGraphComponent.this.columnTrackIDs.length) {
                        return "Single spots";
                    }
                    cw = TrackSchemeGraphComponent.this.columnWidths[index++];
                }
                if (index == 0) {
                    index = 1;
                }
                if (null == (columnName = TrackSchemeGraphComponent.this.trackScheme.getModel().getTrackModel().name(TrackSchemeGraphComponent.this.columnTrackIDs[index - 1]))) {
                    columnName = "Name not set";
                }
                return columnName;
            }
            return "";
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            double scale = TrackSchemeGraphComponent.this.graph.getView().getScale();
            float fontScale = (float)(12.0 * Math.min(1.0, scale));
            fontScale = Math.max(fontScale, 4.0f);
            g.setFont(TrackSchemeGraphComponent.this.ds.getFont().deriveFont(fontScale));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle paintBounds = g.getClipBounds();
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
            g.fillRect(paintBounds.x, paintBounds.y, paintBounds.x + paintBounds.width, paintBounds.height);
            double xcs = 160.0 * scale;
            double ycs = 96.0 * Math.min(1.0, scale);
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeDecorationColor());
            g.drawLine(paintBounds.x, (int)ycs, paintBounds.x + paintBounds.width, (int)ycs);
            double x = xcs;
            if (null != TrackSchemeGraphComponent.this.columnWidths) {
                for (int i = 0; i < TrackSchemeGraphComponent.this.columnWidths.length; ++i) {
                    double minx = i == 0 ? 0.0 : x;
                    int cw = TrackSchemeGraphComponent.this.columnWidths[i];
                    double maxx = x + (double)cw * xcs;
                    x += (double)cw * xcs;
                    if (minx > (double)(paintBounds.x + paintBounds.width) || maxx < (double)paintBounds.x) continue;
                    String columnName = TrackSchemeGraphComponent.this.trackScheme.getModel().getTrackModel().name(TrackSchemeGraphComponent.this.columnTrackIDs[i]);
                    if (null == columnName) {
                        columnName = "Name not set";
                    }
                    double xstr1 = Math.max(minx, (double)paintBounds.x);
                    double xstr2 = Math.min(maxx, (double)(paintBounds.x + paintBounds.width));
                    int stringWidth = g.getFontMetrics().stringWidth(columnName);
                    double xstr = (xstr1 + xstr2 - (double)stringWidth) / 2.0;
                    xstr = Math.max(minx + 5.0, xstr);
                    xstr = Math.min(maxx - (double)stringWidth - 5.0, xstr);
                    g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeForegroundColor());
                    g.drawString(columnName, (int)xstr, (int)(ycs / 2.0));
                    g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeDecorationColor());
                    g.drawLine((int)x, 0, (int)x, (int)ycs);
                }
            }
            g.setColor(Color.decode("#FF00FF"));
            g.drawString("Single spots", (int)(x + 20.0), (int)(ycs / 2.0));
        }

        @Override
        public Dimension getPreferredSize() {
            double scale = Math.min(1.0, TrackSchemeGraphComponent.this.graph.getView().getScale());
            double ycs = 96.0 * scale + 1.0;
            int width = TrackSchemeGraphComponent.this.getViewport().getView().getSize().width;
            return new Dimension(width, (int)ycs);
        }
    }

    private class TopLeftCorner
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public TopLeftCorner() {
            this.setOpaque(true);
            this.setBackground(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
        }

        @Override
        public void paint(Graphics g) {
            double scale = TrackSchemeGraphComponent.this.graph.getView().getScale();
            double xcs = 160.0 * Math.min(1.0, scale);
            double ycs = 96.0 * Math.min(1.0, scale);
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeBackgroundColor1());
            g.fillRect(0, 0, (int)xcs, (int)ycs);
            g.setColor(TrackSchemeGraphComponent.this.ds.getTrackSchemeDecorationColor());
            g.drawLine(0, (int)ycs, (int)xcs, (int)ycs);
            g.drawLine((int)xcs, 0, (int)xcs, (int)ycs);
        }
    }
}

