/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.ij.export.tiles.CellVoyagerDataExporter;
import bdv.ij.util.PluginHelper;
import bdv.ij.util.ProgressWriterIJ;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Deprecated>Export CellVoyager dataset as XML/HDF5")
public class ExportCellVoyagerPlugIn
implements Command {
    static String lastSubsampling = "{1,1,1}, {2,2,1}, {4,4,1}, {8,8,2}";
    static String lastChunkSizes = "{32,32,4}, {16,16,8}, {8,8,4}, {16, 16, 16}";
    static String lastExportPath;
    static String sourceFolderStr;
    private String sourcePath;

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void run() {
        Parameters params;
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if ((params = this.getParameters(this.sourcePath)) == null) {
            return;
        }
        File measurementFolder = params.sourceFolder;
        File imageIndexFile = new File(measurementFolder, "ImageIndex.xml");
        File measurementSettingFile = new File(measurementFolder, "MeasurementSetting.xml");
        CellVoyagerDataExporter exporter = new CellVoyagerDataExporter(measurementSettingFile, imageIndexFile);
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        exporter.export(params.seqFile, params.hdf5File, params.resolutions, params.subdivisions, progressWriter);
    }

    protected Parameters getParameters(String sourcePathStr) {
        File seqFile;
        String seqFilename;
        File sourceFolder;
        int[][] subdivisions;
        int[][] resolutions;
        while (true) {
            File parent;
            GenericDialogPlus gd = new GenericDialogPlus("CellVoyager Import");
            gd.addStringField("Subsampling factors", lastSubsampling, 25);
            gd.addStringField("Hdf5 chunk sizes", lastChunkSizes, 25);
            gd.addMessage("");
            if (null == sourcePathStr) {
                if (null == sourceFolderStr) {
                    File folder = new File(System.getProperty("user.dir")).getParentFile().getParentFile();
                    sourceFolderStr = folder.getAbsolutePath();
                }
            } else {
                sourceFolderStr = sourcePathStr;
            }
            ExportCellVoyagerPlugIn.addBrowseToCellVoyagerFolder(gd, "Measurement folder", sourceFolderStr, 25);
            if (null == lastExportPath) {
                File sourceFile = new File(sourceFolderStr);
                String parentFolder = sourceFile.getParent();
                lastExportPath = new File(parentFolder, "export.xml").getAbsolutePath();
            }
            PluginHelper.addSaveAsFileField(gd, "Export to", lastExportPath, 25);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastSubsampling = gd.getNextString();
            lastChunkSizes = gd.getNextString();
            sourceFolderStr = gd.getNextString();
            lastExportPath = gd.getNextString();
            resolutions = PluginHelper.parseResolutionsString(lastSubsampling);
            subdivisions = PluginHelper.parseResolutionsString(lastChunkSizes);
            if (resolutions.length == 0) {
                IJ.showMessage((String)("Cannot parse subsampling factors: " + lastSubsampling));
                continue;
            }
            if (subdivisions.length == 0) {
                IJ.showMessage((String)("Cannot parse hdf5 chunk sizes: " + lastChunkSizes));
                continue;
            }
            if (resolutions.length != subdivisions.length) {
                IJ.showMessage((String)"Subsampling factors and hdf5 chunk sizes must have the same number of elements.");
                continue;
            }
            sourceFolder = new File(sourceFolderStr);
            seqFilename = lastExportPath;
            if (!seqFilename.endsWith(".xml")) {
                seqFilename = seqFilename + ".xml";
            }
            if ((parent = (seqFile = new File(seqFilename)).getParentFile()) != null && parent.exists() && parent.isDirectory()) break;
            IJ.showMessage((String)("Invalid export filename " + seqFilename));
        }
        String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
        File hdf5File = new File(hdf5Filename);
        return new Parameters(resolutions, subdivisions, sourceFolder, seqFile, hdf5File);
    }

    public static void addBrowseToCellVoyagerFolder(GenericDialogPlus dialog, String label, String defaultPath, int columns) {
        dialog.addStringField(label, defaultPath, columns);
        TextField text = (TextField)dialog.getStringFields().lastElement();
        GridBagLayout layout = (GridBagLayout)dialog.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        Button button = new Button("Browse...");
        ChooseCellVoyagerDirListener listener = new ChooseCellVoyagerDirListener(text);
        button.addActionListener(listener);
        button.addKeyListener((KeyListener)dialog);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        dialog.add((Component)panel);
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        ExportCellVoyagerPlugIn plugin = new ExportCellVoyagerPlugIn();
        File file = new File("/Users/tinevez/Desktop/Data/1_7_6_1_2/20130703T145244/");
        plugin.setSourcePath(file.getAbsolutePath());
        plugin.run();
    }

    private static class ChooseCellVoyagerDirListener
    implements ActionListener {
        TextField text;

        public ChooseCellVoyagerDirListener(TextField text) {
            this.text = text;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File directory;
            for (directory = new File(this.text.getText()); directory != null && !directory.exists(); directory = directory.getParentFile()) {
            }
            JFileChooser fc = new JFileChooser(directory);
            fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "CellVoyager measurement folder";
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        File[] files = f.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.equals("MeasurementSetting.xml");
                            }
                        });
                        return files.length > 0;
                    }
                    return false;
                }
            });
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(null);
            if (returnVal == 0) {
                String f = fc.getSelectedFile().getAbsolutePath();
                this.text.setText(f);
            }
        }
    }

    protected static class Parameters {
        final int[][] resolutions;
        final int[][] subdivisions;
        final File seqFile;
        final File hdf5File;
        final File sourceFolder;

        public Parameters(int[][] resolutions, int[][] subdivisions, File sourceFile, File seqFile, File hdf5File) {
            this.resolutions = resolutions;
            this.subdivisions = subdivisions;
            this.sourceFolder = sourceFile;
            this.seqFile = seqFile;
            this.hdf5File = hdf5File;
        }
    }
}

