/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.machine.JavaType;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EvD1D;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLDL;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillMatchingDual;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HouseholderHermitian;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyNeither;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveDenseStore
extends Primitive64Array
implements PhysicalStore<Double>,
DecompositionStore<Double> {
    public static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = new PhysicalStore.Factory<Double, PrimitiveDenseStore>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public DenseArray.Factory<Double> array() {
            return Primitive64Array.FACTORY;
        }

        @Override
        public MatrixStore.Factory<Double> builder() {
            return MatrixStore.PRIMITIVE;
        }

        @Override
        public PrimitiveDenseStore columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn.doubleValue(i);
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn[i];
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore columns(List<? extends Number> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn.get(i).doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore columns(Number[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn[i].doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore conjugate(Access2D<?> source) {
            return this.transpose((Access2D)source);
        }

        @Override
        public PrimitiveDenseStore copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final PrimitiveDenseStore retVal = new PrimitiveDenseStore(tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.copy(retVal.data, tmpRowDim, aFirst, aLimit, (Access2D<? extends Number>)source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.copy(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public PrimitiveDenseStore makeEye(long rows, long columns) {
            PrimitiveDenseStore retVal = this.makeZero(rows, columns);
            retVal.myUtility.fillDiagonal(0L, 0L, PrimitiveMath.ONE);
            return retVal;
        }

        @Override
        public PrimitiveDenseStore makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            int tmpRowDim = (int)rows;
            int tmpColDim = (int)columns;
            int tmpLength = tmpRowDim * tmpColDim;
            double[] tmpData = new double[tmpLength];
            for (int i = 0; i < tmpLength; ++i) {
                tmpData[i] = supplier.doubleValue();
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        public Householder.Primitive makeHouseholder(int length) {
            return new Householder.Primitive(length);
        }

        public Rotation.Primitive makeRotation(int low, int high, double cos, double sin) {
            return new Rotation.Primitive(low, high, cos, sin);
        }

        public Rotation.Primitive makeRotation(int low, int high, Double cos, Double sin) {
            return this.makeRotation(low, high, cos != null ? cos : Double.NaN, sin != null ? sin : Double.NaN);
        }

        @Override
        public PrimitiveDenseStore makeZero(long rows, long columns) {
            return new PrimitiveDenseStore((int)rows, (int)columns);
        }

        @Override
        public PrimitiveDenseStore rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow.doubleValue(j);
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow[j];
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore rows(List<? extends Number> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow.get(j).doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore rows(Number[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow[j].doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        public PrimitiveDenseStore transpose(final Access2D<?> source) {
            final PrimitiveDenseStore retVal = new PrimitiveDenseStore((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose(retVal.data, tmpRowDim, first, limit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }
    };
    static final long ELEMENT_SIZE = JavaType.DOUBLE.memory();
    static final long SHALLOW_SIZE = MemoryEstimator.estimateObject(PrimitiveDenseStore.class);
    private final PrimitiveMultiplyBoth multiplyBoth;
    private final PrimitiveMultiplyLeft multiplyLeft;
    private final PrimitiveMultiplyNeither multiplyNeither;
    private final PrimitiveMultiplyRight multiplyRight;
    private final int myColDim;
    private final int myRowDim;
    private final Array2D<Double> myUtility;
    private transient double[] myWorkerColumn;

    static PrimitiveDenseStore cast(Access1D<Double> matrix) {
        if (matrix instanceof PrimitiveDenseStore) {
            return (PrimitiveDenseStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return (PrimitiveDenseStore)FACTORY.copy((Access2D)matrix);
        }
        return (PrimitiveDenseStore)FACTORY.columns(matrix);
    }

    static Householder.Primitive cast(Householder<Double> transformation) {
        if (transformation instanceof Householder.Primitive) {
            return (Householder.Primitive)transformation;
        }
        if (transformation instanceof HouseholderReference) {
            return ((Householder.Primitive)((HouseholderReference)transformation).getWorker(FACTORY)).copy(transformation);
        }
        return new Householder.Primitive(transformation);
    }

    static Rotation.Primitive cast(Rotation<Double> transformation) {
        if (transformation instanceof Rotation.Primitive) {
            return (Rotation.Primitive)transformation;
        }
        return new Rotation.Primitive(transformation);
    }

    private PrimitiveDenseStore(double[] dataArray) {
        this(dataArray.length, 1, dataArray);
    }

    private PrimitiveDenseStore(int numbRows) {
        this(numbRows, 1);
    }

    PrimitiveDenseStore(int numbRows, int numbCols) {
        super(numbRows * numbCols);
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.getPrimitive(this.myRowDim, this.myColDim);
    }

    PrimitiveDenseStore(int numbRows, int numbCols, double[] dataArray) {
        super(dataArray);
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.getPrimitive(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<?> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, supplied.doubleValue(i, j));
            }
        }
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public Double aggregateAll(final Aggregator aggregator) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        final AggregatorFunction<Double> mainAggr = aggregator.getFunction(PrimitiveAggregator.getSet());
        if (mainAggr.isMergeable() && tmpColDim > AggregateAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void conquer(int first, int limit) {
                    AggregatorFunction<Double> tmpPartAggr = aggregator.getFunction(PrimitiveAggregator.getSet());
                    PrimitiveDenseStore.this.visit(tmpRowDim * first, tmpRowDim * limit, 1, tmpPartAggr);
                    AggregatorFunction aggregatorFunction = mainAggr;
                    synchronized (aggregatorFunction) {
                        mainAggr.merge(tmpPartAggr.get());
                    }
                }
            };
            tmpConquerer.invoke(0, tmpColDim, AggregateAll.THRESHOLD);
        } else {
            this.visit(0, this.size(), 1, (VoidFunction<Double>)mainAggr);
        }
        return (Double)mainAggr.get();
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((Primitive64Array)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyCholesky.invoke(tmpData, PrimitiveDenseStore.this.myRowDim, first, limit, tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((Primitive64Array)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke(tmpData, PrimitiveDenseStore.this.myRowDim, first, limit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((Primitive64Array)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLU.invoke(tmpData, PrimitiveDenseStore.this.myRowDim, first, limit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public Array1D<Double> asList() {
        return this.myUtility.asArray1D();
    }

    public void caxpy(double aSclrA, int aColX, int aColY, int aFirstRow) {
        AXPY.invoke(this.data, aColY * this.myRowDim + aFirstRow, aSclrA, this.data, aColX * this.myRowDim + aFirstRow, 0, this.myRowDim - aFirstRow);
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<Double> transformationCollector, boolean eigenvalue) {
        double[] tmpData = this.data;
        double[] tmpCollectorData = ((PrimitiveDenseStore)transformationCollector).data;
        double[] tmpVctrWork = new double[this.getMinDim()];
        EvD1D.orthes(tmpData, tmpCollectorData, tmpVctrWork);
        double[][] tmpDiags = EvD1D.hqr2(tmpData, tmpCollectorData, eigenvalue);
        double[] aRawReal = tmpDiags[0];
        double[] aRawImag = tmpDiags[1];
        int tmpLength = Math.min(aRawReal.length, aRawImag.length);
        ComplexArray retVal = ComplexArray.make(tmpLength);
        ComplexNumber[] tmpRaw = (ComplexNumber[])retVal.data;
        for (int i = 0; i < tmpLength; ++i) {
            tmpRaw[i] = ComplexNumber.of(aRawReal[i], aRawImag[i]);
        }
        return Array1D.COMPLEX.wrap(retVal);
    }

    @Override
    public MatrixStore<Double> conjugate() {
        return this.transpose();
    }

    public PrimitiveDenseStore copy() {
        return new PrimitiveDenseStore(this.myRowDim, this.myColDim, this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<Double> destination) {
        double[] tmpData = this.data;
        int tmpRowDim = this.myRowDim;
        double[] tmpDestination = ((Primitive64Array)destination).data;
        int tmpIndex = row + column * tmpRowDim;
        double tmpDenominator = tmpData[tmpIndex];
        for (int i = row + 1; i < tmpRowDim; ++i) {
            int n = ++tmpIndex;
            double d = tmpData[n] / tmpDenominator;
            tmpData[n] = d;
            tmpDestination[i] = d;
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myUtility.doubleValue(row, col);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof MatrixStore) {
            return this.equals((MatrixStore)anObj, NumberContext.getGeneral(6));
        }
        return super.equals(anObj);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        double tmpVal;
        int tmpMin = Math.min(indexA, indexB);
        int tmpMax = Math.max(indexA, indexB);
        for (int j = 0; j < tmpMin; ++j) {
            tmpVal = this.doubleValue(tmpMin, j);
            this.set((long)tmpMin, (long)j, this.doubleValue(tmpMax, j));
            this.set((long)tmpMax, (long)j, tmpVal);
        }
        tmpVal = this.doubleValue(tmpMin, tmpMin);
        this.set((long)tmpMin, (long)tmpMin, this.doubleValue(tmpMax, tmpMax));
        this.set((long)tmpMax, (long)tmpMax, tmpVal);
        for (int ij = tmpMin + 1; ij < tmpMax; ++ij) {
            tmpVal = this.doubleValue(ij, tmpMin);
            this.set((long)ij, (long)tmpMin, this.doubleValue(tmpMax, ij));
            this.set((long)tmpMax, (long)ij, tmpVal);
        }
        for (int i = tmpMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.doubleValue(i, tmpMin);
            this.set((long)i, (long)tmpMin, this.doubleValue(i, tmpMax));
            this.set((long)i, (long)tmpMax, tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public void fillByMultiplying(Access1D<Double> left, Access1D<Double> right) {
        int complexity = (int)left.count() / this.myRowDim;
        if (left instanceof PrimitiveDenseStore) {
            if (right instanceof PrimitiveDenseStore) {
                this.multiplyNeither.invoke(this.data, PrimitiveDenseStore.cast(left).data, complexity, PrimitiveDenseStore.cast(right).data);
            } else {
                this.multiplyRight.invoke(this.data, PrimitiveDenseStore.cast(left).data, complexity, right);
            }
        } else if (right instanceof PrimitiveDenseStore) {
            this.multiplyLeft.invoke(this.data, left, complexity, PrimitiveDenseStore.cast(right).data);
        } else {
            this.multiplyBoth.invoke(this, left, complexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long col, Access1D<Double> values) {
        this.myUtility.fillColumn(row, col, (Double)((Object)values));
    }

    @Override
    public void fillColumn(long row, long col, Double value) {
        this.myUtility.fillColumn(row, col, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<Double> supplier) {
        this.myUtility.fillColumn(row, col, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, Double value) {
        this.myUtility.fillDiagonal(row, col, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<Double> supplier) {
        this.myUtility.fillDiagonal(row, col, supplier);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        if (values instanceof TransjugatedStore) {
            final TransjugatedStore transposed = (TransjugatedStore)values;
            if (this.myColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose(PrimitiveDenseStore.this.data, PrimitiveDenseStore.this.myRowDim, first, limit, transposed.getOriginal());
                    }
                };
                tmpConquerer.invoke(0, this.myColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose(this.data, this.myRowDim, 0, this.myColDim, transposed.getOriginal());
            }
        } else {
            super.fillMatching(values);
        }
    }

    @Override
    public void fillMatching(final Access1D<Double> left, final BinaryFunction<Double> function, final Access1D<Double> right) {
        int matchingCount = (int)FunctionUtils.min(this.count(), left.count(), right.count());
        if (this.myColDim > FillMatchingDual.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    PrimitiveDenseStore.invoke(PrimitiveDenseStore.this.data, first, limit, 1, (Access1D<Double>)left, (BinaryFunction<Double>)function, (Access1D<Double>)right);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingDual.THRESHOLD * FillMatchingDual.THRESHOLD);
        } else {
            Primitive64Array.invoke(this.data, 0, matchingCount, 1, left, function, right);
        }
    }

    @Override
    public void fillMatching(final UnaryFunction<Double> function, final Access1D<Double> arguments) {
        int matchingCount = (int)FunctionUtils.min(this.count(), arguments.count());
        if (this.myColDim > FillMatchingSingle.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    PrimitiveDenseStore.invoke(PrimitiveDenseStore.this.data, first, limit, 1, arguments, (UnaryFunction<Double>)function);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingSingle.THRESHOLD * FillMatchingSingle.THRESHOLD);
        } else {
            Primitive64Array.invoke(this.data, 0, matchingCount, 1, arguments, function);
        }
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, values.doubleValue(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, Double value) {
        this.myUtility.fillOne(row, col, value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<Double> supplier) {
        this.myUtility.fillOne(row, col, supplier);
    }

    @Override
    public void fillRow(long row, long col, Access1D<Double> values) {
        this.myUtility.fillRow(row, col, (Double)((Object)values));
    }

    @Override
    public void fillRow(long row, long col, Double value) {
        this.myUtility.fillRow(row, col, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<Double> supplier) {
        this.myUtility.fillRow(row, col, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<Double> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke(this.data, this.myRowDim, row, column, (Householder.Primitive)destination);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<Double> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke(this.data, this.myRowDim, row, column, (Householder.Primitive)destination);
    }

    @Override
    public final MatrixStore<Double> get() {
        return this;
    }

    @Override
    public Double get(long row, long col) {
        return this.myUtility.get(row, col);
    }

    @Override
    public int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public long indexOfLargestInColumn(long row, long col) {
        return this.myUtility.indexOfLargestInColumn(row, col);
    }

    @Override
    public long indexOfLargestInRow(long row, long col) {
        return this.myUtility.indexOfLargestInRow(row, col);
    }

    @Override
    public long indexOfLargestOnDiagonal(long first) {
        return this.myUtility.indexOfLargestOnDiagonal(first);
    }

    @Override
    public boolean isAbsolute(long row, long col) {
        return this.myUtility.isAbsolute(row, col);
    }

    @Override
    public boolean isColumnSmall(long row, long col, double comparedTo) {
        return this.myUtility.isColumnSmall(row, col, comparedTo);
    }

    @Override
    public boolean isRowSmall(long row, long col, double comparedTo) {
        return this.myUtility.isRowSmall(row, col, comparedTo);
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return this.myUtility.isSmall(row, col, comparedTo);
    }

    @Override
    public void modifyAll(final UnaryFunction<Double> modifier) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > ModifyAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    PrimitiveDenseStore.this.modify(tmpRowDim * first, tmpRowDim * limit, 1, modifier);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, ModifyAll.THRESHOLD);
        } else {
            this.modify(tmpRowDim * 0, tmpRowDim * tmpColDim, 1, modifier);
        }
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyColumn(row, col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyDiagonal(row, col, modifier);
    }

    @Override
    public void modifyMatching(Access1D<Double> left, BinaryFunction<Double> function) {
        long tmpLimit = FunctionUtils.min(left.count(), this.count(), this.count());
        for (long i = 0L; i < tmpLimit; ++i) {
            this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<Double> function, Access1D<Double> right) {
        long tmpLimit = FunctionUtils.min(this.count(), right.count(), this.count());
        for (long i = 0L; i < tmpLimit; ++i) {
            this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<Double> modifier) {
        double tmpValue = this.doubleValue(row, col);
        tmpValue = modifier.invoke(tmpValue);
        this.set(row, col, tmpValue);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyRow(row, col, modifier);
    }

    @Override
    public MatrixStore<Double> multiply(MatrixStore<Double> right) {
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(this.myRowDim, right.count() / (long)this.myColDim);
        if (right instanceof PrimitiveDenseStore) {
            retVal.multiplyNeither.invoke(retVal.data, this.data, this.myColDim, PrimitiveDenseStore.cast(right).data);
        } else {
            retVal.multiplyRight.invoke(retVal.data, this.data, this.myColDim, right);
        }
        return retVal;
    }

    @Override
    public Double multiplyBoth(Access1D<Double> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.makeZero(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (Double)tmpStep2.get(0L);
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, PrimitiveFunction.NEGATE);
    }

    @Override
    public PhysicalStore.Factory<Double, PrimitiveDenseStore> physical() {
        return FACTORY;
    }

    @Override
    public final ElementsConsumer<Double> regionByColumns(int ... columns) {
        return new ElementsConsumer.ColumnsRegion<Double>(this, this.multiplyBoth, columns);
    }

    @Override
    public final ElementsConsumer<Double> regionByLimits(int rowLimit, int columnLimit) {
        return new ElementsConsumer.LimitRegion<Double>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public final ElementsConsumer<Double> regionByOffsets(int rowOffset, int columnOffset) {
        return new ElementsConsumer.OffsetRegion<Double>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public final ElementsConsumer<Double> regionByRows(int ... rows) {
        return new ElementsConsumer.RowsRegion<Double>(this, this.multiplyBoth, rows);
    }

    @Override
    public final ElementsConsumer<Double> regionByTransposing() {
        return new ElementsConsumer.TransposedRegion<Double>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int low, int high, double cos, double sin) {
        RotateRight.invoke(this.data, this.myRowDim, low, high, cos, sin);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void set(long row, long col, Number value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void setToIdentity(int col) {
        this.myUtility.set((long)col, (long)col, PrimitiveMath.ONE);
        this.myUtility.fillColumn((long)(col + 1), (long)col, PrimitiveMath.ZERO);
    }

    @Override
    public Array1D<Double> sliceColumn(long row, long col) {
        return this.myUtility.sliceColumn(row, col);
    }

    @Override
    public Array1D<Double> sliceDiagonal(long row, long col) {
        return this.myUtility.sliceDiagonal(row, col);
    }

    @Override
    public Array1D<Double> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<Double> sliceRow(long row, long col) {
        return this.myUtility.sliceRow(row, col);
    }

    @Override
    public void substituteBackwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteBackwards.invoke(PrimitiveDenseStore.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, hermitian);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, hermitian);
        }
    }

    @Override
    public void substituteForwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteForwards.invoke(PrimitiveDenseStore.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, identity);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, identity);
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<Double> receiver) {
        receiver.fillMatching(this);
    }

    public PrimitiveScalar toScalar(long row, long column) {
        return PrimitiveScalar.of(this.doubleValue(row, column));
    }

    @Override
    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<Double> transformation, int firstColumn) {
        final Householder.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        final double[] tmpData = this.data;
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim - firstColumn > HouseholderLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    HouseholderLeft.invoke(tmpData, tmpRowDim, first, limit, tmpTransf);
                }
            };
            tmpConquerer.invoke(firstColumn, tmpColDim, HouseholderLeft.THRESHOLD);
        } else {
            HouseholderLeft.invoke(tmpData, tmpRowDim, firstColumn, tmpColDim, tmpTransf);
        }
    }

    @Override
    public void transformLeft(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateLeft.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveFunction.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<Double> transformation, int firstRow) {
        final Householder.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        final double[] tmpData = this.data;
        final int tmpRowDim = this.myRowDim;
        final int tmpColDim = this.myColDim;
        final double[] tmpWorker = this.getWorkerColumn();
        if (tmpRowDim - firstRow > HouseholderRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    HouseholderRight.invoke(tmpData, tmpRowDim, first, limit, tmpColDim, tmpTransf, tmpWorker);
                }
            };
            tmpConquerer.invoke(firstRow, tmpRowDim, HouseholderRight.THRESHOLD);
        } else {
            HouseholderRight.invoke(tmpData, tmpRowDim, firstRow, tmpRowDim, tmpColDim, tmpTransf, tmpWorker);
        }
    }

    @Override
    public void transformRight(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateRight.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveFunction.NEGATE);
        }
    }

    @Override
    public void transformSymmetric(Householder<Double> transformation) {
        HouseholderHermitian.invoke(this.data, PrimitiveDenseStore.cast(transformation), this.getWorkerColumn());
    }

    @Override
    public MatrixStore<Double> transpose() {
        return new TransposedStore<Double>(this);
    }

    @Override
    public void tred2(BasicArray<Double> mainDiagonal, BasicArray<Double> offDiagonal, boolean yesvecs) {
        HouseholderHermitian.tred2j(this.data, ((Primitive64Array)mainDiagonal).data, ((Primitive64Array)offDiagonal).data, yesvecs);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitColumn(row, col, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitDiagonal(row, col, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitRow(row, col, visitor);
    }

    private double[] getWorkerColumn() {
        if (this.myWorkerColumn != null) {
            Arrays.fill(this.myWorkerColumn, PrimitiveMath.ZERO);
        } else {
            this.myWorkerColumn = new double[this.myRowDim];
        }
        return this.myWorkerColumn;
    }

    int getColDim() {
        return this.myColDim;
    }

    int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    int getRowDim() {
        return this.myRowDim;
    }

    public static interface PrimitiveMultiplyRight {
        public void invoke(double[] var1, double[] var2, int var3, Access1D<?> var4);
    }

    public static interface PrimitiveMultiplyNeither {
        public void invoke(double[] var1, double[] var2, int var3, double[] var4);
    }

    public static interface PrimitiveMultiplyLeft {
        public void invoke(double[] var1, Access1D<?> var2, int var3, double[] var4);
    }

    public static interface PrimitiveMultiplyBoth
    extends ElementsConsumer.FillByMultiplying<Double> {
    }
}

