/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.imglib2.img.NativeImg;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.AbstractNativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.ComparableLabelMultisetEntryList;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelUtils;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.RefList;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Fraction;

public class LabelMultisetType
extends AbstractNativeType<LabelMultisetType>
implements IntegerType<LabelMultisetType> {
    public static final LabelMultisetType type = new LabelMultisetType();
    private NativeImg<?, VolatileLabelMultisetArray> img;
    private VolatileLabelMultisetArray access;
    private final LabelMultisetEntryList entries = new LabelMultisetEntryList(){

        @Override
        public LabelMultisetEntry createRef() {
            if (LabelMultisetType.this.reference == null) {
                return (LabelMultisetEntry)super.createRef();
            }
            return LabelMultisetType.this.reference;
        }

        @Override
        public void releaseRef(LabelMultisetEntry ref) {
            if (LabelMultisetType.this.reference != ref) {
                super.releaseRef(ref);
            }
        }

        @Override
        public RefList.RefIterator<LabelMultisetEntry> iterator() {
            return new RefList.RefIterator<LabelMultisetEntry>(){
                private LabelMultisetEntry ref;
                private int i;
                {
                    this.ref = LabelMultisetType.this.reference != null ? LabelMultisetType.this.reference : this.createRef();
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    if (this.i < this.size()) {
                        return true;
                    }
                    this.release();
                    return false;
                }

                @Override
                public LabelMultisetEntry next() {
                    return this.get(this.i++, this.ref);
                }

                @Override
                public void release() {
                    if (LabelMultisetType.this.reference == null && this.ref != null) {
                        this.releaseRef(this.ref);
                        this.ref = null;
                    }
                }

                @Override
                public void reset() {
                    if (LabelMultisetType.this.reference == null && this.ref == null) {
                        this.ref = this.createRef();
                    }
                    this.i = 0;
                }
            };
        }
    };
    private final Set<Entry<Label>> entrySet;
    private LabelMultisetEntry reference = null;

    public LabelMultisetType(NativeImg<?, VolatileLabelMultisetArray> img) {
        this(img, null);
    }

    public LabelMultisetType(VolatileLabelMultisetArray access) {
        this(null, access);
    }

    public LabelMultisetType() {
        this(null, new VolatileLabelMultisetArray(1, true, new long[]{-2L}));
    }

    public LabelMultisetType(LabelMultisetEntry entry) {
        this();
        this.add(entry);
    }

    public LabelMultisetType(LabelMultisetEntryList entries) {
        this();
        this.addAll(entries);
    }

    private LabelMultisetType(NativeImg<?, VolatileLabelMultisetArray> img, VolatileLabelMultisetArray access) {
        this(img, access, 0);
    }

    private LabelMultisetType(NativeImg<?, VolatileLabelMultisetArray> img, VolatileLabelMultisetArray access, int idx) {
        this.img = img;
        this.access = access;
        this.i.set(idx);
        this.entrySet = new AbstractSet<Entry<Label>>(){
            private final RefList.RefIterator<Entry<Label>> iterator = new RefList.RefIterator<Entry<Label>>(){
                private final RefList.RefIterator<LabelMultisetEntry> it;
                {
                    this.it = LabelMultisetType.this.entries.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public LabelMultisetEntry next() {
                    return (LabelMultisetEntry)this.it.next();
                }

                @Override
                public void release() {
                    if (LabelMultisetType.this.reference == null) {
                        this.it.release();
                    }
                }

                @Override
                public void reset() {
                    this.it.reset();
                }
            };

            @Override
            public RefList.RefIterator<Entry<Label>> iterator() {
                this.iterator.reset();
                return this.iterator;
            }

            @Override
            public int size() {
                return LabelMultisetType.this.entries.size();
            }

            @Override
            public Stream<Entry<Label>> parallelStream() {
                throw new UnsupportedOperationException("Streams are not compatible with " + this.getClass().getName() + " because its iterator reuses the same reference.");
            }
        };
        if (this.access != null) {
            this.updateEntriesLocation();
        }
    }

    public void add(long id, int count) {
        this.add(new LabelMultisetEntry(id, count));
    }

    public void add(LabelMultisetEntry entry) {
        Label label = entry.id;
        LabelMultisetEntryList entryList = this.labelMultisetEntries();
        entryList.add(entry);
        long argMax = this.argMax();
        long id = label.id();
        if (id == argMax) {
            return;
        }
        if (entryList.size() == 1 || this.count(id) > this.count(argMax)) {
            this.updateArgMax(id);
        }
    }

    public void addAll(Collection<? extends LabelMultisetEntry> entries) {
        this.labelMultisetEntries().addAll(entries);
        this.updateArgMax();
    }

    public void set(long id, int count) {
        this.labelMultisetEntries().clear();
        this.add(id, count);
    }

    public void set(Collection<? extends LabelMultisetEntry> entries) {
        this.labelMultisetEntries().clear();
        this.addAll(entries);
    }

    public void clear() {
        this.labelMultisetEntries().clear();
        this.updateArgMax();
    }

    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    public void updateContainer(Object c) {
        this.access = (VolatileLabelMultisetArray)this.img.update(c);
    }

    public LabelMultisetType createVariable() {
        return new LabelMultisetType();
    }

    public LabelMultisetType copy() {
        if (this.img != null) {
            LabelMultisetType labelMultisetType = new LabelMultisetType();
            labelMultisetType.labelMultisetEntries().addAll(this.labelMultisetEntries());
            return labelMultisetType;
        }
        long byteSize = this.access.getListData().size();
        int longSize = this.access.getListData().data.length;
        LongMappedAccessData listDataCopy = LongMappedAccessData.factory.createStorage(byteSize);
        System.arraycopy(this.access.getListData().data, 0, listDataCopy.data, 0, longSize);
        int[] data = this.access.getCurrentStorageArray();
        int[] dataCopy = new int[data.length];
        System.arraycopy(data, 0, dataCopy, 0, data.length);
        VolatileLabelMultisetArray accessCopy = new VolatileLabelMultisetArray(dataCopy, listDataCopy, this.access.getListDataUsedSizeInBytes(), this.access.isValid(), this.access.argMaxCopy());
        return new LabelMultisetType(null, accessCopy);
    }

    public int listHashCode() {
        return this.labelMultisetEntries().hashCode();
    }

    public void set(LabelMultisetType c) {
        if (c.img != null) {
            this.img = null;
            this.i.set(0);
            this.clear();
            this.addAll(c.labelMultisetEntries());
        } else {
            long byteSize = c.access.getListData().size();
            int longSize = c.access.getListData().data.length;
            LongMappedAccessData listDataCopy = LongMappedAccessData.factory.createStorage(byteSize);
            System.arraycopy(c.access.getListData().data, 0, listDataCopy.data, 0, longSize);
            int[] data = c.access.getCurrentStorageArray();
            int[] dataCopy = new int[data.length];
            System.arraycopy(data, 0, dataCopy, 0, data.length);
            VolatileLabelMultisetArray accessCopy = new VolatileLabelMultisetArray(dataCopy, listDataCopy, c.access.getListDataUsedSizeInBytes(), c.access.isValid(), c.access.argMaxCopy());
            this.img = null;
            this.i.set(0);
            this.access = accessCopy;
            this.updateEntriesLocation();
        }
    }

    public NativeTypeFactory<LabelMultisetType, ?> getNativeTypeFactory() {
        throw new UnsupportedOperationException();
    }

    public LabelMultisetType duplicateTypeOnSameNativeImg() {
        return new LabelMultisetType(this.img);
    }

    public int size() {
        this.updateEntriesLocation();
        return this.entries.multisetSize();
    }

    public boolean isEmpty() {
        return this.labelMultisetEntries().isEmpty();
    }

    public boolean contains(Label l, LabelMultisetEntry ref) {
        return this.contains(l.id(), ref);
    }

    public boolean contains(Label l) {
        return this.contains(l.id());
    }

    public boolean contains(long id, LabelMultisetEntry ref) {
        this.updateEntriesLocation();
        return this.entries.binarySearch(id, ref) >= 0;
    }

    public boolean contains(long id) {
        this.updateEntriesLocation();
        return this.entries.binarySearch(id) >= 0;
    }

    public boolean containsAll(long[] ids) {
        this.updateEntriesLocation();
        for (long id : ids) {
            if (this.entries.binarySearch(id) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] ids, LabelMultisetEntry ref) {
        this.updateEntriesLocation();
        for (long id : ids) {
            if (this.entries.binarySearch(id, ref) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<? extends Label> c) {
        this.updateEntriesLocation();
        for (Label label : c) {
            if (this.entries.binarySearch(label.id()) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<? extends Label> c, LabelMultisetEntry ref) {
        this.updateEntriesLocation();
        for (Label label : c) {
            if (this.entries.binarySearch(label.id(), ref) >= 0) continue;
            return false;
        }
        return true;
    }

    public int count(Label l) {
        return this.count(l.id());
    }

    public int count(long id) {
        this.updateEntriesLocation();
        int pos = this.entries.binarySearch(id);
        if (pos < 0) {
            return 0;
        }
        return ((LabelMultisetEntry)this.entries.get(pos)).getCount();
    }

    public int countWithRef(long id, LabelMultisetEntry ref) {
        this.updateEntriesLocation();
        int pos = this.entries.binarySearch(id, ref);
        if (pos < 0) {
            return 0;
        }
        return ((LabelMultisetEntry)this.entries.get(pos)).getCount();
    }

    public Set<Entry<Label>> entrySet() {
        this.updateEntriesLocation();
        return this.entrySet;
    }

    public Set<Entry<Label>> entrySetWithRef(LabelMultisetEntry ref) {
        this.reference = ref;
        return this.entrySet();
    }

    LabelMultisetEntryList labelMultisetEntries() {
        this.entrySet();
        return this.entries;
    }

    private void updateEntriesLocation() {
        if (this.access.getCurrentStorageArray().length == 0) {
            return;
        }
        this.access.getValue(this.i.get(), this.entries);
    }

    public String toString() {
        this.updateEntriesLocation();
        return this.entries.toString();
    }

    boolean isValid() {
        return this.access.isValid();
    }

    public boolean valueEquals(LabelMultisetType other) {
        LabelMultisetEntryList lmel = this.labelMultisetEntries();
        LabelMultisetEntryList otherLmel = other.labelMultisetEntries();
        if (lmel.size() != otherLmel.size()) {
            return false;
        }
        Iterator ai = lmel.iterator();
        Iterator bi = otherLmel.iterator();
        while (ai.hasNext()) {
            LabelMultisetEntry a = (LabelMultisetEntry)ai.next();
            LabelMultisetEntry b = (LabelMultisetEntry)bi.next();
            if (a.getId() == b.getId() && a.getCount() == b.getCount()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LabelMultisetType) {
            return this.valueEquals((LabelMultisetType)((Object)obj));
        }
        return false;
    }

    public VolatileLabelMultisetArray getAccess() {
        return this.access;
    }

    public void inc() {
        throw new UnsupportedOperationException();
    }

    public void dec() {
        throw new UnsupportedOperationException();
    }

    public double getMaxValue() {
        return this.argMax();
    }

    public double getMinValue() {
        throw new UnsupportedOperationException();
    }

    public double getMinIncrement() {
        throw new UnsupportedOperationException();
    }

    public int getBitsPerPixel() {
        throw new UnsupportedOperationException();
    }

    public double getRealDouble() {
        return this.argMax();
    }

    public float getRealFloat() {
        return this.argMax();
    }

    public double getImaginaryDouble() {
        return 0.0;
    }

    public float getImaginaryFloat() {
        return 0.0f;
    }

    public void setReal(float f) {
        throw new UnsupportedOperationException();
    }

    public void setReal(double f) {
        throw new UnsupportedOperationException();
    }

    public void setImaginary(float f) {
        throw new UnsupportedOperationException();
    }

    public void setImaginary(double f) {
        throw new UnsupportedOperationException();
    }

    public void setComplexNumber(float r, float i) {
        throw new UnsupportedOperationException();
    }

    public void setComplexNumber(double r, double i) {
        throw new UnsupportedOperationException();
    }

    public float getPowerFloat() {
        return this.getRealFloat();
    }

    public double getPowerDouble() {
        return this.getRealDouble();
    }

    public float getPhaseFloat() {
        return 0.0f;
    }

    public double getPhaseDouble() {
        return 0.0;
    }

    public void complexConjugate() {
        throw new UnsupportedOperationException();
    }

    public void add(LabelMultisetType c) {
        this.addAll(c.labelMultisetEntries());
    }

    public void mul(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void sub(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void div(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void setOne() {
        this.set(1L, 1);
    }

    public void setZero() {
        this.set(0L, 1);
    }

    public void mul(float c) {
        throw new UnsupportedOperationException();
    }

    public void mul(double c) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(LabelMultisetType arg0) {
        long theirs;
        long ours = this.argMax();
        int argMaxCompare = Long.compare(ours, theirs = arg0.argMax());
        if (argMaxCompare != 0) {
            return argMaxCompare;
        }
        int countCompare = Long.compare(this.count(ours), this.count(theirs));
        if (countCompare != 0) {
            return countCompare;
        }
        ComparableLabelMultisetEntryList thisComparable = new ComparableLabelMultisetEntryList(this.labelMultisetEntries());
        ComparableLabelMultisetEntryList otherComparable = new ComparableLabelMultisetEntryList(arg0.labelMultisetEntries());
        return thisComparable.compareTo(otherComparable);
    }

    public int getInteger() {
        return (int)this.getIntegerLong();
    }

    public long getIntegerLong() {
        return this.argMax();
    }

    public BigInteger getBigInteger() {
        BigInteger mask = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        return BigInteger.valueOf(this.argMax()).and(mask);
    }

    public void setInteger(int f) {
        this.set(f, 1);
    }

    public void setInteger(long f) {
        this.set(f, 1);
    }

    public void setBigInteger(BigInteger b) {
        throw new UnsupportedOperationException();
    }

    public long argMax() {
        return this.access.argMax(this.i.get());
    }

    public void updateArgMax() {
        this.updateArgMax(LabelUtils.getArgMax(this.labelMultisetEntries()));
    }

    public void updateArgMax(long id) {
        this.access.setArgMax(this.i.get(), id);
    }

    public static LabelMultisetType singleEntryWithSingleOccurrence() {
        return LabelMultisetType.singleEntryWithNumOccurrences(1);
    }

    public static LabelMultisetType singleEntryWithNumOccurrences(int numOccurrences) {
        return new LabelMultisetType(new LabelMultisetEntry(-2L, numOccurrences));
    }

    public void pow(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void pow(double d) {
        throw new UnsupportedOperationException();
    }

    public static class EmptyLabelMultisetTypeGenerator
    implements BiFunction<CellGrid, long[], byte[]> {
        private static int numElements(int[] size) {
            int n = 1;
            for (int s : size) {
                n *= s;
            }
            return n;
        }

        @Override
        public byte[] apply(CellGrid cellGrid, long[] cellPos) {
            long[] cellMin = new long[cellPos.length];
            int[] cellDims = new int[cellMin.length];
            Arrays.setAll(cellMin, d -> cellPos[d] * (long)cellGrid.cellDimension(d));
            cellGrid.getCellDimensions(cellPos, cellMin, cellDims);
            int numElements = EmptyLabelMultisetTypeGenerator.numElements(cellDims);
            LongMappedAccessData listData = LongMappedAccessData.factory.createStorage(0L);
            LabelMultisetEntryList list = new LabelMultisetEntryList(listData, 0L);
            list.createListAt(listData, 0L);
            int listSize = (int)list.getSizeInBytes();
            byte[] bytes = new byte[4 + numElements * 8 + numElements * 4 + listSize];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.putInt(numElements);
            for (int i = 0; i < listSize; ++i) {
                bb.put(ByteUtils.getByte(listData.getData(), i));
            }
            return bytes;
        }
    }

    public static interface Entry<E> {
        public E getElement();

        public int getCount();
    }
}

