/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArrowShape
implements Shape {
    private GeneralPath path = new GeneralPath();
    private Point2D start;
    private Point2D end;
    private ArrowStyle style;
    private double length;
    private float[] points = new float[10];

    public ArrowShape() {
        this(ArrowStyle.DELTA);
    }

    public ArrowShape(ArrowStyle _style) {
        this(_style, 10.0);
    }

    public ArrowShape(ArrowStyle _style, double _length) {
        this.style = _style;
        this.length = _length;
    }

    public ArrowShape clone() {
        ArrowShape new_arrow = new ArrowShape(this.style, this.length);
        new_arrow.setStartPoint(this.start);
        new_arrow.setEndPoint(this.end);
        return new_arrow;
    }

    public String toString() {
        return String.format("ArrowShape: start=(%.1f,%.1f), end=(%.1f,%.1f), style=%s, length=%.0f", new Object[]{this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY(), this.style, this.length});
    }

    public void setStartPoint(Point2D start) {
        this.start = start;
    }

    public Point2D getStartPoint() {
        return this.start;
    }

    public void setEndPoint(Point2D end) {
        this.end = end;
    }

    public Point2D getEndPoint() {
        return this.end;
    }

    public void setLength(double _length) {
        this.length = _length;
    }

    public double getLength() {
        return this.length;
    }

    public ArrowStyle getStyle() {
        return this.style;
    }

    public void setStyle(ArrowStyle _style) {
        this.style = _style;
    }

    private Shape getPath() {
        this.path.reset();
        if (this.start != null || this.end != null) {
            switch (this.style) {
                case DELTA: 
                case THICK: 
                case THIN: {
                    this.calculatePoints();
                    this.getPathFromPoints();
                    break;
                }
                case CIRCLE: {
                    double y = this.end.getY() - this.start.getY();
                    double x = this.end.getX() - this.start.getX();
                    double alpha = Math.atan2(y, x);
                    double end_x = this.start.getX() + x - this.length / 2.0 * Math.cos(alpha);
                    double end_y = this.start.getY() + y - this.length / 2.0 * Math.sin(alpha);
                    this.path.append(new Line2D.Double(this.start.getX(), this.start.getY(), end_x, end_y).getPathIterator(null), false);
                    Ellipse2D.Double circle = new Ellipse2D.Double(this.end.getX() - this.length / 2.0, this.end.getY() - this.length / 2.0, this.length, this.length);
                    this.path.append(circle, false);
                }
            }
        }
        return this.path;
    }

    private void calculatePoints() {
        double tip = 0.0;
        this.points[0] = (float)this.start.getX();
        this.points[1] = (float)this.start.getY();
        this.points[6] = (float)this.end.getX();
        this.points[7] = (float)this.end.getY();
        double alpha = Math.atan2(this.points[7] - this.points[1], this.points[6] - this.points[0]);
        double SL = 0.0;
        switch (this.style) {
            case DELTA: {
                tip = Math.toRadians(20.0);
                double base = Math.toRadians(90.0);
                this.points[2] = (float)((double)this.points[6] - this.length * Math.cos(alpha));
                this.points[3] = (float)((double)this.points[7] - this.length * Math.sin(alpha));
                SL = this.length * Math.sin(base) / Math.sin(base + tip);
                break;
            }
            case THICK: {
                tip = Math.toRadians(20.0);
                double base = Math.toRadians(120.0);
                this.points[2] = (float)((double)this.points[6] - this.length * Math.cos(alpha));
                this.points[3] = (float)((double)this.points[7] - this.length * Math.sin(alpha));
                SL = this.length * Math.sin(base) / Math.sin(base + tip);
                break;
            }
            case THIN: {
                tip = Math.toRadians(30.0);
                this.points[2] = this.points[6];
                this.points[3] = this.points[7];
                SL = this.length;
            }
        }
        this.points[4] = (float)((double)this.points[6] - SL * Math.cos(alpha + tip));
        this.points[5] = (float)((double)this.points[7] - SL * Math.sin(alpha + tip));
        this.points[8] = (float)((double)this.points[6] - SL * Math.cos(alpha - tip));
        this.points[9] = (float)((double)this.points[7] - SL * Math.sin(alpha - tip));
    }

    private void getPathFromPoints() {
        this.path.moveTo(this.points[0], this.points[1]);
        this.path.lineTo(this.points[2], this.points[3]);
        this.path.moveTo(this.points[2], this.points[3]);
        if (this.style == ArrowStyle.THIN) {
            this.path.moveTo(this.points[4], this.points[5]);
        } else {
            this.path.lineTo(this.points[4], this.points[5]);
        }
        this.path.lineTo(this.points[6], this.points[7]);
        this.path.lineTo(this.points[8], this.points[9]);
        this.path.lineTo(this.points[2], this.points[3]);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getPath().contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.getPath().contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getPath().contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.getPath().contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.getPath().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getPath().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPath().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPath().getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.getPath().intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.getPath().intersects(x, y, w, h);
    }

    public static enum ArrowStyle {
        DELTA,
        THICK,
        THIN,
        CIRCLE;

    }
}

