/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import bdv.util.BdvOptions;
import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.bdv.N5Viewer;
import org.janelia.saalfeldlab.n5.bdv.N5ViewerCreator;
import org.janelia.saalfeldlab.n5.ui.DataSelection;

public class N5ViewerPlugin
implements PlugIn {
    public static final String COMMAND_NAME = "HDF5/N5/Zarr/OME-NGFF Viewer";
    public static final String N5_URIS_KEY = "urls";
    private boolean initialRecorderState = Recorder.record;

    public static final void main(String ... args) {
        new ImageJ();
        new N5ViewerPlugin().run("");
    }

    public N5ViewerPlugin() {
        Recorder.record = false;
    }

    public void run(String args) {
        boolean isMacro;
        String macroOptions = Macro.getOptions();
        String options = args;
        if (options == null || options.isEmpty()) {
            options = macroOptions;
        }
        boolean bl = isMacro = options != null && !options.isEmpty();
        if (isMacro) {
            this.initialRecorderState = Recorder.record;
            Recorder.record = false;
            String n5Uris = Macro.getValue((String)options, (String)N5_URIS_KEY, (String)"");
            N5Viewer.show(n5Uris.split(","), BdvOptions.options().frameTitle("N5 Viewer"));
            Recorder.record = this.initialRecorderState;
        } else {
            new N5ViewerCreator().openViewer(IJ::handleException, null, this::selectionConsumer, this::cancelConsumer);
        }
    }

    protected static void recordMacro(String n5Uris) {
        if (!Recorder.record) {
            return;
        }
        Recorder.setCommand((String)COMMAND_NAME);
        Recorder.resetCommandOptions();
        Recorder.recordOption((String)N5_URIS_KEY, (String)n5Uris);
        Recorder.getCommandOptions();
        Recorder.saveCommand();
        Recorder.getCommandOptions();
    }

    private void selectionConsumer(DataSelection selection) {
        Recorder.record = this.initialRecorderState;
        if (Recorder.record) {
            URI rootUri = selection.n5.getURI();
            String n5Uris = selection.metadata.stream().map(m -> {
                try {
                    return N5URI.from((String)rootUri.toString(), (String)m.getPath(), null).toString();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }).filter(x -> x != null).collect(Collectors.joining(","));
            N5ViewerPlugin.recordMacro(n5Uris);
        }
    }

    private void cancelConsumer(Void v) {
        Recorder.record = this.initialRecorderState;
    }
}

