/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.template;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.scijava.app.AppService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.template.TemplateSearchResult;
import org.scijava.util.FileUtils;

@Plugin(type=Searcher.class, priority=9990.0)
public class TemplateSearcher
implements Searcher {
    @Parameter
    private AppService appService;

    @Override
    public String title() {
        return "Script templates";
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        String templatePath = "script_templates";
        File baseDir = this.appService.getApp().getBaseDirectory();
        Map templates = FileUtils.findResources(null, (String)"script_templates", (File)baseDir);
        LinkedHashMap matches = new LinkedHashMap();
        templates.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(text.toLowerCase())).forEach(entry -> {
            URL cfr_ignored_0 = (URL)matches.put(entry.getKey(), entry.getValue());
        });
        return matches.entrySet().stream().map(entry -> new TemplateSearchResult((String)entry.getKey(), (URL)entry.getValue())).collect(Collectors.toList());
    }
}

