/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class TextFieldFocus
extends TextField
implements FocusListener {
    private String currentText;
    private String actionCommand;

    public TextFieldFocus() {
        this("", "TextFieldFocus text changed");
    }

    public TextFieldFocus(int columns) {
        this("", "TextFieldFocus text changed");
        this.setColumns(columns);
    }

    public TextFieldFocus(String text, int columns) {
        this(text, "TextFieldFocus text changed");
        this.setColumns(columns);
    }

    public TextFieldFocus(String text, int columns, String actionCommand) {
        this(text, actionCommand);
        this.setColumns(columns);
    }

    public TextFieldFocus(String text, String actionCommand) {
        super(text);
        this.currentText = text;
        this.enableEvents(128L);
        this.addFocusListener(this);
        this.actionCommand = actionCommand;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
    }

    public void setActionCommand(String newCommand) {
        this.actionCommand = newCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    protected void processActionEvent(ActionEvent e) {
        String tempText = this.getText();
        if (e.getSource() == this && !tempText.equals(this.currentText)) {
            this.currentText = tempText;
            super.processActionEvent(new ActionEvent(this, e.getID(), this.actionCommand, e.getModifiers()));
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this) {
            this.processActionEvent(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

